/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.ui.options.general.AdvancedProxyPanel;
import org.netbeans.core.ui.options.general.GeneralOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private GeneralOptionsModel model;
    private HtmlBrowser.FactoryEditor editor;
    private AdvancedProxyPanel advancedPanel;
    private boolean valid = true;
    private JButton bMoreProxy;
    private JComboBox cbWebBrowser;
    private JButton editBrowserButton;
    private JLabel errorLabel;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBox jUsageCheck;
    private JLabel lProxyHost;
    private JLabel lProxyPort;
    private JLabel lUsage;
    private JLabel lWebBrowser;
    private JLabel lWebProxy;
    private JLabel lblLearnMore;
    private JLabel lblUsageInfo;
    private JRadioButton rbHTTPProxy;
    private JRadioButton rbNoProxy;
    private JRadioButton rbUseSystemProxy;
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;

    public GeneralOptionsPanel() {
        this.initComponents();
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(color);
        Image image = ImageUtilities.loadImage((String)"org/netbeans/core/ui/resources/error.gif");
        this.errorLabel.setIcon(new ImageIcon(image));
        this.errorLabel.setVisible(false);
        GeneralOptionsPanel.loc(this.lWebBrowser, "Web_Browser");
        GeneralOptionsPanel.loc(this.lWebProxy, "Web_Proxy");
        GeneralOptionsPanel.loc(this.lProxyHost, "Proxy_Host");
        GeneralOptionsPanel.loc(this.lProxyPort, "Proxy_Port");
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser", new String[0]));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port", new String[0]));
        this.rbNoProxy.addActionListener(this);
        this.rbUseSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfProxyHost.addActionListener(this);
        this.tfProxyPort.addActionListener(this);
        this.tfProxyPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNoProxy);
        buttonGroup.add(this.rbUseSystemProxy);
        buttonGroup.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbUseSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        GeneralOptionsPanel.loc(this.lUsage, "Usage_Statistics");
        this.lUsage.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Statistics", new String[0]));
        this.lUsage.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Statistics", new String[0]));
        GeneralOptionsPanel.loc(this.jUsageCheck, "Usage_Check");
        this.jUsageCheck.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Check", new String[0]));
        this.jUsageCheck.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Check", new String[0]));
        this.lblUsageInfo.setText(GeneralOptionsPanel.loc("CTL_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Info", new String[0]));
        this.lblLearnMore.setText(GeneralOptionsPanel.loc("CTL_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Learn_More", new String[0]));
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        if (System.getProperty("nb.show.statistics.ui") == null) {
            this.jSeparator3.setVisible(false);
            this.lUsage.setVisible(false);
            this.jUsageCheck.setVisible(false);
            this.lblUsageInfo.setVisible(false);
            this.lblLearnMore.setVisible(false);
        }
    }

    private void initComponents() {
        this.lWebBrowser = new JLabel();
        this.cbWebBrowser = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.lWebProxy = new JLabel();
        this.rbNoProxy = new JRadioButton();
        this.rbUseSystemProxy = new JRadioButton();
        this.rbHTTPProxy = new JRadioButton();
        this.lProxyHost = new JLabel();
        this.tfProxyHost = new JTextField();
        this.lProxyPort = new JLabel();
        this.tfProxyPort = new JTextField();
        this.bMoreProxy = new JButton();
        this.editBrowserButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.lUsage = new JLabel();
        this.jUsageCheck = new JCheckBox();
        this.lblUsageInfo = new JLabel();
        this.lblLearnMore = new JLabel();
        this.errorLabel = new JLabel();
        this.lWebBrowser.setLabelFor(this.cbWebBrowser);
        Mnemonics.setLocalizedText((JLabel)this.lWebBrowser, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.lWebBrowser.text"));
        Mnemonics.setLocalizedText((JLabel)this.lWebProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_lWebProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbNoProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbNoProxy.text"));
        this.rbNoProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseSystemProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbUseSystemProxy.text"));
        this.rbUseSystemProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbHTTPProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Use_HTTP_Proxy", (Object[])new Object[0]));
        this.rbHTTPProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lProxyHost.setLabelFor(this.tfProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lProxyHost, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Host", (Object[])new Object[0]));
        this.tfProxyHost.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusLost(focusEvent);
            }
        });
        this.lProxyPort.setLabelFor(this.tfProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lProxyPort, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Port", (Object[])new Object[0]));
        this.tfProxyPort.setColumns(4);
        this.tfProxyPort.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bMoreProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy"));
        this.bMoreProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.bMoreProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editBrowserButton, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.text"));
        this.editBrowserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.editBrowserButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lUsage, (String)"Usage Statistics:");
        Mnemonics.setLocalizedText((AbstractButton)this.jUsageCheck, (String)"Help us improve the NetBeans IDE by providing anonymous usage data");
        Mnemonics.setLocalizedText((JLabel)this.lblUsageInfo, (String)"<html>The usage statistics help us better understand user\nrequirements and prioritize improvements in future releases. We will never\nreverse-engineer the collected data to find specific details about your projects.</html>");
        this.lblUsageInfo.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblLearnMore, (String)"<html><font color=\"#0000FF\" <u>Learn more</u></font></html>");
        this.lblLearnMore.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                GeneralOptionsPanel.this.lblLearnMoreMouseEntered(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                GeneralOptionsPanel.this.lblLearnMoreMousePressed(mouseEvent);
            }
        });
        this.errorLabel.setHorizontalAlignment(4);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lWebBrowser).add(18, 18, 18).add((Component)this.cbWebBrowser, 0, 1132, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.editBrowserButton)).add((Component)this.jSeparator2, -1, 1291, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lWebProxy).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rbNoProxy).add((Component)this.rbUseSystemProxy).add((Component)this.rbHTTPProxy).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bMoreProxy).addPreferredGap(0).add((Component)this.errorLabel, -1, 1105, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lProxyHost).addPreferredGap(1).add((Component)this.tfProxyHost, -1, 1016, Short.MAX_VALUE).add(12, 12, 12).add((Component)this.lProxyPort).addPreferredGap(1).add((Component)this.tfProxyPort, -2, -1, -2)))))).add((Component)this.jSeparator3, -1, 1291, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lUsage).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblUsageInfo, -1, 1205, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jUsageCheck).addPreferredGap(0, 838, Short.MAX_VALUE)).add((Component)this.lblLearnMore)))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lWebBrowser).add((Component)this.cbWebBrowser, -2, -1, -2).add((Component)this.editBrowserButton)).add(18, 18, 18).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbNoProxy).addPreferredGap(0).add((Component)this.rbUseSystemProxy).addPreferredGap(0).add((Component)this.rbHTTPProxy)).add((Component)this.lWebProxy)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lProxyHost).add((Component)this.tfProxyPort, -2, -1, -2).add((Component)this.tfProxyHost, -2, -1, -2).add((Component)this.lProxyPort)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bMoreProxy).add((Component)this.errorLabel)).addPreferredGap(1).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lUsage).add((Component)this.jUsageCheck)).addPreferredGap(0).add((Component)this.lblUsageInfo, -2, 52, -2).addPreferredGap(0).add((Component)this.lblLearnMore).addContainerGap(24, Short.MAX_VALUE)));
        this.bMoreProxy.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AN"));
        this.bMoreProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AD"));
        this.editBrowserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AN"));
        this.editBrowserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AD"));
        this.errorLabel.getAccessibleContext().setAccessibleName("");
    }

    private void editBrowserButtonActionPerformed(ActionEvent actionEvent) {
        final WebBrowsersOptionsModel webBrowsersOptionsModel = new WebBrowsersOptionsModel();
        WebBrowsersOptionsPanel webBrowsersOptionsPanel = new WebBrowsersOptionsPanel(webBrowsersOptionsModel, this.cbWebBrowser.getSelectedItem().toString());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)webBrowsersOptionsPanel, GeneralOptionsPanel.loc("LBL_WebBrowsersPanel_Title", new String[0]), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    webBrowsersOptionsModel.applyChanges();
                } else {
                    webBrowsersOptionsModel.discardChanges();
                }
            }
        });
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.updateWebBrowsers();
            int n = this.cbWebBrowser.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.cbWebBrowser.getItemAt(i);
                if (!e.equals(webBrowsersOptionsModel.getSelectedValue())) continue;
                this.cbWebBrowser.setSelectedItem(e);
                break;
            }
        }
    }

    private void bMoreProxyActionPerformed(ActionEvent actionEvent) {
        assert (this.model != null) : "Model found when AdvancedProxyPanel is created";
        if (this.advancedPanel == null) {
            this.advancedPanel = new AdvancedProxyPanel(this.model);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.advancedPanel, GeneralOptionsPanel.loc("LBL_AdvancedProxyPanel_Title", new String[0]));
        this.advancedPanel.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.createNotificationLineSupport();
        this.advancedPanel.update(this.tfProxyHost.getText(), this.tfProxyPort.getText());
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            this.advancedPanel.applyChanges();
            this.tfProxyHost.setText(this.model.getHttpProxyHost());
            this.tfProxyPort.setText(this.model.getHttpProxyPort());
            this.isChanged();
        }
    }

    private void tfProxyPortFocusLost(FocusEvent focusEvent) {
        this.tfProxyPort.select(0, 0);
    }

    private void tfProxyHostFocusLost(FocusEvent focusEvent) {
        this.tfProxyHost.select(0, 0);
    }

    private void tfProxyPortFocusGained(FocusEvent focusEvent) {
        this.tfProxyPort.setCaretPosition(0);
        this.tfProxyPort.selectAll();
    }

    private void tfProxyHostFocusGained(FocusEvent focusEvent) {
        this.tfProxyHost.setCaretPosition(0);
        this.tfProxyHost.selectAll();
    }

    private void lblLearnMoreMouseEntered(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblLearnMoreMousePressed(MouseEvent mouseEvent) {
        URL uRL = null;
        try {
            uRL = new URL(GeneralOptionsPanel.loc("METRICS_INFO_URL", new String[0]));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    private void validatePortValue() {
        this.clearError();
        boolean bl = this.valid;
        this.valid = this.isPortValid();
        if (!this.valid) {
            this.showError(GeneralOptionsPanel.loc("LBL_GeneralOptionsPanel_PortError", new String[0]));
        }
        if (bl != this.valid) {
            this.firePropertyChange("valid", bl, this.valid);
        }
    }

    private boolean isPortValid() {
        String string = this.tfProxyPort.getText();
        boolean bl = true;
        if (string != null && string.length() > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private void showError(String string) {
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(string);
    }

    private void clearError() {
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(GeneralOptionsPanel.class, (String)string, (Object[])stringArray);
    }

    private String getUseSystemProxyToolTip() {
        if (this.rbUseSystemProxy.isSelected()) {
            String string;
            String string2 = System.getProperty("http.proxyHost");
            if (string2 == null || string2.trim().length() == 0) {
                string = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Direct", new String[0]);
            } else {
                String string3 = System.getProperty("http.proxyPort");
                string = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Format", string2, string3);
            }
            return string;
        }
        return null;
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + string, new String[0]));
            component.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + string, new String[0]));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralOptionsPanel.loc("CTL_" + string, new String[0]));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralOptionsPanel.loc("CTL_" + string, new String[0]));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            case 1: {
                this.rbUseSystemProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            default: {
                this.rbHTTPProxy.setSelected(true);
                this.tfProxyHost.setEnabled(true);
                this.tfProxyPort.setEnabled(true);
                this.bMoreProxy.setEnabled(true);
            }
        }
        this.tfProxyHost.setText(this.model.getHttpProxyHost());
        this.tfProxyPort.setText(this.model.getHttpProxyPort());
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        this.jUsageCheck.setSelected(this.model.getUsageStatistics());
        this.updateWebBrowsers();
        this.changed = false;
    }

    private void updateWebBrowsers() {
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.cbWebBrowser.removeAllItems();
        String[] stringArray = this.editor.getTags();
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                this.cbWebBrowser.addItem(string);
            }
            this.cbWebBrowser.setSelectedItem(this.editor.getAsText());
            this.lWebBrowser.setVisible(true);
            this.cbWebBrowser.setVisible(true);
            this.editBrowserButton.setVisible(true);
            this.jSeparator2.setVisible(true);
        } else {
            this.lWebBrowser.setVisible(false);
            this.cbWebBrowser.setVisible(false);
            this.editBrowserButton.setVisible(false);
            this.jSeparator2.setVisible(false);
        }
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbUseSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setHttpProxyHost(this.tfProxyHost.getText());
        this.model.setHttpProxyPort(this.tfProxyPort.getText());
        if (this.model.useProxyAllProtocols()) {
            this.model.setHttpsProxyHost(this.tfProxyHost.getText());
            this.model.setHttpsProxyPort(this.tfProxyPort.getText());
            this.model.setSocksHost(this.tfProxyHost.getText());
            this.model.setSocksPort(this.tfProxyPort.getText());
        }
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.editor.setAsText((String)this.cbWebBrowser.getSelectedItem());
        this.model.setUsageStatistics(this.jUsageCheck.isSelected());
    }

    void cancel() {
    }

    boolean dataValid() {
        return this.isPortValid();
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (!this.tfProxyHost.getText().equals(this.model.getHttpProxyHost())) {
            return true;
        }
        if (!this.tfProxyPort.getText().equals(this.model.getHttpProxyPort())) {
            return true;
        }
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changed = true;
        this.tfProxyHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfProxyPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.bMoreProxy.setEnabled(this.rbHTTPProxy.isSelected());
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
    }
}

