/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.SequentialPropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    private static Map<File, Reference<PropertyProvider>> globalPropertyProviders = new HashMap<File, Reference<PropertyProvider>>();
    private static EditableProperties currentGlobalProperties;
    private static File currentGlobalPropertiesFile;
    private static long currentGlobalPropertiesLastModified;
    private static long currentGlobalPropertiesLength;
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH;
    private static final Pattern VALID_PROPERTY_NAME;

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EditableProperties run() {
                File file = PropertyUtils.userBuildProperties();
                if (file != null && file.isFile() && file.canRead()) {
                    EditableProperties editableProperties;
                    long l = file.lastModified();
                    long l2 = file.length();
                    if (file.equals(currentGlobalPropertiesFile) && l == currentGlobalPropertiesLastModified && l2 == currentGlobalPropertiesLength) {
                        return currentGlobalProperties.cloneProperties();
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        EditableProperties editableProperties2 = new EditableProperties(true);
                        editableProperties2.load(fileInputStream);
                        currentGlobalProperties = editableProperties2.cloneProperties();
                        currentGlobalPropertiesFile = file;
                        currentGlobalPropertiesLastModified = l;
                        currentGlobalPropertiesLength = l2;
                        editableProperties = editableProperties2;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)fileInputStream).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, iOException);
                        }
                    }
                    ((InputStream)fileInputStream).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties editableProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    long l;
                    long l2;
                    File file = PropertyUtils.userBuildProperties();
                    if (file != null) {
                        l2 = file.lastModified();
                        l = file.length();
                        if (file.equals(currentGlobalPropertiesFile) && l2 == currentGlobalPropertiesLastModified && l == currentGlobalPropertiesLength && editableProperties.equals(currentGlobalProperties)) {
                            return null;
                        }
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null) {
                            if (!file.exists()) {
                                file.getParentFile().mkdirs();
                                new FileOutputStream(file).close();
                                assert (file.isFile()) : "Did not actually make " + file;
                            }
                            if ((fileObject = FileUtil.toFileObject((File)file)) == null) {
                                ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + file + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                try {
                                    editableProperties.store(fileOutputStream);
                                }
                                finally {
                                    ((OutputStream)fileOutputStream).close();
                                }
                                return null;
                            }
                        }
                        OutputStream outputStream = fileObject.getOutputStream();
                        try {
                            editableProperties.store(outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    currentGlobalProperties = editableProperties.cloneProperties();
                    currentGlobalPropertiesFile = file;
                    currentGlobalPropertiesLastModified = l2;
                    currentGlobalPropertiesLength = l;
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File file = PropertyUtils.userBuildProperties();
        if (file != null) {
            PropertyProvider propertyProvider;
            Reference<PropertyProvider> reference = globalPropertyProviders.get(file);
            if (reference != null && (propertyProvider = reference.get()) != null) {
                return propertyProvider;
            }
            propertyProvider = PropertyUtils.propertiesFilePropertyProvider(file);
            globalPropertyProviders.put(file, new SoftReference<PropertyProvider>(propertyProvider));
            return propertyProvider;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.<String, String>emptyMap());
    }

    public static PropertyProvider propertiesFilePropertyProvider(File file) {
        assert (file != null);
        return new FilePropertyProvider(file);
    }

    public static File resolveFile(File file, String string) throws IllegalArgumentException {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            assert (file2.isAbsolute());
        }
        return FileUtil.normalizeFile((File)file2);
    }

    public static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(PropertyUtils.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuilder.append("..");
                return stringBuilder.toString();
            }
            stringBuilder.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuilder.append(uRI.getPath());
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '/') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject fileObject, String string) {
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)fileObject), string));
    }

    static String resolvePath(File file, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = PropertyUtils.tokenizePath(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(PropertyUtils.resolveFile(file, stringArray[i]).getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    public static String[] tokenizePath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            char c2;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) continue;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                n = c2;
                ++n2;
                continue;
            }
            if (c != '\u0000') {
                if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                    string2 = "" + c + ':' + string2;
                } else {
                    arrayList.add(Character.toString(c));
                }
                c = '\u0000';
            }
            n2 = 0;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                c = c2;
                continue;
            }
            arrayList.add(string2);
        }
        if (c != '\u0000') {
            arrayList.add(Character.toString(c));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isUsablePropertyName(String string) {
        return VALID_PROPERTY_NAME.matcher(string).matches();
    }

    public static String getUsablePropertyName(String string) {
        if (PropertyUtils.isUsablePropertyName(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(stringBuilder.substring(i, i + 1))) continue;
            stringBuilder.replace(i, i + 1, "_");
        }
        return stringBuilder.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map<String, String> map) {
        return new FixedPropertyProvider(map);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider propertyProvider, PropertyProvider ... propertyProviderArray) {
        return new SequentialPropertyEvaluator(propertyProvider, propertyProviderArray);
    }

    public static PropertyProvider userPropertiesProvider(PropertyEvaluator propertyEvaluator, String string, File file) {
        return new UserPropertiesProvider(propertyEvaluator, string, file);
    }

    static {
        RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
        VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private Map<String, String> cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File file) {
            this.properties = file;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
        }

        @Override
        public Map<String, String> getProperties() {
            long l = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != l) {
                this.cachedTime = l;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Map map;
                FileInputStream fileInputStream = new FileInputStream(this.properties);
                try {
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    map = NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        try {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.WARNING, "Property file: " + this.properties.getPath(), illegalArgumentException);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, iOException);
                    }
                }
                ((InputStream)fileInputStream).close();
                return map;
            }
            return Collections.emptyMap();
        }

        private void fireChange() {
            this.cachedTime = -1L;
            if (!this.cs.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    FilePropertyProvider.this.cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        @Override
        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map<String, String> defs;

        public FixedPropertyProvider(Map<String, String> map) {
            this.defs = map;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.defs;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class UserPropertiesProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator findUserPropertiesFile;
        private final String propertyName;
        private final File basedir;

        public UserPropertiesProvider(PropertyEvaluator propertyEvaluator, String string, File file) {
            super(UserPropertiesProvider.computeDelegate(propertyEvaluator, string, file));
            this.findUserPropertiesFile = propertyEvaluator;
            this.propertyName = string;
            this.basedir = file;
            propertyEvaluator.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.propertyName.equals(propertyChangeEvent.getPropertyName())) {
                this.setDelegate(UserPropertiesProvider.computeDelegate(this.findUserPropertiesFile, this.propertyName, this.basedir));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator propertyEvaluator, String string, File file) {
            String string2 = propertyEvaluator.getProperty(string);
            if (string2 != null) {
                File file2 = PropertyUtils.resolveFile(file, string2);
                if (file2.equals(PropertyUtils.userBuildProperties())) {
                    return PropertyUtils.globalPropertyProvider();
                }
                return PropertyUtils.propertiesFilePropertyProvider(file2);
            }
            return PropertyUtils.globalPropertyProvider();
        }
    }
}

