/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public final class SourcesHelper {
    private final AntProjectHelper aph;
    private final Project project;
    private final PropertyEvaluator evaluator;
    private final List<SourceRoot> principalSourceRoots = new ArrayList<SourceRoot>();
    private final List<Root> nonSourceRoots = new ArrayList<Root>();
    private final List<Root> ownedFiles = new ArrayList<Root>();
    private final List<TypedSourceRoot> typedSourceRoots = new ArrayList<TypedSourceRoot>();
    private int registeredRootAlgorithm;
    private boolean minimalSubfolders;
    private Set<FileObject> lastRegisteredRoots;
    private PropertyChangeListener propChangeL;
    private WeakSet<SourcesImpl> knownSources = new WeakSet();

    @Deprecated
    public SourcesHelper(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.project = null;
        this.aph = antProjectHelper;
        this.evaluator = propertyEvaluator;
    }

    public SourcesHelper(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
        this.aph = antProjectHelper;
        this.evaluator = propertyEvaluator;
    }

    public SourceRootConfig sourceRoot(String string) {
        return new SourceRootConfig(string);
    }

    @Deprecated
    public void addPrincipalSourceRoot(String string, String string2, Icon icon, Icon icon2) throws IllegalStateException {
        this.addPrincipalSourceRoot(string, null, null, string2, icon, icon2);
    }

    @Deprecated
    public void addPrincipalSourceRoot(String string, String string2, String string3, String string4, Icon icon, Icon icon2) throws IllegalStateException {
        SourceRootConfig sourceRootConfig = this.sourceRoot(string).displayName(string4).icon(icon).openedIcon(icon2);
        if (string2 != null) {
            sourceRootConfig.includes(string2);
        }
        if (string3 != null) {
            sourceRootConfig.excludes(string3);
        }
        sourceRootConfig.add();
    }

    public void addNonSourceRoot(String string) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(string));
    }

    public void addOwnedFile(String string) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.ownedFiles.add(new Root(string));
    }

    @Deprecated
    public void addTypedSourceRoot(String string, String string2, String string3, Icon icon, Icon icon2) throws IllegalStateException {
        this.addTypedSourceRoot(string, null, null, string2, string3, icon, icon2);
    }

    @Deprecated
    public void addTypedSourceRoot(String string, String string2, String string3, String string4, String string5, Icon icon, Icon icon2) throws IllegalStateException {
        SourceRootConfig sourceRootConfig = this.sourceRoot(string).type(string4).displayName(string5).icon(icon).openedIcon(icon2);
        if (string2 != null) {
            sourceRootConfig.includes(string2);
        }
        if (string3 != null) {
            sourceRootConfig.excludes(string3);
        }
        sourceRootConfig.add();
    }

    private Project getProject() {
        return this.project != null ? this.project : AntBasedProjectFactorySingleton.getProjectFor(this.aph);
    }

    public void registerExternalRoots(int n) throws IllegalArgumentException, IllegalStateException {
        this.registerExternalRoots(n, true);
    }

    public void registerExternalRoots(int n, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = n;
        this.minimalSubfolders = bl;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        ArrayList<SourceRoot> arrayList = new ArrayList<SourceRoot>(this.principalSourceRoots);
        arrayList.addAll(this.nonSourceRoots);
        arrayList.addAll(this.ownedFiles);
        Project project = this.getProject();
        FileObject fileObject = this.aph.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            this.lastRegisteredRoots = Collections.emptySet();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)this.evaluator));
        }
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        for (Root hashSet3 : arrayList) {
            for (FileObject fileObject2 : hashSet3.getIncludeRoots(this.minimalSubfolders)) {
                if (FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2) != null) continue;
                if (fileObject2.isFolder()) {
                    try {
                        Project project2 = ProjectManager.getDefault().findProject(fileObject2);
                        if (project2 != null) {
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                hashSet2.add(fileObject2);
            }
        }
        HashSet<FileObject> hashSet4 = new HashSet<FileObject>(this.lastRegisteredRoots);
        hashSet4.removeAll(hashSet2);
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject3 = (FileObject)iterator.next();
            FileOwnerQuery.markExternalOwner((FileObject)fileObject3, null, (int)this.registeredRootAlgorithm);
        }
        HashSet hashSet = new HashSet(hashSet2);
        hashSet.removeAll(this.lastRegisteredRoots);
        for (FileObject fileObject2 : hashSet) {
            FileOwnerQuery.markExternalOwner((FileObject)fileObject2, (Project)project, (int)this.registeredRootAlgorithm);
        }
        this.lastRegisteredRoots = hashSet2;
    }

    public Sources createSources() {
        SourcesImpl sourcesImpl = new SourcesImpl();
        this.knownSources.add((Object)sourcesImpl);
        return sourcesImpl;
    }

    public SourceGroupModifierImplementation createSourceGroupModifierImplementation() {
        return new SourceGroupModifierImpl();
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (SourceRoot sourceRoot : SourcesHelper.this.principalSourceRoots) {
                sourceRoot.resetIncludeExcludePatterns();
            }
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Root {
        protected final String location;

        public Root(String string) {
            this.location = string;
        }

        public final File getActualLocation() {
            String string = SourcesHelper.this.evaluator.evaluate(this.location);
            if (string == null) {
                return null;
            }
            return SourcesHelper.this.aph.resolveFile(string);
        }

        public Collection<FileObject> getIncludeRoots(boolean bl) {
            FileObject fileObject;
            File file = this.getActualLocation();
            if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
                return Collections.singleton(fileObject);
            }
            return Collections.emptySet();
        }

        public String toString() {
            return "Root[" + this.location + "]";
        }
    }

    private class SourceGroupModifierImpl
    implements SourceGroupModifierImplementation {
        private Logger logger = Logger.getLogger(SourcesHelper.class.getName());

        private SourceGroupModifierImpl() {
        }

        public SourceGroup createSourceGroup(String string, String string2) {
            FileObject fileObject;
            SourceRoot sourceRoot = this.findRoot(string, string2);
            if (sourceRoot == null) {
                return null;
            }
            if (sourceRoot.isRemoved()) {
                return null;
            }
            File file = sourceRoot.getActualLocation();
            if (!file.exists()) {
                try {
                    fileObject = FileUtil.createFolder((File)file);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Failed to create folder " + file, iOException);
                    return null;
                }
            } else {
                fileObject = FileUtil.toFileObject((File)file);
            }
            SourceGroup sourceGroup = sourceRoot.toGroup(fileObject);
            assert (sourceGroup != null);
            for (SourcesImpl sourcesImpl : SourcesHelper.this.knownSources) {
                sourcesImpl.maybeFireChange();
            }
            return sourceGroup;
        }

        public boolean canCreateSourceGroup(String string, String string2) {
            return this.findRoot(string, string2) != null;
        }

        private SourceRoot findRoot(String string, String string2) {
            if ("generic".equals(string)) {
                for (SourceRoot sourceRoot : SourcesHelper.this.principalSourceRoots) {
                    if (sourceRoot.getHint() == null || !sourceRoot.getHint().equals(string2) || sourceRoot.isRemoved()) continue;
                    return sourceRoot;
                }
            } else {
                for (TypedSourceRoot typedSourceRoot : SourcesHelper.this.typedSourceRoots) {
                    if (typedSourceRoot.getHint() == null || !typedSourceRoot.getType().equals(string) || !typedSourceRoot.getHint().equals(string2)) continue;
                    return typedSourceRoot;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private final String includes;
        private final String excludes;
        private final String hint;
        private boolean removed;
        private PathMatcher matcher;

        public SourceRoot(String string, String string2, String string3, String string4, String string5, Icon icon, Icon icon2) {
            super(string);
            this.displayName = string5;
            this.icon = icon;
            this.openedIcon = icon2;
            this.includes = string2;
            this.excludes = string3;
            this.hint = string4;
            this.removed = false;
        }

        public final SourceGroup toGroup(FileObject fileObject) {
            assert (fileObject != null);
            return new Group(fileObject);
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        @Override
        public String toString() {
            return "SourceRoot[" + this.location + "]";
        }

        private String evalForMatcher(String string) {
            if (string == null) {
                return null;
            }
            String string2 = SourcesHelper.this.evaluator.evaluate(string);
            if (string2 == null) {
                return null;
            }
            if (string2.matches("\\$\\{[^}]+\\}")) {
                return null;
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PathMatcher computeIncludeExcludePatterns() {
            Object object = this;
            synchronized (object) {
                if (this.matcher != null) {
                    return this.matcher;
                }
            }
            object = this.evalForMatcher(this.includes);
            String string = this.evalForMatcher(this.excludes);
            PathMatcher pathMatcher = new PathMatcher((String)object, string, this.getActualLocation());
            SourceRoot sourceRoot = this;
            synchronized (sourceRoot) {
                this.matcher = pathMatcher;
            }
            return pathMatcher;
        }

        private synchronized void resetIncludeExcludePatterns() {
            this.matcher = null;
        }

        @Override
        public Collection<FileObject> getIncludeRoots(boolean bl) {
            Collection<FileObject> collection = super.getIncludeRoots(bl);
            if (!bl) {
                return collection;
            }
            if (collection.size() == 1) {
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                for (File file : this.computeIncludeExcludePatterns().findIncludedRoots()) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    hashSet.add(fileObject);
                }
                return hashSet;
            }
            assert (collection.isEmpty());
            return collection;
        }

        private final class Group
        implements SourceGroup,
        PropertyChangeListener {
            private final FileObject loc;
            private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

            Group(FileObject fileObject) {
                this.loc = fileObject;
                SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
            }

            public FileObject getRootFolder() {
                return this.loc;
            }

            public String getName() {
                return SourceRoot.this.location.length() > 0 ? SourceRoot.this.location : "generic";
            }

            public String getDisplayName() {
                return SourceRoot.this.displayName;
            }

            public Icon getIcon(boolean bl) {
                return bl ? SourceRoot.this.icon : SourceRoot.this.openedIcon;
            }

            public boolean contains(FileObject fileObject) throws IllegalArgumentException {
                if (fileObject == this.loc) {
                    return true;
                }
                String string = FileUtil.getRelativePath((FileObject)this.loc, (FileObject)fileObject);
                if (string == null) {
                    throw new IllegalArgumentException(fileObject + " is not inside " + this.loc);
                }
                if (fileObject.isFolder()) {
                    string = string + "/";
                }
                if (!SourceRoot.this.computeIncludeExcludePatterns().matches(string, true)) {
                    return false;
                }
                Project project = SourcesHelper.this.getProject();
                if (fileObject.isFolder() && fileObject != project.getProjectDirectory() && ProjectManager.getDefault().isProject(fileObject)) {
                    return false;
                }
                if (!(SourceRoot.this instanceof TypedSourceRoot)) {
                    Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                    if (project2 != null && project2 != project) {
                        return false;
                    }
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (file != null && SharabilityQuery.getSharability((File)file) == 2) {
                        return false;
                    }
                }
                return true;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.pcs.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }

            public String toString() {
                return "SourcesHelper.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                assert (propertyChangeEvent.getSource() == SourcesHelper.this.evaluator) : propertyChangeEvent;
                String string = propertyChangeEvent.getPropertyName();
                if (string == null || SourceRoot.this.includes != null && SourceRoot.this.includes.contains("${" + string + "}") || SourceRoot.this.excludes != null && SourceRoot.this.excludes.contains("${" + string + "}")) {
                    SourceRoot.this.resetIncludeExcludePatterns();
                    this.pcs.firePropertyChange("containership", null, null);
                }
            }
        }
    }

    public final class SourceRootConfig {
        private String location;
        private String displayName;
        private Icon icon;
        private Icon openedIcon;
        private String includes;
        private String excludes;
        private String type;
        private String hint;

        private SourceRootConfig(String string) {
            this.location = string;
        }

        public SourceRootConfig displayName(String string) {
            this.displayName = string;
            return this;
        }

        public SourceRootConfig includes(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            this.includes = string;
            return this;
        }

        public SourceRootConfig excludes(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            this.excludes = string;
            return this;
        }

        public SourceRootConfig type(String string) {
            this.type = string;
            return this;
        }

        public SourceRootConfig hint(String string) {
            this.hint = string;
            return this;
        }

        public SourceRootConfig icon(Icon icon) {
            this.icon = icon;
            return this;
        }

        public SourceRootConfig openedIcon(Icon icon) {
            this.openedIcon = icon;
            return this;
        }

        public SourceRootConfig add() throws IllegalStateException {
            if (SourcesHelper.this.lastRegisteredRoots != null) {
                throw new IllegalStateException("registerExternalRoots was already called");
            }
            if (this.type != null) {
                SourcesHelper.this.typedSourceRoots.add(new TypedSourceRoot(this.type, this.hint, this.location, this.includes, this.excludes, this.displayName, this.icon, this.openedIcon));
            } else {
                SourcesHelper.this.principalSourceRoots.add(new SourceRoot(this.location, this.includes, this.excludes, this.hint, this.displayName, this.icon, this.openedIcon));
            }
            return this;
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean haveAttachedListeners;
        private final Set<File> rootsListenedTo = new HashSet<File>();
        private final Map<String, List<URL>> lastComputedRoots = new HashMap<String, List<URL>>();

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
        }

        /*
         * WARNING - void declaration
         */
        public SourceGroup[] getSourceGroups(String string) {
            Object object2;
            AbstractCollection abstractCollection;
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            if (string.equals("generic")) {
                abstractCollection = new ArrayList(SourcesHelper.this.principalSourceRoots);
                abstractCollection.add((SourceRoot)new SourceRoot("", null, null, null, ProjectUtils.getInformation((Project)SourcesHelper.this.getProject()).getDisplayName(), null, null));
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Object object2 : abstractCollection) {
                    File file = ((Root)object2).getActualLocation();
                    if (file == null) continue;
                    this.listen(file);
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null || linkedHashMap.containsKey(fileObject)) continue;
                    linkedHashMap.put(fileObject, object2);
                }
                Iterator iterator = linkedHashMap.keySet().iterator();
                block3: while (iterator.hasNext()) {
                    void var7_16;
                    object2 = (FileObject)iterator.next();
                    FileObject fileObject = object2.getParent();
                    while (var7_16 != null) {
                        if (linkedHashMap.containsKey(var7_16)) {
                            ((SourceRoot)linkedHashMap.get(object2)).removed = true;
                            iterator.remove();
                            continue block3;
                        }
                        FileObject fileObject2 = var7_16.getParent();
                    }
                }
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    arrayList.add(((SourceRoot)entry.getValue()).toGroup((FileObject)entry.getKey()));
                }
            } else {
                abstractCollection = new HashSet();
                for (TypedSourceRoot typedSourceRoot : SourcesHelper.this.typedSourceRoots) {
                    if (!typedSourceRoot.getType().equals(string) || (object2 = typedSourceRoot.getActualLocation()) == null) continue;
                    this.listen((File)object2);
                    FileObject fileObject = FileUtil.toFileObject((File)object2);
                    if (fileObject == null || !abstractCollection.add(fileObject)) continue;
                    arrayList.add(typedSourceRoot.toGroup(fileObject));
                }
            }
            abstractCollection = new ArrayList(arrayList.size());
            for (SourceGroup sourceGroup : arrayList) {
                try {
                    abstractCollection.add(sourceGroup.getRootFolder().getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false) : fileStateInvalidException;
                }
            }
            this.lastComputedRoots.put(string, (List<URL>)((Object)abstractCollection));
            return arrayList.toArray(new SourceGroup[arrayList.size()]);
        }

        private synchronized void listen(File file) {
            if (this.rootsListenedTo.add(file) && this.haveAttachedListeners) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (!this.haveAttachedListeners) {
                this.haveAttachedListeners = true;
                for (File file : this.rootsListenedTo) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
                }
            }
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        private void maybeFireChange() {
            boolean bl = false;
            for (String string : new HashSet<String>(this.lastComputedRoots.keySet())) {
                ArrayList arrayList = new ArrayList(this.lastComputedRoots.get(string));
                this.getSourceGroups(string);
                List<URL> list = this.lastComputedRoots.get(string);
                if (((Object)list).equals(arrayList)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.cs.fireChange();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.maybeFireChange();
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.maybeFireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String string, String string2, String string3, String string4, String string5, String string6, Icon icon, Icon icon2) {
            super(string3, string4, string5, string2, string6, icon, icon2);
            this.type = string;
        }

        public final String getType() {
            return this.type;
        }
    }
}

