/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.gsf.testrunner.api.StatisticsPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResultWindow
extends TopComponent {
    private static final String ID = "gsf-testrunner-results";
    private static WeakReference<ResultWindow> instance = null;
    private JSplitPane view;
    private boolean activated;
    private JComponent outputComp;
    private JComponent outputTab;
    private IOContainer ioContainer;

    public static ResultWindow getInstance() {
        final ResultWindow[] resultWindowArray = new ResultWindow[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        resultWindowArray[0] = ResultWindow.getResultWindow();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        } else {
            resultWindowArray[0] = ResultWindow.getResultWindow();
        }
        return resultWindowArray[0];
    }

    private static synchronized ResultWindow getResultWindow() {
        ResultWindow resultWindow = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (resultWindow == null) {
            resultWindow = ResultWindow.getDefault();
        }
        return resultWindow;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow resultWindow;
        ResultWindow resultWindow2 = resultWindow = instance != null ? (ResultWindow)((Object)instance.get()) : null;
        if (resultWindow == null) {
            resultWindow = new ResultWindow();
            resultWindow.initActions();
            instance = new WeakReference<ResultWindow>(resultWindow);
        }
        return resultWindow;
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("jumpNext", new PrevNextFailure(true));
        actionMap.put("jumpPrev", new PrevNextFailure(false));
    }

    public ResultWindow() {
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage(ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
    }

    public void addDisplayComponent(JSplitPane jSplitPane) {
        assert (EventQueue.isDispatchThread());
        this.removeAll();
        this.addView(jSplitPane);
        this.revalidate();
    }

    private void addView(JSplitPane jSplitPane) {
        assert (EventQueue.isDispatchThread());
        this.view = jSplitPane;
        jSplitPane.setMinimumSize(new Dimension(0, 0));
        this.add(jSplitPane);
    }

    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }

    public void promote() {
        assert (EventQueue.isDispatchThread());
        this.open();
        this.requestVisible();
    }

    public void setOrientation(int n) {
        if (this.view == null) {
            return;
        }
        if (this.view.getOrientation() != n) {
            this.view.setOrientation(n);
        }
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }

    IOContainer getIOContainer() {
        if (this.ioContainer == null) {
            this.ioContainer = IOContainer.create((IOContainer.Provider)new IOContainerImpl());
        }
        return this.ioContainer;
    }

    void setOutputComp(JComponent jComponent) {
        this.outputComp = jComponent;
    }

    protected void componentActivated() {
        this.activated = true;
    }

    protected void componentDeactivated() {
        this.activated = false;
    }

    private class IOContainerImpl
    implements IOContainer.Provider {
        private IOContainerImpl() {
        }

        public void remove(JComponent jComponent) {
            ResultWindow.this.outputTab = null;
            ResultWindow.this.outputComp.remove(jComponent);
            ResultWindow.getInstance().close();
        }

        public void select(JComponent jComponent) {
        }

        public JComponent getSelected() {
            return ResultWindow.this.outputTab;
        }

        public boolean isActivated() {
            return ResultWindow.this.activated;
        }

        public void open() {
        }

        public void requestActive() {
        }

        public void requestVisible() {
        }

        public void setIcon(JComponent jComponent, Icon icon) {
        }

        public void setTitle(JComponent jComponent, String string) {
        }

        public void setToolTipText(JComponent jComponent, String string) {
        }

        public void add(JComponent jComponent, IOContainer.CallBacks callBacks) {
            ResultWindow.this.outputTab = jComponent;
            ResultWindow.this.outputComp.add(jComponent);
        }

        public void setToolbarActions(JComponent jComponent, Action[] actionArray) {
        }

        public boolean isCloseable(JComponent jComponent) {
            return false;
        }
    }

    private static final class PrevNextFailure
    extends AbstractAction {
        private final boolean next;

        public PrevNextFailure(boolean bl) {
            this.next = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = ResultWindow.getInstance().view;
            if (jSplitPane == null || !(jSplitPane.getLeftComponent() instanceof StatisticsPanel)) {
                return;
            }
            StatisticsPanel statisticsPanel = (StatisticsPanel)jSplitPane.getLeftComponent();
            if (this.next) {
                statisticsPanel.selectNextFailure();
            } else {
                statisticsPanel.selectPreviousFailure();
            }
        }
    }
}

