/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.util.HashMap;
import java.util.LinkedHashSet;
import org.codeviation.commons.patterns.Cache;
import org.codeviation.commons.patterns.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Caches {
    public static final Factory<Statistics, Cache> STATISTICS_FACTORY = new StatsFactory();

    public static <T, P> Cache<T, P> permanent(Factory<T, P> factory) {
        return new PermanentCache<T, P>(factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LruCache<T, P>
    implements Cache<T, P>,
    StatsProvider {
        private Factory<T, P> producer;
        private int maxCount;
        private HashMap<P, T> cache;
        private LinkedHashSet<P> usages;
        private Statistics stats;

        public LruCache(Factory<T, P> factory, int n) {
            this.producer = factory;
            this.maxCount = n;
            this.clear();
        }

        @Override
        public T create(P p) {
            ++this.stats.queries;
            T t = this.cache.get(p);
            if (t == null) {
                t = this.producer.create(p);
                this.cache.put(p, t);
                ++this.stats.misses;
            }
            return t;
        }

        @Override
        public void clear() {
            this.stats = new Statistics();
        }

        @Override
        public Statistics getStats() {
            return this.stats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermanentCache<T, P>
    implements Cache<T, P>,
    StatsProvider {
        private Factory<T, P> producer;
        private HashMap<P, T> cache;
        private Statistics stats;

        public PermanentCache(Factory<T, P> factory) {
            this.producer = factory;
            this.clear();
        }

        @Override
        public synchronized T create(P p) {
            ++this.stats.queries;
            T t = this.cache.get(p);
            if (t == null) {
                t = this.producer.create(p);
                this.cache.put(p, t);
                ++this.stats.misses;
            }
            return t;
        }

        @Override
        public synchronized void clear() {
            this.stats = new Statistics();
            this.cache = new HashMap();
        }

        @Override
        public Statistics getStats() {
            return this.stats;
        }
    }

    public static final class Statistics {
        public long queries;
        public long misses;

        private static Statistics create(Statistics statistics) {
            Statistics statistics2 = new Statistics();
            statistics2.queries = statistics.queries;
            statistics2.misses = statistics.misses;
            return statistics2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatsFactory
    implements Factory<Statistics, Cache> {
        private StatsFactory() {
        }

        @Override
        public Statistics create(Cache cache) {
            if (!(cache instanceof StatsProvider)) {
                throw new IllegalArgumentException("Unknown cache " + cache);
            }
            return Statistics.create(((StatsProvider)((Object)cache)).getStats());
        }
    }

    private static interface StatsProvider {
        public Statistics getStats();
    }
}

