/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factories {
    public static final Factory<String, Object> TO_STRING = new ToString();
    public static final Factory<String[], Object[]> TO_STRING_ARRAY = Factories.array(TO_STRING, new Class[0]);

    private Factories() {
    }

    public static <T, P extends T> Factory<T, P> defaultValue(T t) {
        return new Default(t);
    }

    public static <T, P> Factory<T[], P[]> array(Factory<T, P> factory, Class ... classArray) {
        return new ArrayFactory<T, P>(factory, null, ArrayFactory.getProductClass(classArray));
    }

    public static <T, P> Factory<T[], P[]> array(Factory<T, P> factory, Filter<P> filter, Class ... classArray) {
        return new ArrayFactory<T, P>(factory, filter, ArrayFactory.getProductClass(classArray));
    }

    public static <T, P> Factory<T, P> fromMap(Map<P, T> map) {
        return new MapFactory<T, P>(map);
    }

    public static <OT, IT, IP> Factory<OT, IP> chain(Factory<OT, IT> factory, Factory<IT, IP> factory2) {
        return new Chain<OT, IT, IP>(factory, factory2);
    }

    public static <T, P> Factory<T, P> layered(Factory<T, P> ... factoryArray) {
        return new LayeredFactory<T, P>(factoryArray);
    }

    public static <T, P> Factory<T, P> layered(Iterable<Factory<T, P>> iterable) {
        return new LayeredFactory<T, P>(iterable);
    }

    public static <T, P> Factory<T, P> field(Class<P> clazz, String string) {
        try {
            Field field = clazz.getField(string);
            return new MemberFactory(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("No such field.", noSuchFieldException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException);
        }
    }

    public static <T, P, I> Factory<T, I> method(P p, Class<T> clazz, Class<I> clazz2, String string) {
        try {
            Method method = p.getClass().getMethod(string, clazz2);
            return new MemberFactory(p, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No such method.", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException);
        }
    }

    public static <T, P> Factory<T, P> method(Class<P> clazz, String string) {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            return new MemberFactory(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No such method.", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException);
        }
    }

    public static <T, P> Factory<T, P> method(Class<P> clazz, Class<?> clazz2, String string) {
        try {
            Method method = clazz2.getMethod(string, clazz);
            return new MemberFactory(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No such method.", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException(securityException);
        }
    }

    public static <T> Factory<T, T> noOp() {
        return NoOp.INSTACE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayFactory<T, P>
    implements Factory<T[], P[]> {
        private Factory<T, P> elementFactory;
        private Filter<P> filter;
        private Class productClass;

        public ArrayFactory(Factory<T, P> factory, Filter<P> filter, Class clazz) {
            this.filter = filter;
            this.elementFactory = factory;
            if (clazz == null) {
                Type[] typeArray;
                Class<?> clazz2 = factory.getClass();
                for (Type type : typeArray = clazz2.getGenericInterfaces()) {
                    ParameterizedType parameterizedType;
                    if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Factory.class) continue;
                    Type[] typeArray2 = ((ParameterizedType)type).getActualTypeArguments();
                    clazz = typeArray2[0] instanceof Class ? (Class)typeArray2[0] : null;
                }
            } else {
                this.productClass = clazz;
            }
        }

        @Override
        public T[] create(P[] PArray) {
            if (this.filter == null) {
                return this.createNoFilter(PArray);
            }
            return this.createFilter(PArray);
        }

        private T[] createNoFilter(P[] PArray) {
            if (PArray == null) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(this.productClass, PArray.length);
            for (int i = 0; i < PArray.length; ++i) {
                objectArray[i] = this.elementFactory.create(PArray[i]);
            }
            return objectArray;
        }

        private T[] createFilter(P[] PArray) {
            if (PArray == null) {
                return null;
            }
            ArrayList<T> arrayList = new ArrayList<T>(PArray.length);
            for (P p : PArray) {
                if (!this.filter.accept(p)) continue;
                arrayList.add(this.elementFactory.create(p));
            }
            Object[] objectArray = (Object[])Array.newInstance(this.productClass, arrayList.size());
            return arrayList.toArray(objectArray);
        }

        private static Class getProductClass(Class[] classArray) {
            if (classArray == null || classArray.length < 1) {
                return null;
            }
            return classArray[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Chain<OT, IT, IP>
    implements Factory<OT, IP> {
        Factory<OT, IT> outer;
        Factory<IT, IP> inner;

        public Chain(Factory<OT, IT> factory, Factory<IT, IP> factory2) {
            this.outer = factory;
            this.inner = factory2;
        }

        @Override
        public OT create(IP IP) {
            IT IT = this.inner.create(IP);
            return this.outer.create(IT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Default<T, P extends T>
    implements Factory<T, P> {
        private T dflt;

        public Default(T t) {
            this.dflt = t;
        }

        @Override
        public T create(P p) {
            return (T)(p == null ? this.dflt : p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayeredFactory<T, P>
    implements Factory<T, P> {
        List<Factory<T, P>> factories;

        public LayeredFactory(Factory<T, P>[] factoryArray) {
            this.factories = new ArrayList<Factory<T, P>>(Arrays.asList(factoryArray));
        }

        public LayeredFactory(Iterable<Factory<T, P>> iterable) {
            this.factories = new ArrayList<Factory<T, P>>();
            for (Factory<T, P> factory : iterable) {
                this.factories.add(factory);
            }
        }

        @Override
        public T create(P p) {
            for (Factory<T, P> factory : this.factories) {
                T t = factory.create(p);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapFactory<T, P>
    implements Factory<T, P> {
        private Map<P, T> map;

        public MapFactory(Map<P, T> map) {
            this.map = map;
        }

        @Override
        public T create(P p) {
            return this.map.get(p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberFactory<T, P>
    implements Factory<T, P> {
        Object object;
        Member member;
        boolean isStatic;

        public MemberFactory(Field field) {
            this.member = field;
            this.isStatic = (this.member.getModifiers() & 8) > 0;
        }

        public MemberFactory(Method method) {
            this.member = method;
            this.isStatic = (this.member.getModifiers() & 8) > 0;
        }

        public MemberFactory(Object object, Method method) {
            this(method);
            this.object = object;
        }

        @Override
        public T create(P p) {
            try {
                if (this.member instanceof Field) {
                    return (T)((Field)this.member).get(p);
                }
                if (this.isStatic) {
                    ((Method)this.member).setAccessible(true);
                    return (T)((Method)this.member).invoke(null, p);
                }
                if (this.object != null) {
                    ((Method)this.member).setAccessible(true);
                    return (T)((Method)this.member).invoke(this.object, p);
                }
                ((Method)this.member).setAccessible(true);
                return (T)((Method)this.member).invoke(p, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException(invocationTargetException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOp<T>
    implements Factory<T, T> {
        private static NoOp INSTACE = new NoOp();

        private NoOp() {
        }

        @Override
        public T create(T t) {
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToString
    implements Factory<String, Object> {
        private static NoOp INSTACE = new NoOp();

        private ToString() {
        }

        @Override
        public String create(Object object) {
            return object.toString();
        }
    }
}

