/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import org.codeviation.commons.patterns.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pairs {
    public static <F, S> Pair<F, S> pair(F f, S s) {
        return new PairImpl<F, S>(f, s, Equality.BOTH);
    }

    public static <F, S> Pair<F, S> pair(F f, S s, Equality equality) {
        return new PairImpl<F, S>(f, s, equality);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Equality {
        FIRST,
        SECOND,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairImpl<F, S>
    implements Pair<F, S> {
        private F first;
        private S second;
        private Equality equality;

        public PairImpl(F f, S s, Equality equality) {
            this.first = f;
            this.second = s;
            this.equality = equality;
        }

        @Override
        public F getFirst() {
            return this.first;
        }

        @Override
        public S getSecond() {
            return this.second;
        }

        public boolean equals(Object object) {
            switch (this.equality) {
                case FIRST: {
                    return this.first.equals(object);
                }
                case SECOND: {
                    return this.second.equals(object);
                }
                case BOTH: {
                    return this.first.equals(object) && this.second.equals(object);
                }
            }
            throw new IllegalStateException("Unknown equality");
        }

        public int hashCode() {
            switch (this.equality) {
                case FIRST: {
                    return this.first.hashCode();
                }
                case SECOND: {
                    return this.second.hashCode();
                }
                case BOTH: {
                    return this.first.hashCode() + 37 * this.second.hashCode();
                }
            }
            throw new IllegalStateException("Unknown equality");
        }
    }
}

