/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.codeviation.commons.patterns.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> HashSet<T> hashSet(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length);
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> HashSet<T> hashSet(Collection<? extends T> collection, Filter<T> filter) {
        HashSet<T> hashSet = new HashSet<T>(collection.size());
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T, Q extends T> ArrayList<T> arrayList(Q ... QArray) {
        ArrayList<Q> arrayList = new ArrayList<Q>(QArray.length);
        for (Q q : QArray) {
            arrayList.add(q);
        }
        return arrayList;
    }

    public static <T, Q extends T> ArrayList<T> arrayList(Collection<Q> collection, Filter<T> filter) {
        ArrayList<Q> arrayList = new ArrayList<Q>(collection.size());
        for (Q q : collection) {
            if (!filter.accept(q)) continue;
            arrayList.add(q);
        }
        return arrayList;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C c, Q ... QArray) {
        for (Q q : QArray) {
            c.add(q);
        }
        return c;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C c, Iterator<Q> iterator) {
        while (iterator.hasNext()) {
            c.add(iterator.next());
        }
        return c;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C c, Iterable<Q> iterable) {
        return CollectionsUtil.add(c, iterable.iterator());
    }

    public static <T, C extends Collection<T>, Q extends Collection<? extends T>> C add(C c, Q q, Filter<? super T> filter) {
        for (T t : q) {
            if (!filter.accept(t)) continue;
            c.add(t);
        }
        return c;
    }

    public static <T, Q extends T> void remove(Collection<T> collection, Q ... QArray) {
        for (Q q : QArray) {
            collection.remove(q);
        }
    }

    public static <T> void remove(Collection<T> collection, Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            collection.remove(iterator.next());
        }
    }

    public static <T, Q extends T> Collection<Q> remove(Collection<Q> collection, Filter<? super T> filter) {
        for (Q q : collection) {
            if (!filter.accept(q)) continue;
            collection.remove(q);
        }
        return collection;
    }

    public static <T, Q extends T> Collection<T> filter(Collection<T> collection, Iterable<Q> iterable, Filter<Q> filter) {
        for (Q q : iterable) {
            if (!filter.accept(q)) continue;
            collection.add(q);
        }
        return collection;
    }
}

