/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.JsonUtils;
import org.codeviation.pojson.Parser;
import org.codeviation.pojson.Pojson;

class Handlers {
    Handlers() {
    }

    static class CollectionsInfo
    extends Info {
        private Object root;
        private Map<String, Object> om;
        private List<Object> al;

        CollectionsInfo(int n, String string) {
            super(n, string);
        }

        public Info createInfo(int n, String string) {
            CollectionsInfo collectionsInfo = new CollectionsInfo(n, string);
            switch (n) {
                case 1: {
                    collectionsInfo.om = new LinkedHashMap<String, Object>();
                    break;
                }
                case 0: {
                    collectionsInfo.al = new ArrayList<Object>();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return collectionsInfo;
        }

        public void addValue(Object object, String string) {
            switch (this.kind) {
                case 1: {
                    this.om.put(string, object);
                    break;
                }
                case 0: {
                    this.al.add(object);
                    break;
                }
                case -1: {
                    this.root = object;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public Object getValue() {
            switch (this.kind) {
                case 1: {
                    return this.om;
                }
                case 0: {
                    return this.al;
                }
                case -1: {
                    return this.root;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class Generic
    implements Parser.Handler {
        private Stack<Info> s = new Stack();

        Generic(Info info) {
            this.s.push(info);
        }

        public void objectStart() {
            this.s.push(this.s.peek().createInfo(1, null));
        }

        public void arrayStart() {
            this.s.push(this.s.peek().createInfo(0, null));
        }

        public void field(String string) {
            this.s.push(this.s.peek().createInfo(2, string));
        }

        public void objectEnd() {
            Info info = this.s.pop();
            this.addValue(info.getValue());
        }

        public void arrayEnd() {
            Info info = this.s.pop();
            this.addValue(info.getValue());
        }

        public void bool(boolean bl) {
            this.addValue(bl ? Boolean.TRUE : Boolean.FALSE);
        }

        public void string(String string) {
            this.addValue(string);
        }

        public void nul() {
            this.addValue(null);
        }

        public void number(long l) {
            this.addValue(l);
        }

        public void number(double d) {
            this.addValue(d);
        }

        public void comment(String string) {
        }

        public void lineComment(String string) {
        }

        public void error(Parser.Error error) {
            throw new IllegalArgumentException(error.toString());
        }

        private void addValue(Object object) {
            Info info = this.s.peek();
            if (info.kind == 2) {
                this.s.pop();
                if (!info.isIgnore()) {
                    this.s.peek().addValue(object, info.getName());
                }
            } else if (info.kind == 0 || info.kind == -1) {
                info.addValue(object, null);
            } else {
                throw new IllegalStateException("Should never happen");
            }
        }
    }

    static class IgnoreInfo
    extends Info {
        public IgnoreInfo(int n, String string) {
            super(n, string, true);
        }

        public Info createInfo(int n, String string) {
            return new IgnoreInfo(n, null);
        }

        public void addValue(Object object, String string) {
        }

        public Object getValue() {
            return null;
        }
    }

    public static abstract class Info {
        public static final int ROOT = -1;
        public static final int ARRAY = 0;
        public static final int OBJECT = 1;
        public static final int FIELD = 2;
        protected int kind;
        private String name;
        private boolean ignore;

        public Info(int n, String string) {
            this(n, string, false);
        }

        public Info(int n, String string, boolean bl) {
            this.kind = n;
            this.name = string;
            this.ignore = bl;
        }

        public String getName() {
            return this.name;
        }

        public abstract Info createInfo(int var1, String var2);

        public abstract void addValue(Object var1, String var2);

        public abstract Object getValue();

        public boolean isIgnore() {
            return this.ignore;
        }
    }

    static class PojoInfo
    extends Info {
        private Field field;
        private Class<?> clazz;
        private Object o;
        private List<Object> al;

        PojoInfo(Object object) {
            super(-1, null);
            this.o = object;
            this.clazz = this.o.getClass();
        }

        PojoInfo(int n, String string) {
            super(n, string);
        }

        public Info createInfo(int n, String string) {
            PojoInfo pojoInfo = new PojoInfo(n, string);
            switch (n) {
                case 1: {
                    try {
                        if (this.kind == -1) {
                            pojoInfo.o = this.o;
                            pojoInfo.clazz = this.o.getClass();
                            break;
                        }
                        pojoInfo.o = this.clazz.newInstance();
                        pojoInfo.clazz = this.clazz;
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                    }
                    break;
                }
                case 0: {
                    if (this.kind == -1) {
                        pojoInfo.clazz = this.clazz.getComponentType();
                    }
                    pojoInfo.al = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    try {
                        pojoInfo.field = this.clazz.getField(string);
                        pojoInfo.clazz = pojoInfo.field.getType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (this.clazz.isAnnotationPresent(Pojson.IgnoreNonExisting.class)) {
                            return new IgnoreInfo(2, string);
                        }
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
                    }
                    catch (SecurityException securityException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, securityException);
                    }
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.kind == 2) {
                Class<?> clazz = this.field.getType();
                pojoInfo.clazz = clazz.isArray() ? this.field.getType().getComponentType() : this.field.getType();
            }
            return pojoInfo;
        }

        public void addValue(Object object, String string) {
            switch (this.kind) {
                case 1: {
                    try {
                        Field field = this.o.getClass().getField(string);
                        field.setAccessible(true);
                        field.set(this.o, JsonUtils.fromJSON(field.getType(), object));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
                    }
                    catch (SecurityException securityException) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, securityException);
                    }
                    break;
                }
                case 0: {
                    this.al.add(object);
                    break;
                }
                case -1: {
                    if (this.clazz.isArray()) {
                        this.o = JsonUtils.fromJSON(this.clazz, object);
                        break;
                    }
                    this.o = object;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public Object getValue() {
            switch (this.kind) {
                case 1: {
                    return this.o;
                }
                case 0: {
                    return this.al;
                }
                case -1: {
                    return this.o;
                }
            }
            throw new IllegalStateException();
        }
    }
}

