/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codeviation.pojson.PojsonSave;

public class ZipSaver {
    private PojsonSave save;
    private ZipOutputStream zos;
    private Writer writer;

    public ZipSaver(ZipOutputStream zipOutputStream) {
        this(PojsonSave.create(), zipOutputStream);
    }

    public ZipSaver(PojsonSave pojsonSave, ZipOutputStream zipOutputStream) {
        this.save = pojsonSave;
        this.zos = zipOutputStream;
        this.writer = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
    }

    public void save(String string, Object object) throws IOException {
        this.zos.putNextEntry(new ZipEntry(string));
        this.save.save(this.writer, object);
        this.writer.flush();
    }

    public void save(String string, Object[] objectArray) throws IOException {
        this.zos.putNextEntry(new ZipEntry(string));
        this.save.save(this.writer, objectArray);
        this.writer.flush();
    }

    public void save(String string, Object object, Object ... objectArray) throws IOException {
        this.zos.putNextEntry(new ZipEntry(string));
        this.save.save(this.writer, object, objectArray);
        this.writer.flush();
    }

    public void save(String string, Iterable iterable) throws IOException {
        this.zos.putNextEntry(new ZipEntry(string));
        this.save.save(this.writer, iterable);
        this.writer.flush();
    }
}

