/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.lexer.api.CssTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerUtils {
    public static TokenSequence<CssTokenId> getCssTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<CssTokenId> tokenSequence = LexerUtils.tokenSequenceList(tokenHierarchy, n, false);
        if (tokenSequence == null) {
            tokenSequence = LexerUtils.tokenSequenceList(tokenHierarchy, n, true);
        }
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.moveStart();
        if (tokenSequence.moveNext() && tokenSequence.offset() > n) {
            return null;
        }
        tokenSequence.moveEnd();
        if (tokenSequence.movePrevious() && tokenSequence.offset() + tokenSequence.token().length() < n) {
            return null;
        }
        return tokenSequence;
    }

    private static TokenSequence<CssTokenId> tokenSequenceList(TokenHierarchy tokenHierarchy, int n, boolean bl) {
        List list = tokenHierarchy.embeddedTokenSequences(n, bl);
        if (list.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)list.get(list.size() - 1);
            if (tokenSequence.language() != CssTokenId.language()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static TokenSequence<CssTokenId> getJoinedTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            if (tokenSequence.language() == CssTokenId.language()) {
                return tokenSequence;
            }
            if ((tokenSequence = tokenSequence.embeddedJoined()) == null) break;
            tokenSequence.move(n);
        }
        return null;
    }
}

