/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.project.api.PhpOptions;

class ProxyClient {
    private static final Logger LOGGER = Logger.getLogger(ProxyClient.class.getName());
    private String proxyHost;
    private int proxyPort;
    private int idePort;
    private String ideKey;

    static ProxyClient getInstance(DebuggerOptions debuggerOptions) {
        return debuggerOptions.getDebugProxy() != null ? new ProxyClient(debuggerOptions) : null;
    }

    private ProxyClient(DebuggerOptions debuggerOptions) {
        assert (debuggerOptions != null);
        assert (debuggerOptions.getDebugProxy().first != null);
        assert (debuggerOptions.getDebugProxy().second != null);
        this.proxyHost = (String)debuggerOptions.getDebugProxy().first;
        this.proxyPort = (Integer)debuggerOptions.getDebugProxy().second;
        this.idePort = PhpOptions.getInstance().getDebuggerPort();
        this.ideKey = PhpOptions.getInstance().getDebuggerSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register() {
        boolean bl;
        block7: {
            bl = false;
            String string = ProxyClient.getProxyInitCommand(this.idePort, this.ideKey);
            try {
                Socket socket = new Socket(this.proxyHost, this.proxyPort);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                try {
                    ProxyClient.sendCommand(outputStream, string);
                    String string2 = ProxyClient.getResponse(inputStream, string);
                    bl = string2 != null;
                }
                finally {
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, unknownHostException.getLocalizedMessage(), unknownHostException);
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.INFO)) break block7;
                LOGGER.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        block7: {
            String string = ProxyClient.getProxyStopCommand(this.ideKey);
            try {
                Socket socket = new Socket(this.proxyHost, this.proxyPort);
                socket.setSoTimeout(5000);
                OutputStream outputStream = socket.getOutputStream();
                try {
                    ProxyClient.sendCommand(outputStream, string);
                }
                finally {
                    outputStream.close();
                    socket.close();
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, unknownHostException.getLocalizedMessage(), unknownHostException);
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.INFO)) break block7;
                LOGGER.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    private static String getProxyInitCommand(int n, String string) {
        return String.format("proxyinit -p %d -k %s -m 0", n, string);
    }

    private static String getProxyStopCommand(String string) {
        return String.format("proxystop -k %s", string);
    }

    private static void sendCommand(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("send command: %s: ", string));
        }
    }

    private static String getResponse(InputStream inputStream, String string) throws IOException {
        int n;
        String string2 = null;
        int n2 = 1024;
        byte[] byArray = new byte[n2];
        int n3 = -1;
        for (n = 0; (n3 = inputStream.read()) != -1 && n < n2; ++n) {
            byArray[n] = (byte)n3;
        }
        if (n > 0) {
            string2 = new String(byArray, 0, n);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("response(%s) is %s: ", string, string2));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("No response after command(\"%s\"): ", string));
        }
        return string2;
    }
}

