/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class SessionProgress
implements Cancellable {
    private static final ConcurrentMap<Session, SessionProgress> instances = new ConcurrentHashMap<Session, SessionProgress>();
    private final ProgressHandle h;
    private volatile Session session;
    private volatile boolean isFinished;
    private volatile boolean isStarted;

    public static SessionProgress forSession(Session session) {
        SessionProgress sessionProgress = new SessionProgress(session);
        SessionProgress sessionProgress2 = instances.putIfAbsent(session, sessionProgress);
        return sessionProgress2 == null ? sessionProgress : sessionProgress2;
    }

    public static SessionProgress forSessionId(SessionId sessionId) {
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        Session session = null;
        for (Session session2 : sessionArray) {
            SessionId sessionId2 = (SessionId)session2.lookupFirst(null, SessionId.class);
            if (sessionId2 == null || !sessionId2.getId().equals(sessionId.getId())) continue;
            session = session2;
            break;
        }
        return session != null ? SessionProgress.forSession(session) : null;
    }

    private SessionProgress(Session session) {
        this.session = session;
        String string = NbBundle.getMessage(SessionProgress.class, (String)"LBL_Progress_Connecting", (Object)session.getName());
        this.h = ProgressHandleFactory.createHandle((String)string, (Cancellable)this);
    }

    public boolean cancel() {
        DebugSession debugSession;
        this.finish();
        SessionId sessionId = (SessionId)this.session.lookupFirst(null, SessionId.class);
        assert (sessionId != null);
        DebugSession debugSession2 = debugSession = sessionId != null ? SessionManager.getInstance().getCurrentSession(sessionId) : null;
        if (debugSession != null) {
            debugSession.cancel();
        }
        SessionManager.getInstance().stop(this.session);
        return true;
    }

    void start() {
        this.h.start();
        this.isStarted = true;
    }

    public void notifyConnectionFinished() {
        String string = NbBundle.getMessage(SessionProgress.class, (String)"LBL_Progress_Suspend");
        this.h.setDisplayName(this.session.getName());
        this.h.suspend(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        if (this.isStarted && !this.isFinished) {
            this.isFinished = true;
            this.h.finish();
            SessionId sessionId = (SessionId)this.session.lookupFirst(null, SessionId.class);
            if (sessionId != null) {
                SessionId sessionId2 = sessionId;
                synchronized (sessionId2) {
                    sessionId.notifyAll();
                }
            }
        }
        instances.remove(this.session);
    }
}

