/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureGetCommand;
import org.netbeans.modules.php.dbgp.packets.FeatureGetResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureSetCommand;
import org.netbeans.modules.php.dbgp.packets.FeatureSetResponse;
import org.netbeans.modules.php.dbgp.packets.RunCommand;
import org.netbeans.modules.php.dbgp.packets.StepIntoCommand;
import org.w3c.dom.Node;

public class InitMessage
extends DbgpMessage {
    private static final String IDEKEY = "idekey";
    private static final String FILE = "fileuri";

    InitMessage(Node node) {
        super(node);
    }

    public String getSessionId() {
        return InitMessage.getAttribute(this.getNode(), IDEKEY);
    }

    public String getFileUri() {
        return InitMessage.getAttribute(this.getNode(), FILE);
    }

    public void process(DebugSession debugSession, DbgpCommand dbgpCommand) {
        this.setId(debugSession);
        this.setShowHidden(debugSession);
        this.setMaxDepth(debugSession);
        this.setMaxChildren(debugSession);
        this.setMaxDataSize(debugSession);
        this.setBreakpoints(debugSession);
        String string = debugSession.getTransactionId();
        DbgpCommand dbgpCommand2 = DebuggerOptions.getGlobalInstance().isDebuggerStoppedAtTheFirstLine() ? new StepIntoCommand(string) : new RunCommand(string);
        debugSession.sendCommandLater(dbgpCommand2);
    }

    private void setMaxDataSize(DebugSession debugSession) {
        FeatureGetCommand featureGetCommand = new FeatureGetCommand(debugSession.getTransactionId());
        featureGetCommand.setFeature(FeatureGetCommand.Feature.MAX_DATA);
        DbgpResponse dbgpResponse = debugSession.sendSynchronCommand(featureGetCommand);
        assert (dbgpResponse instanceof FeatureGetResponse);
        FeatureGetResponse featureGetResponse = (FeatureGetResponse)dbgpResponse;
        Integer n = 0;
        try {
            n = featureGetResponse != null ? Integer.parseInt(featureGetResponse.getDetails()) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = DbgpMessage.getMaxDataSize();
        if (n2 > n) {
            FeatureSetCommand featureSetCommand = new FeatureSetCommand(debugSession.getTransactionId());
            featureSetCommand.setFeature(FeatureGetCommand.Feature.MAX_DATA);
            featureSetCommand.setValue(n2 + "");
            dbgpResponse = debugSession.sendSynchronCommand(featureSetCommand);
            assert (dbgpResponse instanceof FeatureSetResponse);
            FeatureSetResponse featureSetResponse = (FeatureSetResponse)dbgpResponse;
            if (featureSetResponse != null && !featureSetResponse.isSuccess()) {
                DbgpMessage.setMaxDataSize(n);
            }
        } else {
            DbgpMessage.setMaxDataSize(n);
        }
    }

    private void setShowHidden(DebugSession debugSession) {
        this.setFeature(debugSession, FeatureGetCommand.Feature.SHOW_HIDDEN, "1");
    }

    private void setMaxDepth(DebugSession debugSession) {
        this.setFeature(debugSession, FeatureGetCommand.Feature.MAX_DEPTH, "3");
    }

    private void setMaxChildren(DebugSession debugSession) {
        this.setFeature(debugSession, FeatureGetCommand.Feature.MAX_CHILDREN, "31");
    }

    private void setFeature(DebugSession debugSession, FeatureGetCommand.Feature feature, String string) {
        FeatureSetCommand featureSetCommand = new FeatureSetCommand(debugSession.getTransactionId());
        featureSetCommand.setFeature(feature);
        featureSetCommand.setValue(string);
        DbgpResponse dbgpResponse = debugSession.sendSynchronCommand(featureSetCommand);
        assert (dbgpResponse instanceof FeatureSetResponse);
    }

    private void setBreakpoints(DebugSession debugSession) {
        Breakpoint[] breakpointArray;
        SessionId sessionId = debugSession.getSessionId();
        for (Breakpoint breakpoint : breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            AbstractBreakpoint abstractBreakpoint;
            BrkpntSetCommand brkpntSetCommand;
            if (!(breakpoint instanceof AbstractBreakpoint) || (brkpntSetCommand = Utils.getCommand(debugSession, sessionId, abstractBreakpoint = (AbstractBreakpoint)breakpoint)) == null) continue;
            debugSession.sendCommandLater(brkpntSetCommand);
        }
    }

    private void setId(DebugSession debugSession) {
        debugSession.setId(this);
    }
}

