/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.DefaultTurboProvider;
import org.netbeans.modules.turbo.Memory;
import org.netbeans.modules.turbo.Statistics;
import org.netbeans.modules.turbo.TurboListener;
import org.netbeans.modules.turbo.TurboProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class Turbo {
    private static Lookup.Result providers;
    private final CustomProviders customProviders;
    private static WeakReference defaultInstance;
    private List listeners = new ArrayList(100);
    private final Memory memory;
    private final Statistics statistics;
    private static Environment env;
    private final Set prepareRequests = Collections.synchronizedSet(new LinkedHashSet(27));
    private static PreparationTask preparationTask;

    public static synchronized Turbo getDefault() {
        Turbo turbo = null;
        if (defaultInstance != null) {
            turbo = (Turbo)defaultInstance.get();
        }
        if (turbo == null) {
            turbo = new Turbo(null, 47, -1);
            defaultInstance = new WeakReference<Turbo>(turbo);
        }
        return turbo;
    }

    public static synchronized Turbo createCustom(CustomProviders customProviders, int n, int n2) {
        return new Turbo(customProviders, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Turbo(CustomProviders customProviders, int n, int n2) {
        this.statistics = Statistics.createInstance();
        this.memory = new Memory(this.statistics, n, n2);
        this.customProviders = customProviders;
        if (customProviders != null || providers != null) return;
        Lookup.Template template = new Lookup.Template(TurboProvider.class);
        Class<Turbo> clazz = Turbo.class;
        synchronized (Turbo.class) {
            if (env == null) {
                env = new Environment();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            providers = env.getLookup().lookup(template);
            return;
        }
    }

    static synchronized void initEnvironment(Environment environment) {
        assert (env == null);
        env = environment;
        providers = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.statistics.shutdown();
    }

    public Object readEntry(Object object, String string) {
        this.statistics.attributeRequest();
        if (this.memory.existsEntry(object, string)) {
            Object object2 = this.memory.get(object, string);
            this.statistics.memoryHit();
            return object2;
        }
        ArrayList arrayList = new ArrayList(57);
        Object object3 = this.loadEntry(object, string, arrayList);
        this.memory.put(object, string, object3 != null ? object3 : Memory.NULL);
        for (Object[] objectArray : arrayList) {
            Object object4 = objectArray[0];
            String string2 = (String)objectArray[1];
            Object object5 = objectArray[2];
            assert (object4 != null);
            assert (string2 != null);
            this.fireEntryChange(object4, string2, object5);
        }
        return object3;
    }

    private Iterator providers() {
        if (this.customProviders == null) {
            Collection collection = providers.allInstances();
            ArrayList<TurboProvider> arrayList = new ArrayList<TurboProvider>(collection.size() + 1);
            arrayList.addAll(collection);
            arrayList.add(DefaultTurboProvider.getDefault());
            return arrayList.iterator();
        }
        return this.customProviders.providers();
    }

    private Object loadEntry(Object object, String string, List list) {
        Iterator iterator = this.providers();
        while (iterator.hasNext()) {
            TurboProvider turboProvider = (TurboProvider)iterator.next();
            try {
                if (!turboProvider.recognizesAttribute(string) || !turboProvider.recognizesEntity(object)) continue;
                TurboProvider.MemoryCache memoryCache = TurboProvider.MemoryCache.createDefault(this.memory, list);
                Object object2 = turboProvider.readEntry(object, string, memoryCache);
                this.statistics.providerHit();
                return object2;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().annotate(throwable, "Error in provider " + turboProvider + ", skipping... ");
                ErrorManager.getDefault().notify(1, throwable);
            }
        }
        return null;
    }

    public boolean writeEntry(Object object, String string, Object object2) {
        Object object3;
        if (object2 != null && (object3 = this.memory.get(object, string)) != null && object3.equals(object2)) {
            return true;
        }
        int n = this.storeEntry(object, string, object2);
        if (n >= 0) {
            this.memory.put(object, string, object2);
            this.fireEntryChange(object, string, object2);
            return true;
        }
        return false;
    }

    int storeEntry(Object object, String string, Object object2) {
        Iterator iterator = this.providers();
        while (iterator.hasNext()) {
            TurboProvider turboProvider = (TurboProvider)iterator.next();
            try {
                if (!turboProvider.recognizesAttribute(string) || !turboProvider.recognizesEntity(object)) continue;
                if (turboProvider.writeEntry(object, string, object2)) {
                    return 0;
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute[" + string + "] value rejected by " + turboProvider);
                ErrorManager.getDefault().notify(16, (Throwable)illegalArgumentException);
                return -1;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().annotate(throwable, "Error in provider " + turboProvider + ", skipping... ");
                ErrorManager.getDefault().notify(1, throwable);
            }
        }
        return 1;
    }

    public boolean prepareEntry(Object object, String string) {
        this.statistics.attributeRequest();
        if (this.memory.existsEntry(object, string)) {
            this.statistics.memoryHit();
            return true;
        }
        this.scheduleLoad(object, string);
        return false;
    }

    public boolean isPrepared(Object object, String string) {
        return this.memory.existsEntry(object, string);
    }

    public Object getMonitoredKey(Object object) {
        return this.memory.getMonitoredKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTurboListener(TurboListener turboListener) {
        List list = this.listeners;
        synchronized (list) {
            ArrayList<TurboListener> arrayList = new ArrayList<TurboListener>(this.listeners);
            arrayList.add(turboListener);
            this.listeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTurboListener(TurboListener turboListener) {
        List list = this.listeners;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(turboListener);
            this.listeners = arrayList;
        }
    }

    protected void fireEntryChange(Object object, String string, Object object2) {
        for (TurboListener turboListener : this.listeners) {
            turboListener.entryChanged(object, string, object2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Turbo delegating to:");
        Iterator iterator = this.providers();
        while (iterator.hasNext()) {
            TurboProvider turboProvider = (TurboProvider)iterator.next();
            stringBuffer.append(" [" + turboProvider + "]");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLoad(Object object, String string) {
        Set set = this.prepareRequests;
        synchronized (set) {
            if (preparationTask == null) {
                preparationTask = new PreparationTask(this.prepareRequests);
                RequestProcessor.getDefault().post((Runnable)preparationTask);
                this.statistics.backgroundThread();
            }
            preparationTask.notifyNewRequest(new Request(object, string));
        }
    }

    static /* synthetic */ PreparationTask access$502(PreparationTask preparationTask) {
        Turbo.preparationTask = preparationTask;
        return Turbo.preparationTask;
    }

    static class Environment {
        Environment() {
        }

        public Lookup getLookup() {
            return Lookup.getDefault();
        }
    }

    private final class PreparationTask
    implements Runnable {
        private final Set requests;
        private static final int INACTIVITY_TIMEOUT = 123000;

        public PreparationTask(Set set) {
            this.requests = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                Thread.currentThread().setName("Turbo Async Fetcher");
                while (this.waitForRequests()) {
                    Object object;
                    boolean bl;
                    Class<Memory> clazz;
                    Object object2 = this.requests;
                    // MONITORENTER : object2
                    Request request = (Request)this.requests.iterator().next();
                    this.requests.remove(request);
                    // MONITOREXIT : object2
                    object2 = request.key;
                    String string = request.name;
                    if (Turbo.this.memory.existsEntry(object2, string)) {
                        clazz = Memory.class;
                        // MONITORENTER : org.netbeans.modules.turbo.Memory.class
                        bl = !Turbo.this.memory.existsEntry(object2, string);
                        object = Turbo.this.memory.get(object2, string);
                        // MONITOREXIT : clazz
                        if (bl) {
                            Turbo.this.statistics.providerHit();
                        }
                    } else {
                        object = Turbo.this.loadEntry(object2, string, null);
                        clazz = Memory.class;
                        // MONITORENTER : org.netbeans.modules.turbo.Memory.class
                        bl = !Turbo.this.memory.existsEntry(object2, string);
                        Object object3 = Turbo.this.memory.get(object2, string);
                        Turbo.this.memory.put(object2, string, object != null ? object : Memory.NULL);
                        bl |= object3 != null && !object3.equals(object) || object3 == null && object != null;
                        // MONITOREXIT : clazz
                    }
                    Turbo.this.fireEntryChange(object2, string, object);
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                Set set = this.requests;
                // MONITORENTER : set
                this.requests.clear();
                // MONITOREXIT : set
                return;
            }
            finally {
                Set set = this.requests;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForRequests() throws InterruptedException {
            Set set = this.requests;
            synchronized (set) {
                if (this.requests.size() == 0) {
                    this.requests.wait(123000L);
                }
                return this.requests.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyNewRequest(Request request) {
            Set set = this.requests;
            synchronized (set) {
                if (this.requests.add(request)) {
                    Turbo.this.statistics.queueSize(this.requests.size());
                    this.requests.notify();
                } else {
                    Turbo.this.statistics.duplicate();
                    Turbo.this.statistics.providerHit();
                }
            }
        }

        public String toString() {
            return "Turbo.PreparationTask queue=[" + this.requests + "]";
        }
    }

    private static final class Request {
        private final Object key;
        private final String name;

        public Request(Object object, String string) {
            this.name = string;
            this.key = object;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Request)) {
                return false;
            }
            Request request = (Request)object;
            if (this.name != null ? !this.name.equals(request.name) : request.name != null) {
                return false;
            }
            return !(this.key != null ? !this.key.equals(request.key) : request.key != null);
        }

        public int hashCode() {
            int n = this.key != null ? this.key.hashCode() : 0;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Request[key=" + this.key + ", attr=" + this.name + "]";
        }
    }
}

