/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplatesStorage
implements StorageDescription<String, CodeTemplateDescription> {
    private static final Logger LOG = Logger.getLogger(CodeTemplatesStorage.class.getName());
    public static final String ID = "CodeTemplates";
    private static final String E_ROOT = "codetemplates";
    private static final String E_CODETEMPLATE = "codetemplate";
    private static final String E_DESCRIPTION = "description";
    private static final String E_CODE = "code";
    private static final String A_ABBREV = "abbreviation";
    private static final String A_DESCRIPTION_ID = "descriptionId";
    private static final String A_CONTEXTS = "contexts";
    private static final String A_UUID = "uuid";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Code Templates settings 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorCodeTemplates-1_0.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-codetemplatesettings";

    public String getId() {
        return ID;
    }

    public boolean isUsingProfiles() {
        return false;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getLegacyFileName() {
        return "abbreviations.xml";
    }

    public StorageReader<String, CodeTemplateDescription> createReader(FileObject fileObject, String string) {
        if (MIME_TYPE.equals(fileObject.getMIMEType())) {
            return new Reader(fileObject, string);
        }
        return new LegacyReader(fileObject, string);
    }

    public StorageWriter<String, CodeTemplateDescription> createWriter(FileObject fileObject, String string) {
        return new Writer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LegacyReader
    extends TemplatesReader {
        private static final String EL_ROOT = "abbrevs";
        private static final String EL_CODETEMPLATE = "abbrev";
        private static final String AL_ABBREV = "key";
        private static final String AL_REMOVE = "remove";
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Set<String> removedTemplates = new HashSet<String>();
        private String abbreviation = null;
        private StringBuilder text = null;

        public LegacyReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, CodeTemplateDescription> getAdded() {
            return this.codeTemplatesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedTemplates;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_CODETEMPLATE)) {
                boolean bl = Boolean.valueOf(attributes.getValue("remove"));
                if (bl) {
                    String string4 = attributes.getValue(AL_ABBREV);
                    this.removedTemplates.add(string4);
                    this.abbreviation = null;
                    this.text = null;
                } else {
                    this.abbreviation = attributes.getValue(AL_ABBREV);
                    this.text = new StringBuilder();
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_CODETEMPLATE) && this.abbreviation != null) {
                String string4 = this.text.toString().replaceFirst("([^|]+)[|]([^|]+)", "$1\\${cursor}$2");
                CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(this.abbreviation, null, CharacterConversions.lineSeparatorToLineFeed((CharSequence)string4), null, null, this.getMimePath());
                this.codeTemplatesMap.put(this.abbreviation, codeTemplateDescription);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reader
    extends TemplatesReader {
        private Map<String, CodeTemplateDescription> codeTemplatesMap = new HashMap<String, CodeTemplateDescription>();
        private Set<String> removedTemplates = new HashSet<String>();
        private String abbreviation = null;
        private String description = null;
        private String code = null;
        private List<String> contexts = null;
        private String uuid = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        public Reader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, CodeTemplateDescription> getAdded() {
            return this.codeTemplatesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedTemplates;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
                if (this.insideCdata) {
                    this.cdataText.append(cArray, n, n2);
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(CodeTemplatesStorage.E_ROOT)) {
                if (string3.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    boolean bl = Boolean.valueOf(attributes.getValue(CodeTemplatesStorage.A_REMOVE));
                    this.abbreviation = null;
                    this.description = null;
                    this.contexts = null;
                    this.uuid = null;
                    this.text = null;
                    this.cdataText = null;
                    if (bl) {
                        String string4 = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.removedTemplates.add(string4);
                    } else {
                        String string5;
                        this.abbreviation = attributes.getValue(CodeTemplatesStorage.A_ABBREV);
                        this.description = attributes.getValue(CodeTemplatesStorage.A_DESCRIPTION_ID);
                        if (this.description != null && (string5 = StorageSupport.getLocalizingBundleMessage((FileObject)this.getProcessedFile(), (String)this.description, null)) != null) {
                            this.description = string5;
                        }
                        if ((string5 = attributes.getValue(CodeTemplatesStorage.A_CONTEXTS)) != null) {
                            String[] stringArray = string5.split(",");
                            this.contexts = new ArrayList<String>(stringArray.length);
                            for (String string6 : stringArray) {
                                if ((string6 = string6.trim()).length() <= 0) continue;
                                this.contexts.add(string6);
                            }
                        } else {
                            this.contexts = null;
                        }
                        this.uuid = attributes.getValue(CodeTemplatesStorage.A_UUID);
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.abbreviation != null) {
                        this.text = new StringBuilder();
                        this.cdataText = new StringBuilder();
                        this.insideCdata = false;
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.abbreviation != null) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(CodeTemplatesStorage.E_ROOT)) {
                if (string3.equals(CodeTemplatesStorage.E_CODETEMPLATE)) {
                    if (this.abbreviation != null) {
                        CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(this.abbreviation, this.description == null ? null : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.description), this.code == null ? "" : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.code), this.contexts, this.uuid, this.getMimePath());
                        this.codeTemplatesMap.put(this.abbreviation, codeTemplateDescription);
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_CODE)) {
                    if (this.text != null) {
                        this.code = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                    }
                } else if (string3.equals(CodeTemplatesStorage.E_DESCRIPTION) && this.text != null) {
                    if (this.cdataText.length() > 0) {
                        this.description = this.cdataText.toString();
                    } else if (this.text.length() > 0) {
                        this.description = this.text.toString();
                    }
                }
            }
        }

        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TemplatesReader
    extends StorageReader<String, CodeTemplateDescription> {
        protected TemplatesReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        public abstract Map<String, CodeTemplateDescription> getAdded();

        public abstract Set<String> getRemoved();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Writer
    extends StorageWriter<String, CodeTemplateDescription> {
        public Document getDocument() {
            Element element;
            Document document = XMLUtil.createDocument((String)CodeTemplatesStorage.E_ROOT, null, (String)CodeTemplatesStorage.PUBLIC_ID, (String)CodeTemplatesStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(CodeTemplatesStorage.E_ROOT).item(0);
            for (Object object : this.getAdded().values()) {
                Object object2;
                CharSequence charSequence;
                element = document.createElement(CodeTemplatesStorage.E_CODETEMPLATE);
                node.appendChild(element);
                element.setAttribute(CodeTemplatesStorage.A_ABBREV, object.getAbbreviation());
                List list = object.getContexts();
                if (list != null && !list.isEmpty()) {
                    charSequence = new StringBuilder();
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = (String)list.get(i);
                        if (object2 == null || ((String)(object2 = ((String)object2).trim())).length() <= 0) continue;
                        if (i > 0) {
                            ((StringBuilder)charSequence).append(",");
                        }
                        ((StringBuilder)charSequence).append((String)object2);
                    }
                    if (((StringBuilder)charSequence).length() > 0) {
                        element.setAttribute(CodeTemplatesStorage.A_CONTEXTS, ((StringBuilder)charSequence).toString());
                    }
                }
                if ((charSequence = object.getUniqueId()) != null) {
                    element.setAttribute(CodeTemplatesStorage.A_UUID, (String)charSequence);
                }
                element.setAttribute(CodeTemplatesStorage.A_XML_SPACE, CodeTemplatesStorage.V_PRESERVE);
                String string = object.getParametrizedText();
                if (string.length() > 0) {
                    object2 = document.createElement(CodeTemplatesStorage.E_CODE);
                    object2.appendChild(document.createCDATASection(string));
                    element.appendChild((Node)object2);
                }
                if ((object2 = object.getDescription()) == null || ((String)object2).length() <= 0) continue;
                Element element2 = document.createElement(CodeTemplatesStorage.E_DESCRIPTION);
                element2.appendChild(document.createCDATASection((String)object2));
                element.appendChild(element2);
            }
            for (Object object : this.getRemoved()) {
                element = document.createElement(CodeTemplatesStorage.E_CODETEMPLATE);
                node.appendChild(element);
                element.setAttribute(CodeTemplatesStorage.A_ABBREV, (String)object);
                element.setAttribute(CodeTemplatesStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return document;
        }
    }
}

