/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManagerEvent;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManagerListener;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroup;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.swing.BlockCompare;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextRegionManager {
    static final Logger LOG = Logger.getLogger(TextRegionManager.class.getName());
    private static final int INVALID_TEXT_SYNC = -1;
    private static final int SAME_TEXT_SYNC = -2;
    private WeakReference<JTextComponent> componentRef;
    private Document doc;
    private TextRegion<?> rootRegion;
    private EventListenerList listenerList = new EventListenerList();
    private GapList<TextSyncGroup<?>> editGroups;
    private TextSync activeTextSync;
    private int masterRegionStartOffset;
    private int masterRegionEndOffset;
    private int ignoreDocModifications;
    private boolean forceSyncByMaster;
    private final Highlighting highlighting = new Highlighting(this);
    private boolean overridingKeys;
    private ActionMap origActionMap;
    private ActionMap overrideActionMap;

    public static synchronized TextRegionManager reserve(JTextComponent jTextComponent) {
        JTextComponent jTextComponent2;
        if (jTextComponent == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        Document document = jTextComponent.getDocument();
        TextRegionManager textRegionManager = TextRegionManager.get(document, true);
        if (textRegionManager == null) {
            textRegionManager = TextRegionManager.get(document, true);
        }
        if ((jTextComponent2 = textRegionManager.component()) == null) {
            textRegionManager.setComponent(jTextComponent);
        } else if (jTextComponent2 != jTextComponent) {
            if (textRegionManager.isActive()) {
                textRegionManager = null;
            } else {
                textRegionManager.setComponent(jTextComponent);
            }
        }
        return textRegionManager;
    }

    public static TextRegionManager get(Document document, boolean bl) {
        TextRegionManager textRegionManager = (TextRegionManager)document.getProperty(TextRegionManager.class);
        if (textRegionManager == null && bl) {
            textRegionManager = new TextRegionManager(document);
            document.putProperty(TextRegionManager.class, textRegionManager);
        }
        return textRegionManager;
    }

    TextRegionManager(Document document) {
        this.doc = document;
        this.rootRegion = new TextRegion();
        this.editGroups = new GapList(2);
    }

    public void addGroup(TextSyncGroup<?> textSyncGroup, int n) throws BadLocationException {
        if (textSyncGroup == null) {
            throw new IllegalArgumentException("textSyncGroup cannot be null");
        }
        if (textSyncGroup.textRegionManager() != null) {
            throw new IllegalArgumentException("textSyncGroup=" + textSyncGroup + " already assigned to textRegionManager=" + textSyncGroup.textRegionManager());
        }
        this.activate();
        this.editGroups.add(textSyncGroup);
        this.addGroupUpdate(textSyncGroup, n);
    }

    public void activateGroup(TextSyncGroup<?> textSyncGroup) {
        this.activateTextSync(null, textSyncGroup, this.findEditableTextSyncIndex(textSyncGroup, 0, 1, true, false), true);
    }

    public void stopGroupEditing(TextSyncGroup textSyncGroup) {
        int n = this.editGroups.indexOf((Object)textSyncGroup);
        if (n >= 0) {
            this.releaseLastGroups(this.editGroups.size() - n);
        }
    }

    public void stopSyncEditing() {
        this.releaseLastGroups(this.editGroups.size());
    }

    public TextSync activeTextSync() {
        return this.activeTextSync;
    }

    TextSyncGroup<?> activeGroup() {
        return this.activeTextSync != null ? this.activeTextSync.group() : null;
    }

    TextSyncGroup<?> lastGroup() {
        return this.editGroups.size() > 0 ? (TextSyncGroup)this.editGroups.get(this.editGroups.size() - 1) : null;
    }

    public void addTextRegionManagerListener(TextRegionManagerListener textRegionManagerListener) {
        this.listenerList.add(TextRegionManagerListener.class, textRegionManagerListener);
    }

    public void removeTextRegionManagerListener(TextRegionManagerListener textRegionManagerListener) {
        this.listenerList.remove(TextRegionManagerListener.class, textRegionManagerListener);
    }

    private TextRegionManagerEvent createEvent(boolean bl, List<TextSyncGroup<?>> list, TextSync textSync) {
        return new TextRegionManagerEvent(this, bl, list, textSync);
    }

    private void fireEvent(TextRegionManagerEvent textRegionManagerEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 1; i < objectArray.length; i += 2) {
            ((TextRegionManagerListener)objectArray[i]).stateChanged(textRegionManagerEvent);
        }
    }

    public JTextComponent component() {
        return this.componentRef != null ? (JTextComponent)this.componentRef.get() : null;
    }

    private void setComponent(JTextComponent jTextComponent) {
        this.componentRef = jTextComponent != null ? new WeakReference<JTextComponent>(jTextComponent) : null;
    }

    public Document document() {
        return this.doc;
    }

    void markIgnoreDocModifications() {
        ++this.ignoreDocModifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupUpdate(TextSyncGroup<?> textSyncGroup, int n) throws BadLocationException {
        if (textSyncGroup.textRegionManager() != null) {
            throw new IllegalArgumentException("TextSyncGroup=" + textSyncGroup + " already assigned to " + textSyncGroup.textRegionManager());
        }
        TextRegion<?> textRegion = null;
        try {
            for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
                for (TextRegion<?> textRegion2 : textSync.regions()) {
                    Position position = this.doc.createPosition(textRegion2.startOffset() + n);
                    Position position2 = this.doc.createPosition(textRegion2.endOffset() + n);
                    textRegion2.setStartPos(position);
                    textRegion2.setEndPos(position2);
                    TextRegionManager.addRegion(this.rootRegion, textRegion2);
                    textRegion = textRegion2;
                }
            }
            textRegion = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ADD textSyncGroup: " + textSyncGroup + '\n');
            }
        }
        finally {
            this.removeAddedSoFar(textSyncGroup, textRegion);
        }
        textSyncGroup.setTextRegionManager(this);
    }

    private void removeAddedSoFar(TextSyncGroup<?> textSyncGroup, TextRegion<?> textRegion) {
        while (textRegion != null) {
            for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
                for (TextRegion<?> textRegion2 : textSync.regions()) {
                    TextRegionManager.removeRegionFromParent(textRegion2);
                    if (textRegion2 != textRegion) continue;
                    return;
                }
            }
        }
    }

    private void removeGroupUpdate(TextSyncGroup<?> textSyncGroup) {
        textSyncGroup.setTextRegionManager(null);
        for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
            for (TextRegion<?> textRegion : textSync.regions()) {
                TextRegionManager.removeRegionFromParent(textRegion);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("REMOVE textSyncGroup: " + textSyncGroup + '\n');
        }
    }

    void setActiveTextSync(TextSync textSync) {
        if (textSync.masterRegion() == null) {
            throw new IllegalArgumentException("masterRegion expected to be non-null");
        }
        this.activeTextSync = textSync;
        this.updateMasterRegionBounds();
    }

    int findEditableTextSyncIndex(TextSyncGroup<?> textSyncGroup, int n, int n2, boolean bl, boolean bl2) {
        int n3 = textSyncGroup.textSyncsModifiable().size();
        if (n3 == 0) {
            return -1;
        }
        int n4 = -1;
        do {
            TextSync textSync;
            if (n >= n3) {
                if (!bl) break;
                n = 0;
            } else if (n < 0) {
                if (!bl) break;
                n = n3 - 1;
            }
            if (n4 == -1) {
                n4 = n;
            }
            if (!(textSync = textSyncGroup.textSyncs().get(n)).isEditable() && (bl2 || !textSync.isCaretMarker())) continue;
            return n;
        } while ((n += n2) != n4);
        return -1;
    }

    private void activateTextSync(List<TextSyncGroup<?>> list, TextSyncGroup<?> textSyncGroup, int n, boolean bl) {
        JTextComponent jTextComponent;
        Object object;
        int n2;
        TextSync textSync = this.activeTextSync;
        boolean bl2 = false;
        if (n == -1) {
            bl2 = true;
        }
        if (textSyncGroup != null) {
            if (n == -2) {
                n = textSyncGroup.activeTextSyncIndex();
            }
            textSyncGroup.setActiveTextSyncIndex(n);
            this.activeTextSync = textSyncGroup.activeTextSync();
            if (this.activeTextSync.isCaretMarker()) {
                n2 = this.activeTextSync.regions().get(0).startOffset();
                object = this.component();
                if (object != null) {
                    object.setCaretPosition(n2);
                }
                bl2 = true;
            }
        } else {
            this.activeTextSync = null;
        }
        while (bl2 && textSyncGroup != null) {
            bl2 = false;
            bl = false;
            n2 = this.editGroups.indexOf(textSyncGroup);
            assert (n2 >= 0);
            list = this.removeLastGroups(list, this.editGroups.size() - n2);
            if (n2 > 0) {
                textSyncGroup = (TextSyncGroup)this.editGroups.get(n2 - 1);
                n = textSyncGroup.activeTextSyncIndex();
                this.activeTextSync = textSyncGroup.activeTextSync();
                continue;
            }
            textSyncGroup = null;
            this.activeTextSync = null;
        }
        if (textSyncGroup != null && (jTextComponent = this.component()) != null) {
            this.setActiveTextSync(this.activeTextSync);
            ((BaseTextUI)jTextComponent.getUI()).getEditorUI().getWordMatch().clear();
            if (bl) {
                object = this.activeTextSync.masterRegion();
                jTextComponent.select(object.startOffset(), object.endOffset());
            }
            if (!this.overridingKeys) {
                this.overridingKeys = true;
                jTextComponent.addKeyListener(OverrideKeysListener.INSTANCE);
                object = OverrideAction.installOverrideActionMap(jTextComponent);
                this.origActionMap = object[0];
                this.overrideActionMap = object[1];
            }
        }
        TextRegionManagerEvent textRegionManagerEvent = this.createEvent(true, list, textSync);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event - focusing of activeTextSync:\n" + this.activeTextSync + "previousTextSync=" + textSync + ", removedGroups=" + list + '\n');
        }
        this.fireEvent(textRegionManagerEvent);
        if (list != null) {
            this.removeGroupsUpdate();
        }
        this.highlighting.requestRepaint();
    }

    private void releaseLastGroups(int n) {
        if (this.editGroups.size() > 0) {
            List<TextSyncGroup<?>> list = this.removeLastGroups(null, n);
            this.activateTextSync(list, this.lastGroup(), -2, false);
        }
    }

    private List<TextSyncGroup<?>> removeLastGroups(List<TextSyncGroup<?>> gapList, int n) {
        assert (n >= 0 && n <= this.editGroups.size());
        int n2 = this.editGroups.size() - n;
        if (gapList == null) {
            gapList = new GapList(n);
        }
        while (--n >= 0) {
            TextSyncGroup textSyncGroup = (TextSyncGroup)this.editGroups.remove(n2 + n);
            this.removeGroupUpdate(textSyncGroup);
            gapList.add(0, textSyncGroup);
        }
        return gapList;
    }

    private void removeGroupsUpdate() {
        if (this.editGroups.size() == 0) {
            JTextComponent jTextComponent = this.component();
            if (this.doc instanceof BaseDocument) {
                BaseDocument baseDocument = (BaseDocument)this.doc;
                baseDocument.removePostModificationDocumentListener((DocumentListener)DocListener.INSTANCE);
                baseDocument.removeUpdateDocumentListener((DocumentListener)UpdateDocListener.INSTANCE);
            }
            this.activeTextSync = null;
            this.componentRef = null;
            if (this.overridingKeys) {
                this.overridingKeys = false;
                jTextComponent.removeKeyListener(OverrideKeysListener.INSTANCE);
                if (this.overrideActionMap != jTextComponent.getActionMap()) {
                    LOG.warning("The action map got tampered with! component=" + jTextComponent.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(jTextComponent)) + "; doc=" + jTextComponent.getDocument());
                } else {
                    jTextComponent.setActionMap(this.origActionMap);
                }
                this.overrideActionMap.clear();
                this.origActionMap = null;
                this.overrideActionMap = null;
            }
        }
    }

    void activeTextSyncModified() {
        TextRegionManagerEvent textRegionManagerEvent = this.createEvent(false, Collections.<TextSyncGroup<?>>emptyList(), this.activeTextSync);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event - mod of activeTextSync=" + this.activeTextSync + '\n');
        }
        this.fireEvent(textRegionManagerEvent);
        this.highlighting.requestRepaint();
    }

    boolean enterAction() {
        TextSync textSync = this.activeTextSync();
        if (textSync != null) {
            TextRegion textRegion = textSync.validMasterRegion();
            JTextComponent jTextComponent = this.component();
            if (textRegion.startOffset() <= jTextComponent.getCaretPosition() && jTextComponent.getCaretPosition() <= textRegion.endOffset()) {
                TextSyncGroup textSyncGroup = textSync.group();
                this.activateTextSync(null, textSyncGroup, this.findEditableTextSyncIndex(textSyncGroup, textSyncGroup.activeTextSyncIndex() + 1, 1, false, false), true);
                return true;
            }
            this.releaseLastGroups(1);
        } else {
            this.releaseLastGroups(this.editGroups.size());
        }
        return false;
    }

    void escapeAction() {
        this.releaseLastGroups(1);
    }

    void tabAction() {
        TextSyncGroup textSyncGroup;
        int n;
        TextSync textSync = this.activeTextSync();
        if (textSync != null && (n = this.findEditableTextSyncIndex(textSyncGroup = textSync.group(), textSyncGroup.activeTextSyncIndex() + 1, 1, true, true)) != -1) {
            this.activateTextSync(null, textSyncGroup, n, true);
        }
    }

    void shiftTabAction() {
        TextSyncGroup textSyncGroup;
        int n;
        TextSync textSync = this.activeTextSync();
        if (textSync != null && (n = this.findEditableTextSyncIndex(textSyncGroup = textSync.group(), textSyncGroup.activeTextSyncIndex() - 1, -1, true, true)) != -1) {
            this.activateTextSync(null, textSyncGroup, n, true);
        }
    }

    boolean isActive() {
        return !this.editGroups.isEmpty();
    }

    List<TextRegion<?>> regions() {
        return this.rootRegion.regions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void insertUpdate(DocumentEvent var1_1) {
        if (this.ignoreDocModifications == 0) {
            if (TextRegionManager.LOG.isLoggable(Level.FINE)) {
                TextRegionManager.LOG.fine("TextRegionManager.insertUpdate(): evt:" + DocumentUtilities.appendEvent(null, (DocumentEvent)var1_1) + "\n");
                if (TextRegionManager.LOG.isLoggable(Level.FINER)) {
                    TextRegionManager.LOG.finer("BEFORE-INSERT-UPDATE REGIONS: " + this);
                }
            }
            if (this.activeTextSync != null) {
                ++this.ignoreDocModifications;
                try {
                    var2_2 = var1_1.getOffset();
                    var3_4 = var1_1.getLength();
                    var4_5 = DocumentUtilities.getModificationText((DocumentEvent)var1_1);
                    if (var4_5 == null) {
                        try {
                            var4_5 = this.doc.getText(var2_2, var3_4);
                        }
                        catch (BadLocationException var5_6) {
                            throw new IllegalStateException(var5_6);
                        }
                    }
                    var5_7 = false;
                    if (var2_2 > this.masterRegionStartOffset) {
                        if (var2_2 <= this.masterRegionEndOffset) {
                            var6_8 = this.activeTextSync.validMasterRegion();
                            var7_10 = var2_2 - var6_8.startOffset();
                            if (var7_10 <= 0) {
                                this.stopSyncEditing();
                                return;
                            }
                            this.beforeDocumentModification();
                            try {
                                if (this.forceSyncByMaster) {
                                    this.forceSyncByMaster = false;
                                    this.syncByMaster(this.activeTextSync);
                                } else {
                                    for (TextRegion<?> var9_14 : this.activeTextSync.regions()) {
                                        if (var9_14 == var6_8) continue;
                                        this.doc.insertString(var9_14.startOffset() + var7_10, var4_5, null);
                                    }
                                }
                            }
                            finally {
                                this.afterDocumentModification();
                            }
                            var5_7 = true;
                        }
                    } else if (var2_2 == this.masterRegionStartOffset) {
                        var6_9 = this.activeTextSync.validMasterRegion();
                        this.fixRegionStartOffset(var6_9, var2_2);
                        this.beforeDocumentModification();
                        try {
                            if (this.forceSyncByMaster) {
                                this.forceSyncByMaster = false;
                                this.syncByMaster(this.activeTextSync);
                            } else {
                                for (TextRegion<?> var8_13 : this.activeTextSync.regions()) {
                                    if (var8_13 == var6_9) continue;
                                    var9_15 = var8_13.startOffset();
                                    this.doc.insertString(var9_15, var4_5, null);
                                    this.fixRegionStartOffset(var8_13, var9_15);
                                }
                            }
                        }
                        finally {
                            this.afterDocumentModification();
                        }
                        var5_7 = true;
                    }
                    if (var5_7) {
                        this.activeTextSyncModified();
                    }
                    if (!DocumentUtilities.isTypingModification((Document)this.doc)) ** GOTO lbl81
                    this.stopSyncEditing();
                }
                catch (BadLocationException var2_3) {
                    TextRegionManager.LOG.log(Level.WARNING, "Unexpected exception during synchronization", var2_3);
                }
                finally {
                    if (!TextRegionManager.$assertionsDisabled && this.ignoreDocModifications <= 0) {
                        throw new AssertionError();
                    }
                    --this.ignoreDocModifications;
                }
            } else if (DocumentUtilities.isTypingModification((Document)this.doc)) {
                this.stopSyncEditing();
            }
lbl81:
            // 7 sources

            if (TextRegionManager.LOG.isLoggable(Level.FINER)) {
                TextRegionManager.LOG.finer("AFTER-INSERT-UPDATE REGIONS: " + this);
            }
        }
        this.updateMasterRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void removeUpdate(DocumentEvent var1_1) {
        if (this.ignoreDocModifications == 0) {
            if (TextRegionManager.LOG.isLoggable(Level.FINE)) {
                TextRegionManager.LOG.fine("TextRegionManager.removeUpdate(): evt:" + DocumentUtilities.appendEvent(null, (DocumentEvent)var1_1) + "\n");
                if (TextRegionManager.LOG.isLoggable(Level.FINER)) {
                    TextRegionManager.LOG.finer("BEFORE-REMOVE-UPDATE REGIONS: " + this);
                }
            }
            if (this.activeTextSync != null) {
                ++this.ignoreDocModifications;
                try {
                    var2_2 = var1_1.getOffset();
                    var3_3 = var1_1.getLength();
                    if (var2_2 >= this.masterRegionStartOffset && var2_2 + var3_3 <= this.masterRegionEndOffset) {
                        var4_4 = this.activeTextSync.validMasterRegion();
                        var5_5 = var2_2 - var4_4.startOffset();
                        this.beforeDocumentModification();
                        try {
                            if (Boolean.TRUE.equals(this.doc.getProperty("doc-replace-selection-property"))) {
                                this.forceSyncByMaster = true;
                            }
                            for (TextRegion<?> var7_8 : this.activeTextSync.regions()) {
                                if (var7_8 == var4_4) continue;
                                this.doc.remove(var7_8.startOffset() + var5_5, var3_3);
                            }
                            this.activeTextSyncModified();
                        }
                        catch (BadLocationException var6_7) {
                            this.stopSyncEditing();
                            TextRegionManager.LOG.log(Level.WARNING, "Unexpected exception during synchronization", var6_7);
                        }
                        finally {
                            this.afterDocumentModification();
                        }
                    }
                    if (!DocumentUtilities.isTypingModification((Document)this.doc)) ** GOTO lbl42
                    this.stopSyncEditing();
                }
                finally {
                    if (!TextRegionManager.$assertionsDisabled && this.ignoreDocModifications <= 0) {
                        throw new AssertionError();
                    }
                    --this.ignoreDocModifications;
                }
            } else if (DocumentUtilities.isTypingModification((Document)this.doc)) {
                this.stopSyncEditing();
            }
lbl42:
            // 8 sources

            if (TextRegionManager.LOG.isLoggable(Level.FINER)) {
                TextRegionManager.LOG.finer("AFTER-REMOVE-UPDATE REGIONS: " + this);
            }
        }
        this.updateMasterRegionBounds();
    }

    void removeUpdateUpdate(DocumentEvent documentEvent) {
        TextRegion<?> textRegion;
        int n = Integer.MAX_VALUE;
        int n2 = documentEvent.getOffset();
        int n3 = n2 + documentEvent.getLength();
        List<TextRegion<?>> list = this.rootRegion.regions();
        int n4 = TextRegionManager.findRegionInsertIndex(list, n2);
        if (n4 > 0) {
            textRegion = list.get(n4 - 1);
            n = this.findMinGroupIndex(n, textRegion, n2, n3);
        }
        while (n4 < list.size() && (textRegion = list.get(n4)).startOffset() < n3) {
            n = this.findMinGroupIndex(n, textRegion, n2, n3);
            ++n4;
        }
        if (n != Integer.MAX_VALUE) {
            int n5 = this.editGroups.size() - n;
            if (LOG.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                stringBuilder.append("removeUpdateUpdate(): Text remove <").append(n2);
                stringBuilder.append(",").append(n3).append(">.\n  Removing GROUPS <");
                stringBuilder.append(n).append(",").append(this.editGroups.size()).append(">\n");
                LOG.fine(stringBuilder.toString());
            }
            this.releaseLastGroups(n5);
        }
    }

    private int findMinGroupIndex(int n, TextRegion<?> textRegion, int n2, int n3) {
        BlockCompare blockCompare = BlockCompare.get((int)n2, (int)n3, (int)textRegion.startOffset(), (int)textRegion.endOffset());
        TextSyncGroup textSyncGroup = textRegion.textSync().group();
        boolean bl = false;
        if (!blockCompare.emptyY()) {
            Object object;
            if (blockCompare.overlap() || blockCompare.containsStrict()) {
                if (LOG.isLoggable(Level.FINE)) {
                    object = new StringBuilder(100);
                    ((StringBuilder)object).append("removeUpdateUpdate(): Text remove <").append(n2);
                    ((StringBuilder)object).append(",").append(n3).append(">.\n  Conflicting region ").append(textRegion).append('\n');
                    LOG.fine(((StringBuilder)object).toString());
                }
                n = Math.min(n, this.editGroups.indexOf(textSyncGroup));
                bl = true;
            } else {
                bl = blockCompare.inside();
            }
            if (bl && (object = textRegion.regions()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TextRegion textRegion2 = (TextRegion)iterator.next();
                    n = this.findMinGroupIndex(n, textRegion2, n2, n3);
                }
            }
        }
        return n;
    }

    private void beforeDocumentModification() {
        this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
    }

    private void afterDocumentModification() {
        this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
    }

    private void activate() {
        if (this.editGroups.size() == 0 && this.doc instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)this.doc;
            baseDocument.addPostModificationDocumentListener((DocumentListener)DocListener.INSTANCE);
            baseDocument.addUpdateDocumentListener((DocumentListener)UpdateDocListener.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncByMaster(TextSync textSync) {
        this.beforeDocumentModification();
        ++this.ignoreDocModifications;
        try {
            TextRegion textRegion = textSync.validMasterRegion();
            CharSequence charSequence = DocumentUtilities.getText((Document)this.doc);
            CharSequence charSequence2 = charSequence.subSequence(textRegion.startOffset(), textRegion.endOffset());
            String string = null;
            for (TextRegion<?> textRegion2 : textSync.regionsModifiable()) {
                int n;
                int n2;
                CharSequence charSequence3;
                if (textRegion2 == textRegion || CharSequenceUtilities.textEquals((CharSequence)charSequence2, (CharSequence)(charSequence3 = charSequence.subSequence(n2 = textRegion2.startOffset(), n = textRegion2.endOffset())))) continue;
                if (string == null) {
                    string = ((Object)charSequence2).toString();
                }
                this.doc.remove(n2, n - n2);
                this.doc.insertString(n2, string, null);
                this.fixRegionStartOffset(textRegion2, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
        finally {
            assert (this.ignoreDocModifications > 0);
            --this.ignoreDocModifications;
            this.afterDocumentModification();
        }
        this.updateMasterRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(TextSync textSync, String string) {
        this.beforeDocumentModification();
        ++this.ignoreDocModifications;
        try {
            CharSequence charSequence = DocumentUtilities.getText((Document)this.doc);
            for (TextRegion<?> textRegion : textSync.regionsModifiable()) {
                int n;
                int n2 = textRegion.startOffset();
                CharSequence charSequence2 = charSequence.subSequence(n2, n = textRegion.endOffset());
                if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence2)) continue;
                this.doc.remove(n2, n - n2);
                this.doc.insertString(n2, string, null);
                this.fixRegionStartOffset(textRegion, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
        finally {
            assert (this.ignoreDocModifications > 0);
            --this.ignoreDocModifications;
            this.afterDocumentModification();
        }
        this.updateMasterRegionBounds();
    }

    private void fixRegionStartOffset(TextRegion<?> textRegion, int n) throws BadLocationException {
        assert (!this.isRoot(textRegion)) : "Cannot fix root document's start offset";
        TextRegion<?> textRegion2 = textRegion.parent();
        if (textRegion2 == null) {
            LOG.warning("Region with null parent:\n" + textRegion + "\nRegions:\n" + this + "\n\n");
        }
        List<TextRegion<?>> list = textRegion2.regions();
        int n2 = TextRegionManager.findRegionIndex(list, textRegion) - 1;
        Position position = this.doc.createPosition(n);
        textRegion.setStartPos(position);
        while (n2 >= 0 && (textRegion = list.get(n2)).endOffset() > n) {
            textRegion.setEndPos(position);
            if (textRegion.startOffset() <= n) break;
            textRegion.setStartPos(position);
        }
        if (n2 < 0 && !this.isRoot(textRegion2) && textRegion2.startOffset() > n) {
            textRegion2.setStartPos(position);
            this.fixRegionStartOffset(textRegion2, n);
        }
    }

    private boolean isRoot(TextRegion textRegion) {
        return textRegion == this.rootRegion;
    }

    private void updateMasterRegionBounds() {
        if (this.activeTextSync != null) {
            this.masterRegionStartOffset = this.activeTextSync.masterRegion().startOffset();
            this.masterRegionEndOffset = this.activeTextSync.masterRegion().endOffset();
        }
    }

    static int findRegionInsertIndex(List<TextRegion<?>> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            TextRegion<?> textRegion = list.get(n4);
            int n5 = textRegion.startOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            for (n2 = n4 + 1; n2 < list.size() && list.get(n2).startOffset() == n; ++n2) {
            }
        }
        return n2;
    }

    static int findRegionIndex(List<TextRegion<?>> list, TextRegion<?> textRegion) {
        int n = 0;
        int n2 = list.size() - 1;
        int n3 = textRegion.startOffset();
        block0: while (n <= n2) {
            int n4 = (n + n2) / 2;
            TextRegion<?> textRegion2 = list.get(n4);
            int n5 = textRegion2.startOffset();
            if (n5 < n3) {
                n = n4 + 1;
                continue;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            if (textRegion2 == textRegion) {
                return n4;
            }
            for (n = n4 - 1; n >= 0; --n) {
                textRegion2 = list.get(n);
                if (textRegion2 == textRegion) {
                    return n;
                }
                if (textRegion2.startOffset() != n3) break;
            }
            for (n = n4 + 1; n < list.size(); ++n) {
                textRegion2 = list.get(n);
                if (textRegion2 == textRegion) {
                    return n;
                }
                if (textRegion2.startOffset() != n3) continue block0;
            }
        }
        throw new IllegalStateException("Region: " + textRegion + " not found by binary search:\n" + TextRegionManager.dumpRegions(null, list, 4));
    }

    static void addRegion(TextRegion<?> textRegion, TextRegion<?> textRegion2) {
        Object object;
        int n;
        int n2;
        if (textRegion2.parent() != null) {
            throw new IllegalArgumentException("Region:" + textRegion2 + " already added.");
        }
        List<TextRegion<?>> list = textRegion.validRegions();
        int n3 = textRegion2.startOffset();
        int n4 = textRegion2.endOffset();
        for (n2 = n = TextRegionManager.findRegionInsertIndex(list, n3); n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (n4 >= object.endOffset()) continue;
            if (n4 <= object.startOffset()) break;
            throw new IllegalArgumentException("Inserted region " + textRegion2 + " overlaps with region " + object + " at index=" + n2);
        }
        while (n > 0) {
            int n5;
            object = list.get(n - 1);
            if (n3 == object.startOffset()) {
                n5 = object.endOffset();
                if (n4 < n5) {
                    if (n3 != n4) {
                        TextRegionManager.addRegion(object, textRegion2);
                        return;
                    }
                    n2 = --n;
                    break;
                }
            } else {
                n5 = object.endOffset();
                if (n3 >= n5) break;
                if (n4 <= n5) {
                    TextRegionManager.addRegion(object, textRegion2);
                    return;
                }
                throw new IllegalArgumentException("Inserted region " + textRegion2 + " overlaps with region " + object + " at index=" + (n - 1));
            }
            --n;
        }
        if (n2 - n > 0) {
            object = (GapList)list;
            Object[] objectArray = new TextRegion[n2 - n];
            object.copyElements(n, n2, objectArray, 0);
            object.remove(n, objectArray.length);
            textRegion2.initRegions((TextRegion<?>[])objectArray);
            for (Object object2 : objectArray) {
                ((TextRegion)object2).setParent(textRegion2);
            }
        }
        list.add(n, textRegion2);
        textRegion2.setParent(textRegion);
    }

    static void removeRegionFromParent(TextRegion<?> textRegion) {
        TextRegion<?> textRegion2 = textRegion.parent();
        List<TextRegion<?>> list = textRegion2.regions();
        int n = TextRegionManager.findRegionIndex(list, textRegion);
        list.remove(n);
        textRegion.setParent(null);
        List<TextRegion<?>> list2 = textRegion.regions();
        if (list2 != null) {
            for (TextRegion<?> textRegion3 : list2) {
                list.add(n++, textRegion3);
                textRegion3.setParent(textRegion2);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("Managed regions:\n");
        TextRegionManager.dumpRegions(stringBuilder, this.rootRegion.regions(), 4);
        stringBuilder.append("Managed groups:\n");
        for (TextSyncGroup textSyncGroup : this.editGroups) {
            stringBuilder.append("  ").append(textSyncGroup).append('\n');
        }
        if (this.activeTextSync != null) {
            stringBuilder.append("Active textSync: ").append(this.activeTextSync).append('\n');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static StringBuilder dumpRegions(StringBuilder stringBuilder, List<TextRegion<?>> list, int n) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(100);
        }
        if (list == null) {
            return stringBuilder;
        }
        for (TextRegion<?> textRegion : list) {
            ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
            stringBuilder.append(textRegion).append('\n');
            TextRegionManager.dumpRegions(stringBuilder, textRegion.regions(), n + 4);
        }
        return stringBuilder;
    }

    private static final class DocChangeListener
    implements PropertyChangeListener {
        static final DocChangeListener INSTANCE = new DocChangeListener();

        private DocChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TextRegionManager textRegionManager;
            if ("document".equals(propertyChangeEvent.getPropertyName()) && (textRegionManager = TextRegionManager.get(((JTextComponent)propertyChangeEvent.getSource()).getDocument(), false)) != null) {
                textRegionManager.stopSyncEditing();
            }
        }
    }

    private static final class DocListener
    implements DocumentListener {
        static final DocListener INSTANCE = new DocListener();

        private DocListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextRegionManager.get(documentEvent.getDocument(), false).insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextRegionManager.get(documentEvent.getDocument(), false).removeUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private static final class Highlighting {
        private static final String BAG_DOC_PROPERTY = TextRegionManager.class.getName() + "-OffsetsBag";
        private TextRegionManager textRegionManager;
        private AttributeSet attribs = null;
        private AttributeSet attribsLeft = null;
        private AttributeSet attribsRight = null;
        private AttributeSet attribsMiddle = null;
        private AttributeSet attribsAll = null;

        Highlighting(TextRegionManager textRegionManager) {
            this.textRegionManager = textRegionManager;
        }

        void requestRepaint() {
            TextRegion textRegion;
            Document document = this.textRegionManager.document();
            TextSync textSync = this.textRegionManager.activeTextSync();
            if (textSync != null && (textRegion = textSync.masterRegion()) != null) {
                Object object;
                if (this.attribs == null) {
                    this.attribs = Highlighting.getSyncedTextBlocksHighlight();
                    object = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                    Color color = (Color)this.attribs.getAttribute(StyleConstants.Background);
                    this.attribsLeft = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsRight = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsMiddle = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsAll = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                }
                object = new OffsetsBag(document);
                try {
                    int n = textRegion.startOffset();
                    int n2 = textRegion.endOffset();
                    int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                    int n4 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n2);
                    for (int i = n3; i <= n4; ++i) {
                        int n5 = Math.max(Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)i), n);
                        int n6 = Math.min(Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n5), n2);
                        int n7 = n6 - n5;
                        if (n7 == 1) {
                            object.addHighlight(n5, n6, this.attribsAll);
                            continue;
                        }
                        if (n7 <= 1) continue;
                        object.addHighlight(n5, n5 + 1, this.attribsLeft);
                        object.addHighlight(n6 - 1, n6, this.attribsRight);
                        if (n7 <= 2) continue;
                        object.addHighlight(n5 + 1, n6 - 1, this.attribsMiddle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
                OffsetsBag offsetsBag = Highlighting.getBag(document);
                offsetsBag.setHighlights(object);
            } else {
                OffsetsBag offsetsBag = Highlighting.getBag(document);
                offsetsBag.clear();
                this.attribs = null;
            }
        }

        private static synchronized OffsetsBag getBag(Document document) {
            OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(BAG_DOC_PROPERTY);
            if (offsetsBag == null) {
                offsetsBag = new OffsetsBag(document);
                document.putProperty(BAG_DOC_PROPERTY, offsetsBag);
            }
            return offsetsBag;
        }

        private static AttributeSet getSyncedTextBlocksHighlight() {
            FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
            AttributeSet attributeSet = fontColorSettings.getFontColors("synchronized-text-blocks-ext");
            return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
        }

        private static AttributeSet createAttribs(Object ... objectArray) {
            assert (objectArray.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
                Object object = objectArray[2 * i];
                Object object2 = objectArray[2 * i + 1];
                if (object == null || object2 == null) continue;
                arrayList.add(object);
                arrayList.add(object2);
            }
            return AttributesUtilities.createImmutable((Object[])arrayList.toArray());
        }

        public static final class HLFactory
        implements HighlightsLayerFactory {
            public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
                return new HighlightsLayer[]{HighlightsLayer.create((String)"org.netbeans.lib.editor.codetemplates.CodeTemplateParametersHighlights", (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(490), (boolean)true, (HighlightsContainer)Highlighting.getBag(context.getDocument()))};
            }
        }
    }

    private static final class OverrideAction
    extends TextAction {
        private static final String ORIGINAL_ACTION_PROPERTY = "original-action";
        private static final int TAB = 1;
        private static final int SHIFT_TAB = 2;
        private static final int ENTER = 3;
        private final int actionType;

        public static ActionMap[] installOverrideActionMap(JTextComponent jTextComponent) {
            OverrideAction[] overrideActionArray;
            ActionMap actionMap = jTextComponent.getActionMap();
            ActionMap actionMap2 = new ActionMap();
            for (OverrideAction overrideAction : overrideActionArray = new OverrideAction[]{new OverrideAction(1), new OverrideAction(2), new OverrideAction(3)}) {
                Object object = (String)overrideAction.getValue("Name");
                assert (object != null);
                object = overrideAction.findActionKey(jTextComponent);
                if (object == null) continue;
                Action action = actionMap.get(object);
                overrideAction.putValue(ORIGINAL_ACTION_PROPERTY, action);
                actionMap2.put(object, overrideAction);
            }
            actionMap2.setParent(actionMap);
            jTextComponent.setActionMap(actionMap2);
            return new ActionMap[]{actionMap, actionMap2};
        }

        private static String actionType2Name(int n) {
            switch (n) {
                case 1: {
                    return "insert-tab";
                }
                case 2: {
                    return "remove-tab";
                }
                case 3: {
                    return "insert-break";
                }
            }
            throw new IllegalArgumentException();
        }

        private OverrideAction(int n) {
            super(OverrideAction.actionType2Name(n));
            this.actionType = n;
        }

        private TextRegionManager textRegionManager(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                return TextRegionManager.get(jTextComponent.getDocument(), false);
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextRegionManager textRegionManager = this.textRegionManager(actionEvent);
            if (textRegionManager != null) {
                switch (this.actionType) {
                    case 1: {
                        textRegionManager.tabAction();
                        break;
                    }
                    case 2: {
                        textRegionManager.shiftTabAction();
                        break;
                    }
                    case 3: {
                        if (textRegionManager.enterAction()) break;
                        Action action = (Action)this.getValue(ORIGINAL_ACTION_PROPERTY);
                        action.actionPerformed(actionEvent);
                    }
                }
            }
        }

        Object findActionKey(JTextComponent jTextComponent) {
            KeyStroke keyStroke;
            switch (this.actionType) {
                case 1: {
                    keyStroke = KeyStroke.getKeyStroke(9, 0);
                    break;
                }
                case 2: {
                    keyStroke = KeyStroke.getKeyStroke(9, 1);
                    break;
                }
                case 3: {
                    keyStroke = KeyStroke.getKeyStroke(10, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Object object = jTextComponent.getInputMap().get(keyStroke);
            return object;
        }
    }

    private static final class OverrideKeysListener
    implements KeyListener {
        static OverrideKeysListener INSTANCE = new OverrideKeysListener();

        private OverrideKeysListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TextRegionManager textRegionManager = this.textRegionManager(keyEvent);
            if (textRegionManager == null || !textRegionManager.isActive()) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (KeyStroke.getKeyStroke(27, 0) == keyStroke) {
                textRegionManager.escapeAction();
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private TextRegionManager textRegionManager(KeyEvent keyEvent) {
            return TextRegionManager.get(((JTextComponent)keyEvent.getSource()).getDocument(), false);
        }
    }

    private static final class UpdateDocListener
    implements DocumentListener {
        static final UpdateDocListener INSTANCE = new UpdateDocListener();

        private UpdateDocListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextRegionManager.get(documentEvent.getDocument(), false).removeUpdateUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

