/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileIndexer
extends CustomIndexer {
    public static final String ID = "org-netbeans-modules-jumpto-file-FileIndexer";
    public static final int VERSION = 1;
    public static final String FIELD_NAME = "file-name";
    public static final String FIELD_CASE_INSENSITIVE_NAME = "ci-file-name";
    public static final String FIELD_MIME_TYPE = "mime-type";
    private static final Logger LOG = Logger.getLogger(FileIndexer.class.getName());

    protected void index(Iterable<? extends Indexable> iterable, Context context) {
        try {
            long l = System.currentTimeMillis();
            int n = 0;
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            for (Indexable indexable : iterable) {
                if (context.isCancelled()) {
                    LOG.fine("Indexer cancelled");
                    break;
                }
                ++n;
                String string = FileIndexer.getNameExt(indexable);
                if (string.length() <= 0) continue;
                IndexDocument indexDocument = indexingSupport.createDocument(indexable);
                indexDocument.addPair(FIELD_NAME, string, true, true);
                indexDocument.addPair(FIELD_CASE_INSENSITIVE_NAME, string.toLowerCase(Locale.ENGLISH), true, true);
                String string2 = FileIndexer.getMimeType(indexable);
                if (string2 != null) {
                    indexDocument.addPair(FIELD_MIME_TYPE, string2, false, true);
                }
                indexingSupport.addDocument(indexDocument);
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("added " + indexable.getURL() + "/" + indexable.getRelativePath());
            }
            long l2 = System.currentTimeMillis();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Processed " + n + " files in " + (l2 - l) + "ms.");
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    private static String getNameExt(Indexable indexable) {
        String string = indexable.getRelativePath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return indexable.getRelativePath();
    }

    private static String getMimeType(Indexable indexable) {
        String string = indexable.getMimeType();
        if (!string.equals("content/unknown")) {
            return string;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new FileIndexer();
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    indexingSupport.removeDocuments(indexable);
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    LOG.finest("removed " + indexable.getURL() + "/" + indexable.getRelativePath());
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
        }

        public boolean scanStarted(Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                return indexingSupport.isValid();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return false;
            }
        }

        public void rootsRemoved(Iterable<? extends URL> iterable) {
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public String getIndexerName() {
            return FileIndexer.ID;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

