/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DisconnectAction
extends BaseAction {
    public String getName() {
        return NbBundle.getMessage(DisconnectAction.class, (String)"Disconnect");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DisconnectAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Lookup lookup = nodeArray[i].getLookup();
            ConnectionNode connectionNode = (ConnectionNode)((Object)lookup.lookup(ConnectionNode.class));
            if (connectionNode != null) {
                DatabaseConnection databaseConnection = (DatabaseConnection)lookup.lookup(DatabaseConnection.class);
                if (!databaseConnection.getConnector().isDisconnected()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Lookup lookup = nodeArray[i].getLookup();
                    ConnectionNode connectionNode = (ConnectionNode)((Object)lookup.lookup(ConnectionNode.class));
                    if (connectionNode == null) continue;
                    DatabaseConnection databaseConnection = (DatabaseConnection)lookup.lookup(DatabaseConnection.class);
                    try {
                        databaseConnection.disconnect();
                        continue;
                    }
                    catch (DatabaseException databaseException) {
                        Exceptions.printStackTrace((Throwable)databaseException);
                    }
                }
            }
        });
    }
}

