/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JDBCDriverConvertor
implements Environment.Provider,
InstanceCookie.Of {
    private static Reference providerRef;
    public static final String DRIVERS_PATH = "Databases/JDBCDrivers";
    static final String OLD_DRIVERS_PATH = "Services/JDBCDrivers";
    private static final int DELAY = 2000;
    private static final WeakHashMap<JDBCDriver, DataObject> newDriver2DO;
    private static final Map<FileObject, JDBCDriver> newFile2Driver;
    private final Reference holder;
    private Lookup lookup;
    Reference refDriver = new WeakReference<Object>(null);

    private static synchronized JDBCDriverConvertor createProvider() {
        JDBCDriverConvertor jDBCDriverConvertor = null;
        if (providerRef != null) {
            jDBCDriverConvertor = (JDBCDriverConvertor)providerRef.get();
        }
        if (jDBCDriverConvertor == null) {
            jDBCDriverConvertor = new JDBCDriverConvertor();
            providerRef = new WeakReference<JDBCDriverConvertor>(jDBCDriverConvertor);
        }
        return jDBCDriverConvertor;
    }

    private JDBCDriverConvertor() {
        this.holder = new WeakReference<Object>(null);
    }

    private JDBCDriverConvertor(XMLDataObject xMLDataObject) {
        this.holder = new WeakReference<XMLDataObject>(xMLDataObject);
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
    }

    private JDBCDriverConvertor(XMLDataObject xMLDataObject, JDBCDriver jDBCDriver) {
        this(xMLDataObject);
        this.refDriver = new WeakReference<JDBCDriver>(jDBCDriver);
    }

    public Lookup getEnvironment(DataObject dataObject) {
        JDBCDriver jDBCDriver = newFile2Driver.remove(dataObject.getPrimaryFile());
        if (jDBCDriver != null) {
            return new JDBCDriverConvertor((XMLDataObject)dataObject, jDBCDriver).getLookup();
        }
        return new JDBCDriverConvertor((XMLDataObject)dataObject).getLookup();
    }

    public String instanceName() {
        XMLDataObject xMLDataObject = this.getHolder();
        return xMLDataObject == null ? "" : xMLDataObject.getName();
    }

    public Class instanceClass() {
        return JDBCDriver.class;
    }

    public boolean instanceOf(Class clazz) {
        return clazz.isAssignableFrom(JDBCDriver.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        JDBCDriverConvertor jDBCDriverConvertor = this;
        synchronized (jDBCDriverConvertor) {
            Object t = this.refDriver.get();
            if (t != null) {
                return t;
            }
            XMLDataObject xMLDataObject = this.getHolder();
            if (xMLDataObject == null) {
                return null;
            }
            try {
                JDBCDriver jDBCDriver = JDBCDriverConvertor.readDriverFromFile(xMLDataObject.getPrimaryFile());
                this.refDriver = new WeakReference<JDBCDriver>(jDBCDriver);
                return jDBCDriver;
            }
            catch (MalformedURLException malformedURLException) {
                String string = "Ignoring " + xMLDataObject.getPrimaryFile();
                Logger.getLogger(JDBCDriverConvertor.class.getName()).log(Level.INFO, string, malformedURLException);
                return null;
            }
        }
    }

    private XMLDataObject getHolder() {
        return (XMLDataObject)this.holder.get();
    }

    private static JDBCDriver readDriverFromFile(FileObject fileObject) throws IOException, MalformedURLException {
        URL[] uRLArray;
        Handler handler = new Handler();
        try {
            uRLArray = XMLUtil.createXMLReader();
            InputSource inputSource = new InputSource(fileObject.getInputStream());
            inputSource.setSystemId(fileObject.getURL().toExternalForm());
            uRLArray.setContentHandler(handler);
            uRLArray.setErrorHandler(handler);
            uRLArray.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            uRLArray.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        uRLArray = new URL[handler.urls.size()];
        int n = 0;
        Iterator iterator = handler.urls.iterator();
        while (iterator.hasNext()) {
            uRLArray[n] = new URL((String)iterator.next());
            ++n;
        }
        if (!JDBCDriverConvertor.checkClassPathDrivers(handler.clazz, uRLArray)) {
            return null;
        }
        if (handler.displayName == null) {
            handler.displayName = handler.name;
        }
        return JDBCDriver.create(handler.name, handler.displayName, handler.clazz, uRLArray);
    }

    public static DataObject create(JDBCDriver jDBCDriver) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)DRIVERS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        String string = jDBCDriver.getClassName().replace('.', '_');
        AtomicWriter atomicWriter = new AtomicWriter(jDBCDriver, dataFolder, string);
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicWriter);
        return atomicWriter.holder;
    }

    public static void importOldDrivers() {
        FileObject fileObject = FileUtil.getConfigFile((String)OLD_DRIVERS_PATH);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = FileUtil.getConfigFile((String)DRIVERS_PATH);
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                JDBCDriver jDBCDriver = JDBCDriverConvertor.readDriverFromFile(fileObjectArray[i]);
                URL[] uRLArray = jDBCDriver.getURLs();
                for (int j = 0; j < uRLArray.length; ++j) {
                    uRLArray[j] = JDBCDriverConvertor.encodeURL(uRLArray[j]);
                }
                JDBCDriverConvertor.create(jDBCDriver);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            try {
                fileObjectArray[i].delete();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static URL encodeURL(URL uRL) throws MalformedURLException, URISyntaxException {
        String string = uRL.toExternalForm();
        int n = string.indexOf(58);
        int n2 = string.indexOf(35);
        String string2 = null;
        String string3 = null;
        string2 = string.substring(n + 1, n2 != -1 ? n2 : string.length());
        if (n2 != -1) {
            string3 = string.substring(n2 + 1, string.length());
        }
        return new URI(uRL.getProtocol(), string2, string3).toURL();
    }

    public static void remove(JDBCDriver jDBCDriver) throws IOException {
        String string = jDBCDriver.getName();
        FileObject fileObject = FileUtil.getConfigFile((String)DRIVERS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            JDBCDriver jDBCDriver2;
            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
            if (instanceCookie == null) continue;
            Object object = null;
            try {
                object = instanceCookie.instanceCreate();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!(object instanceof JDBCDriver) || !(jDBCDriver2 = (JDBCDriver)object).getName().equals(string)) continue;
            dataObjectArray[i].delete();
            break;
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private static boolean checkClassPathDrivers(String string, URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!"file:/".equals(uRLArray[i].toString())) continue;
            try {
                Class.forName(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return true;
    }

    static {
        newDriver2DO = new WeakHashMap();
        newFile2Driver = new ConcurrentHashMap<FileObject, JDBCDriver>();
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        JDBCDriver instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(JDBCDriver jDBCDriver, MultiDataObject multiDataObject) {
            this.instance = jDBCDriver;
            this.holder = multiDataObject;
        }

        AtomicWriter(JDBCDriver jDBCDriver, DataFolder dataFolder, String string) {
            this.instance = jDBCDriver;
            this.fileName = string;
            this.parent = dataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            Object object;
            Object object2;
            FileLock fileLock;
            FileObject fileObject;
            if (this.holder != null) {
                fileObject = this.holder.getPrimaryEntry().getFile();
                fileLock = this.holder.getPrimaryEntry().takeLock();
            } else {
                object2 = this.parent.getPrimaryFile();
                object = FileUtil.findFreeFileName((FileObject)object2, (String)this.fileName, (String)"xml");
                fileObject = object2.createData((String)object, "xml");
                fileLock = fileObject.lock();
            }
            try {
                object2 = fileObject.getOutputStream(fileLock);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF8"));
                this.write((PrintWriter)object);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                ((OutputStream)object2).close();
            }
            finally {
                fileLock.releaseLock();
            }
            if (this.holder == null) {
                newFile2Driver.put(fileObject, this.instance);
                this.holder = (MultiDataObject)DataObject.find((FileObject)fileObject);
                this.holder.getCookie(InstanceCookie.class);
                newDriver2DO.put(this.instance, this.holder);
            }
        }

        void write(PrintWriter printWriter) throws IOException {
            printWriter.println("<?xml version='1.0'?>");
            printWriter.println("<!DOCTYPE driver PUBLIC '-//NetBeans//DTD JDBC Driver 1.1//EN' 'http://www.netbeans.org/dtds/jdbc-driver-1_1.dtd'>");
            printWriter.println("<driver>");
            printWriter.println("  <name value='" + XMLUtil.toAttributeValue((String)this.instance.getName()) + "'/>");
            printWriter.println("  <display-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "'/>");
            printWriter.println("  <class value='" + XMLUtil.toAttributeValue((String)this.instance.getClassName()) + "'/>");
            printWriter.println("  <urls>");
            URL[] uRLArray = this.instance.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                printWriter.println("    <url value='" + XMLUtil.toAttributeValue((String)uRLArray[i].toString()) + "'/>");
            }
            printWriter.println("  </urls>");
            printWriter.println("</driver>");
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_NAME = "name";
        private static final String ELEMENT_DISPLAY_NAME = "display-name";
        private static final String ELEMENT_CLASS = "class";
        private static final String ELEMENT_URL = "url";
        private static final String ATTR_PROPERTY_VALUE = "value";
        String name;
        String displayName;
        String clazz;
        LinkedList urls = new LinkedList();

        private Handler() {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ELEMENT_NAME.equals(string3)) {
                this.name = attributes.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_DISPLAY_NAME.equals(string3)) {
                this.displayName = attributes.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_CLASS.equals(string3)) {
                this.clazz = attributes.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_URL.equals(string3)) {
                this.urls.add(attributes.getValue(ATTR_PROPERTY_VALUE));
            }
        }
    }
}

