/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ViewNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Schema> schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ViewNodeProvider(Lookup lookup) {
        super(lookup, new ViewComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Schema schema = (Schema)ViewNodeProvider.this.schemaHandle.resolve(metadata);
                        if (schema != null) {
                            Collection collection = schema.getViews();
                            for (View view : collection) {
                                MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)view);
                                Collection collection2 = ViewNodeProvider.this.getNodes(metadataElementHandle);
                                if (collection2.size() > 0) {
                                    arrayList.addAll(collection2);
                                    continue;
                                }
                                NodeDataLookup nodeDataLookup = new NodeDataLookup();
                                nodeDataLookup.add(ViewNodeProvider.this.connection);
                                nodeDataLookup.add(metadataElementHandle);
                                arrayList.add(ViewNode.create(nodeDataLookup, ViewNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        }
        this.setNodes(arrayList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ViewNodeProvider createInstance(Lookup lookup) {
                ViewNodeProvider viewNodeProvider = new ViewNodeProvider(lookup);
                return viewNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewComparator
    implements Comparator<Node> {
        ViewComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }
}

