/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.runtime;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseRuntimeManager {
    private static final Logger LOGGER = Logger.getLogger(DatabaseRuntimeManager.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String RUNTIMES_PATH = "Databases/Runtimes";
    private static DatabaseRuntimeManager DEFAULT = null;
    private Lookup.Result<DatabaseRuntime> result = this.getLookupResult();

    public static synchronized DatabaseRuntimeManager getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new DatabaseRuntimeManager();
        }
        return DEFAULT;
    }

    public DatabaseRuntime[] getRuntimes() {
        Collection collection = this.result.allInstances();
        return collection.toArray(new DatabaseRuntime[collection.size()]);
    }

    public DatabaseRuntime[] getRuntimes(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        LinkedList<DatabaseRuntime> linkedList = new LinkedList<DatabaseRuntime>();
        for (DatabaseRuntime databaseRuntime : this.result.allInstances()) {
            if (LOG) {
                LOGGER.log(Level.FINE, "Runtime: " + databaseRuntime.getClass().getName() + " for driver " + databaseRuntime.getJDBCDriverClass());
            }
            if (!string.equals(databaseRuntime.getJDBCDriverClass())) continue;
            linkedList.add(databaseRuntime);
        }
        return linkedList.toArray(new DatabaseRuntime[linkedList.size()]);
    }

    private synchronized Lookup.Result<DatabaseRuntime> getLookupResult() {
        return Lookups.forPath((String)RUNTIMES_PATH).lookupResult(DatabaseRuntime.class);
    }
}

