/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.util.DataComboBoxModel;
import org.netbeans.modules.db.util.DataComboBoxSupport;
import org.netbeans.modules.db.util.DriverListUtil;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.util.NbBundle;

public final class DatabaseExplorerInternalUIs {
    private DatabaseExplorerInternalUIs() {
    }

    public static void connect(JComboBox jComboBox, JDBCDriverManager jDBCDriverManager) {
        DatabaseExplorerInternalUIs.connect(jComboBox, jDBCDriverManager, null);
    }

    public static void connect(JComboBox jComboBox, JDBCDriverManager jDBCDriverManager, String string) {
        DataComboBoxSupport.connect(jComboBox, new DriverDataComboBoxModel(jDBCDriverManager, string), string == null);
    }

    private static final class DriverComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final ArrayList<JdbcUrl> driverList;
        private Object selectedItem;

        public DriverComboBoxModel(JDBCDriverManager jDBCDriverManager, String string) {
            this.driverManager = jDBCDriverManager;
            this.driverList = new ArrayList();
            JDBCDriver[] jDBCDriverArray = string != null ? jDBCDriverManager.getDrivers(string) : jDBCDriverManager.getDrivers();
            for (int i = 0; i < jDBCDriverArray.length; ++i) {
                JDBCDriver jDBCDriver = jDBCDriverArray[i];
                if (!JDBCDriverSupport.isAvailable(jDBCDriver)) continue;
                this.driverList.addAll(DriverListUtil.getJdbcUrls(jDBCDriver));
            }
            Collections.sort(this.driverList, new DriverTypeComparator());
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        public Object getElementAt(int n) {
            return this.driverList.get(n);
        }

        public int getSize() {
            return this.driverList.size();
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void addSelectedDriver(JDBCDriver jDBCDriver) {
            List<JdbcUrl> list = DriverListUtil.getJdbcUrls(jDBCDriver);
            assert (!list.isEmpty());
            this.driverList.addAll(list);
            this.setSelectedItem(list.get(0));
            Collections.sort(this.driverList, new DriverTypeComparator());
            this.fireContentsChanged(this, 0, this.driverList.size());
        }
    }

    private static final class DriverDataComboBoxModel
    implements DataComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final DriverComboBoxModel comboBoxModel;

        public DriverDataComboBoxModel(JDBCDriverManager jDBCDriverManager, String string) {
            this.driverManager = jDBCDriverManager;
            this.comboBoxModel = new DriverComboBoxModel(jDBCDriverManager, string);
        }

        public String getItemTooltipText(Object object) {
            JdbcUrl jdbcUrl = (JdbcUrl)object;
            if (jdbcUrl.getDriver() == null) {
                return "";
            }
            return jdbcUrl.getDriver().toString();
        }

        public String getItemDisplayName(Object object) {
            return ((JdbcUrl)object).getDisplayName();
        }

        public void newItemActionPerformed() {
            HashSet<JDBCDriver> hashSet = new HashSet<JDBCDriver>(Arrays.asList(this.driverManager.getDrivers()));
            this.driverManager.showAddDriverDialog();
            JDBCDriver[] jDBCDriverArray = this.driverManager.getDrivers();
            if (jDBCDriverArray.length == hashSet.size()) {
                return;
            }
            for (int i = 0; i < jDBCDriverArray.length; ++i) {
                if (hashSet.contains(jDBCDriverArray[i])) continue;
                this.comboBoxModel.addSelectedDriver(jDBCDriverArray[i]);
                break;
            }
        }

        public String getNewItemDisplayName() {
            return NbBundle.getMessage(DatabaseExplorerInternalUIs.class, (String)"LBL_NewDriver");
        }

        public ComboBoxModel getListModel() {
            return this.comboBoxModel;
        }
    }

    private static final class DriverTypeComparator
    implements Comparator {
        private DriverTypeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return object2 == null ? 0 : -1;
            }
            if (object2 == null) {
                return 1;
            }
            String string = ((JdbcUrl)object).getName();
            String string2 = ((JdbcUrl)object2).getName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareToIgnoreCase(string2);
        }
    }
}

