/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.util.NoMBean;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();
    static Hashtable specialMethods = new Hashtable();
    private static String[] strArray;
    private static ObjectName[] objNameArray;
    private static Class[] supportedTypes;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            ManagedBean managedBean = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managedBean == null) {
                return;
            }
            managedBean.setName(this.type);
            this.mbeans.add(managedBean);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class).error((Object)"Error reading descriptors ", (Throwable)exception);
        }
    }

    private boolean supportedType(Class clazz) {
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (clazz != supportedTypes[i]) continue;
            return true;
        }
        return this.isBeanCompatible(clazz);
    }

    protected boolean isBeanCompatible(Class clazz) {
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Class clazz2 = clazz.getSuperclass();
        return clazz2 == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || this.isBeanCompatible(clazz2);
    }

    private void initMethods(Class clazz, Method[] methodArray, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class);
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (Modifier.isStatic(methodArray[i].getModifiers()) || !Modifier.isPublic(methodArray[i].getModifiers()) || methodArray[i].getDeclaringClass() == Object.class || methodArray[i].isAnnotationPresent(NoMBean.class)) continue;
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (string.startsWith("get") && classArray.length == 0) {
                Class<?> clazz2 = methodArray[i].getReturnType();
                if (!this.supportedType(clazz2)) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable2.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (string.startsWith("is") && classArray.length == 0) {
                Class<?> clazz3 = methodArray[i].getReturnType();
                if (Boolean.TYPE != clazz3) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(2));
                hashtable2.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (string.startsWith("set") && classArray.length == 1) {
                if (!this.supportedType(classArray[0])) continue;
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                hashtable3.put(string, methodArray[i]);
                hashtable.put(string, methodArray[i]);
                continue;
            }
            if (classArray.length == 0) {
                if (specialMethods.get(methodArray[i].getName()) != null) continue;
                hashtable4.put(string, methodArray[i]);
                continue;
            }
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                if (this.supportedType(classArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashtable4.put(string, methodArray[i]);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String string, Class clazz, String string2) {
        ManagedBean managedBean = new ManagedBean();
        Method[] methodArray = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        methodArray = clazz.getMethods();
        this.initMethods(clazz, methodArray, hashtable, hashtable2, hashtable3, hashtable4);
        try {
            Object object;
            Class<?>[] classArray;
            Object object2;
            Object object3;
            Object object4;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object4 = (Constructor<?>[])enumeration.nextElement();
                object3 = new AttributeInfo();
                ((AttributeInfo)object3).setName((String)object4);
                object2 = (Method)hashtable2.get(object4);
                if (object2 != null) {
                    ((AttributeInfo)object3).setGetMethod(((Method)object2).getName());
                    classArray = ((Method)object2).getReturnType();
                    if (classArray != null) {
                        ((AttributeInfo)object3).setType(classArray.getName());
                    }
                }
                if ((classArray = (Method)hashtable3.get(object4)) != null) {
                    Class<?> clazz2 = classArray.getParameterTypes()[0];
                    if (clazz2 != null) {
                        ((AttributeInfo)object3).setType(clazz2.getName());
                    }
                    ((AttributeInfo)object3).setSetMethod(classArray.getName());
                }
                ((AttributeInfo)object3).setDescription("Introspected attribute " + object4);
                if (object2 == null) {
                    ((AttributeInfo)object3).setReadable(false);
                }
                if (classArray == null) {
                    ((AttributeInfo)object3).setWriteable(false);
                }
                if (classArray == null && object2 == null) continue;
                managedBean.addAttribute((AttributeInfo)object3);
            }
            enumeration = hashtable4.keys();
            while (enumeration.hasMoreElements()) {
                object4 = (String)enumeration.nextElement();
                object3 = (Method)hashtable4.get(object4);
                if (object3 != null && object4 != null) {
                    object2 = new OperationInfo();
                    ((OperationInfo)object2).setName((String)object4);
                    ((OperationInfo)object2).setReturnType(((Method)object3).getReturnType().getName());
                    ((OperationInfo)object2).setDescription("Introspected operation " + object4);
                    classArray = ((Method)object3).getParameterTypes();
                    for (int i = 0; i < classArray.length; ++i) {
                        object = new ParameterInfo();
                        ((ParameterInfo)object).setType(classArray[i].getName());
                        ((ParameterInfo)object).setName("param" + i);
                        ((ParameterInfo)object).setDescription("Introspected parameter param" + i);
                        ((OperationInfo)object2).addParameter((ParameterInfo)object);
                    }
                    managedBean.addOperation((OperationInfo)object2);
                    continue;
                }
                WMSLoggerFactory.getLogger(MbeansDescriptorsIntrospectionSource.class).error("Null arg " + object4 + " " + object3);
            }
            object4 = clazz.getConstructors();
            for (int i = 0; i < ((Constructor<?>[])object4).length; ++i) {
                object2 = new ConstructorInfo();
                classArray = clazz.getName();
                int n = -1;
                n = classArray.lastIndexOf(46);
                if (n != -1) {
                    classArray = classArray.substring(n + 1);
                }
                ((ConstructorInfo)object2).setName((String)classArray);
                ((ConstructorInfo)object2).setDescription(object4[i].getName());
                object = object4[i].getParameterTypes();
                for (int j = 0; j < ((Class<?>[])object).length; ++j) {
                    ParameterInfo parameterInfo = new ParameterInfo();
                    parameterInfo.setType(object[j].getName());
                    parameterInfo.setName("param" + j);
                    parameterInfo.setDescription("Introspected parameter param" + j);
                    ((ConstructorInfo)object2).addParameter(parameterInfo);
                }
                managedBean.addConstructor((ConstructorInfo)object2);
            }
            managedBean.setName(string2);
            return managedBean;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        strArray = new String[0];
        objNameArray = new ObjectName[0];
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, strArray.getClass(), BigDecimal.class, BigInteger.class, ObjectName.class, objNameArray.getClass(), File.class};
    }
}

