/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xml.actions.InputOutputReporter;
import org.netbeans.modules.xml.lib.FileUtilities;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xsl.actions.TransformAction;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class TransformPerformer {
    private InputOutputReporter cookieObserver = null;
    private Node[] nodes;
    private volatile boolean stalled = false;
    private volatile boolean active = true;

    public TransformPerformer(Node[] nodeArray) {
        this.nodes = nodeArray;
    }

    private void saveBeforeTransformation(DataObject dataObject) {
        SaveCookie saveCookie;
        if (dataObject.isModified() && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        if (this.stalled) {
            throw new IllegalStateException();
        }
        try {
            if (this.nodes.length == 2) {
                DataObject dataObject = (DataObject)this.nodes[0].getCookie(DataObject.class);
                boolean bl = TransformUtil.isXSLTransformation(dataObject);
                DataObject dataObject2 = (DataObject)this.nodes[1].getCookie(DataObject.class);
                boolean bl2 = TransformUtil.isXSLTransformation(dataObject2);
                this.saveBeforeTransformation(dataObject);
                this.saveBeforeTransformation(dataObject2);
                if (bl != bl2) {
                    DataObject dataObject3;
                    DataObject dataObject4;
                    TransformableCookie transformableCookie;
                    if (bl) {
                        transformableCookie = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                        dataObject4 = dataObject2;
                        dataObject3 = dataObject;
                    } else {
                        transformableCookie = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                        dataObject4 = dataObject;
                        dataObject3 = dataObject2;
                    }
                    DoublePerformer doublePerformer = new DoublePerformer(transformableCookie, dataObject4, dataObject3);
                    doublePerformer.perform();
                } else {
                    TransformableCookie transformableCookie = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                    SinglePerformer singlePerformer = new SinglePerformer(transformableCookie, dataObject, bl);
                    singlePerformer.setLastInBatch(false);
                    singlePerformer.perform();
                    TransformableCookie transformableCookie2 = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                    singlePerformer = new SinglePerformer(transformableCookie2, dataObject2, bl2);
                    singlePerformer.perform();
                }
            } else {
                for (int i = 0; i < this.nodes.length; ++i) {
                    DataObject dataObject = (DataObject)this.nodes[i].getCookie(DataObject.class);
                    this.saveBeforeTransformation(dataObject);
                    TransformableCookie transformableCookie = null;
                    boolean bl = TransformUtil.isXSLTransformation(dataObject);
                    if (!bl) {
                        transformableCookie = (TransformableCookie)this.nodes[i].getCookie(TransformableCookie.class);
                    }
                    SinglePerformer singlePerformer = new SinglePerformer(transformableCookie, dataObject, bl);
                    singlePerformer.setLastInBatch(i == this.nodes.length - 1);
                    singlePerformer.perform();
                }
            }
        }
        finally {
            this.stalled = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private InputOutputReporter getCookieObserver() {
        if (this.cookieObserver == null) {
            String string = NbBundle.getMessage(TransformPerformer.class, (String)"PROP_transformation_io_name");
            this.cookieObserver = new InputOutputReporter(string);
        }
        return this.cookieObserver;
    }

    private abstract class AbstractPerformer
    extends WindowAdapter
    implements ActionListener {
        private TransformableCookie transformableCookie;
        protected DataObject xmlDO;
        protected Source xmlStylesheetSource;
        protected DataObject xslDO;
        protected FileObject baseFO;
        protected URL baseURL;
        private Source xmlSource;
        private Source xslSource;
        private FileObject resultFO;
        private TransformPanel transformPanel;
        private DialogDescriptor dialogDescriptor;
        private Dialog dialog;
        private TransformPanel.Data data;
        private boolean last = true;
        private boolean workaround31850 = true;

        public AbstractPerformer(TransformableCookie transformableCookie) {
            this.transformableCookie = transformableCookie;
        }

        public final void perform() {
            block2: {
                try {
                    this.init();
                    this.showDialog();
                }
                catch (IOException iOException) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    if (!this.isLastInBatch()) break block2;
                    TransformPerformer.this.active = false;
                }
            }
        }

        protected abstract void init() throws IOException;

        protected abstract void storeData();

        private void showDialog() throws IOException {
            String string = null;
            if (this.xmlStylesheetSource != null) {
                string = this.xmlStylesheetSource.getSystemId();
            }
            this.transformPanel = new TransformPanel(this.xmlDO, string, this.xslDO);
            this.dialogDescriptor = new DialogDescriptor((Object)this.transformPanel, NbBundle.getMessage(TransformPerformer.class, (String)"NAME_transform_panel_title"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(TransformAction.class), null);
            this.dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            this.dialogDescriptor.setButtonListener((ActionListener)this);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
            this.dialog.addWindowListener(this);
            this.dialog.show();
        }

        protected void prepareData() throws IOException, FileStateInvalidException, MalformedURLException, ParserConfigurationException, SAXException {
            this.data = this.transformPanel.getData();
            try {
                this.xmlSource = TransformUtil.createSource(this.baseURL, this.data.getInput());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_sourceError"));
                throw iOException;
            }
            if (this.data.getXSL() != null) {
                try {
                    this.xslSource = TransformUtil.createSource(this.baseURL, this.data.getXSL());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transError"));
                    throw iOException;
                }
            } else {
                this.xslSource = this.xmlStylesheetSource;
            }
            if (this.data.getOutput() != null) {
                String string = this.data.getOutput().toString().replace('\\', '/');
                try {
                    this.resultFO = FileUtilities.createFileObject((FileObject)this.baseFO.getParent(), (String)string, (boolean)this.data.isOverwriteOutput());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_resultError"));
                    throw iOException;
                }
            }
        }

        protected void updateHistory(DataObject dataObject, boolean bl) {
            FileObject fileObject = dataObject.getPrimaryFile();
            TransformHistory transformHistory = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (transformHistory == null) {
                transformHistory = new TransformHistory();
            }
            String string = null;
            if (this.data.getOutput() != null) {
                string = this.data.getOutput().toString();
            }
            if (bl) {
                transformHistory.addXML(this.data.getInput(), string);
            } else {
                transformHistory.addXSL(this.data.getXSL(), string);
            }
            transformHistory.setOverwriteOutput(this.data.isOverwriteOutput());
            transformHistory.setProcessOutput(this.data.getProcessOutput());
            try {
                fileObject.setAttribute("org.netbeans.modules.xsl.settings.TransformHistory", (Object)transformHistory);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        private void previewOutput() throws MalformedURLException, UnknownHostException {
            TransformServlet.prepare(this.transformableCookie, this.xmlSource, this.xslSource);
            this.showURL(TransformServlet.getServletURL());
        }

        private void fileOutput() throws IOException, FileStateInvalidException, TransformerException {
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                fileLock = this.resultFO.lock();
                outputStream = this.resultFO.getOutputStream(fileLock);
                StreamResult streamResult = new StreamResult(outputStream);
                String string = this.data.getInput();
                String string2 = this.data.getXSL();
                TransformPerformer.this.getCookieObserver().message(NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transformation_1", (Object)string, (Object)string2));
                TransformUtil.transform(this.xmlSource, this.transformableCookie, this.xslSource, streamResult, (CookieObserver)TransformPerformer.this.getCookieObserver());
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.resultFO);
                    dataObject.setValid(false);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw new IllegalStateException();
                }
                catch (PropertyVetoException propertyVetoException) {
                    ErrorManager.getDefault().log(1, "Cannot invalidate " + this.resultFO);
                }
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)fileAlreadyLockedException, NbBundle.getMessage(TransformPerformer.class, (String)"ERR_FileAlreadyLockedException_output"));
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            if (this.data.getProcessOutput() == 1) {
                GuiUtil.performDefaultAction((FileObject)this.resultFO);
            } else if (this.data.getProcessOutput() == 2) {
                this.showURL(this.resultFO.getURL());
            }
        }

        private void showURL(URL uRL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            GuiUtil.setStatusText((String)NbBundle.getMessage(TransformPerformer.class, (String)"MSG_opening_browser"));
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            this.workaround31850 = false;
            if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                try {
                    this.prepareData();
                    if (this.data.getOutput() != null && this.resultFO == null) {
                        return;
                    }
                    this.dialog.dispose();
                    this.storeData();
                    this.async();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(16, (Throwable)exception);
                    if (this.isLastInBatch()) {
                        TransformPerformer.this.active = false;
                    }
                }
            } else {
                TransformPerformer.this.active = false;
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            super.windowClosed(windowEvent);
            if (this.workaround31850) {
                TransformPerformer.this.active = false;
            }
        }

        private void async() {
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            requestProcessor.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (AbstractPerformer.this.data.getOutput() == null) {
                            AbstractPerformer.this.previewOutput();
                        } else {
                            AbstractPerformer.this.fileOutput();
                        }
                    }
                    catch (TransformerException transformerException) {
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(16, (Throwable)exception);
                    }
                    finally {
                        if (AbstractPerformer.this.isLastInBatch()) {
                            InputOutputReporter inputOutputReporter = TransformPerformer.this.getCookieObserver();
                            if (inputOutputReporter != null) {
                                inputOutputReporter.message(NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transformation_2"));
                                inputOutputReporter.moveToFront(true);
                            }
                            TransformPerformer.this.active = false;
                        }
                    }
                }
            });
        }

        protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
            URL uRL = null;
            File file = FileUtil.toFile((FileObject)fileObject);
            uRL = file != null ? file.toURL() : fileObject.getURL();
            return uRL;
        }

        public final void setLastInBatch(boolean bl) {
            this.last = bl;
        }

        public final boolean isLastInBatch() {
            return this.last;
        }
    }

    private class DoublePerformer
    extends AbstractPerformer {
        public DoublePerformer(TransformableCookie transformableCookie, DataObject dataObject, DataObject dataObject2) {
            super(transformableCookie);
            this.xmlDO = dataObject;
            this.xslDO = dataObject2;
        }

        protected void init() throws IOException {
            this.baseFO = this.xmlDO.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
        }

        protected void storeData() {
            this.updateHistory(this.xmlDO, false);
            this.updateHistory(this.xslDO, true);
        }
    }

    private class SinglePerformer
    extends AbstractPerformer {
        private DataObject dataObject;
        private boolean xslt;

        public SinglePerformer(TransformableCookie transformableCookie, DataObject dataObject, boolean bl) {
            super(transformableCookie);
            this.dataObject = dataObject;
            this.xslt = bl;
        }

        protected void init() throws IOException {
            this.baseFO = this.dataObject.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
            if (this.xslt) {
                this.xmlDO = null;
                this.xmlStylesheetSource = null;
                this.xslDO = this.dataObject;
            } else {
                this.xmlDO = this.dataObject;
                this.xmlStylesheetSource = TransformUtil.getAssociatedStylesheet(this.baseURL);
                this.xslDO = null;
            }
        }

        protected void storeData() {
            this.updateHistory(this.dataObject, this.xslt);
        }
    }
}

