/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataModelImplementation;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.mssql.MSSQLMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.mysql.MySQLMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnMetadataModel
implements MetadataModelImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCConnMetadataModel.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final WeakReference<Connection> connRef;
    private final String defaultSchemaName;
    private JDBCMetadata jdbcMetadata;

    public JDBCConnMetadataModel(Connection connection, String string) {
        this.connRef = new WeakReference<Connection>(connection);
        this.defaultSchemaName = string != null && string.trim().length() == 0 ? null : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runReadAction(Action<Metadata> action) throws MetadataModelException {
        this.lock.lock();
        try {
            Connection connection = (Connection)this.connRef.get();
            if (connection == null) {
                return;
            }
            try {
                this.enterReadAccess(connection);
                if (this.jdbcMetadata != null) {
                    Metadata metadata = this.jdbcMetadata.getMetadata();
                    action.run(metadata);
                }
            }
            catch (SQLException sQLException) {
                throw new MetadataModelException(sQLException);
            }
            catch (MetadataException metadataException) {
                throw new MetadataModelException(metadataException);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LOGGER.fine("Refreshing model");
        this.lock.lock();
        try {
            this.jdbcMetadata = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enterReadAccess(Connection connection) throws SQLException {
        Connection connection2;
        if (connection == null) {
            throw new NullPointerException("Connection can not be null");
        }
        Connection connection3 = connection2 = this.jdbcMetadata != null ? this.jdbcMetadata.getConnection() : null;
        if (connection2 != connection) {
            this.jdbcMetadata = connection != null ? JDBCConnMetadataModel.createMetadata(connection, this.defaultSchemaName) : null;
        }
    }

    private static JDBCMetadata createMetadata(Connection connection, String string) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if ("Oracle".equals(databaseMetaData.getDatabaseProductName())) {
                return new OracleMetadata(connection, string);
            }
            if ("mysql".equalsIgnoreCase(databaseMetaData.getDatabaseProductName())) {
                return new MySQLMetadata(connection, string);
            }
            String string2 = databaseMetaData.getDriverName();
            if (string2 != null && (string2.contains("Microsoft SQL Server") || string2.contains("jTDS"))) {
                return new MSSQLMetadata(connection, string);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.INFO, null, sQLException);
        }
        return new JDBCMetadata(connection, string);
    }
}

