/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.View;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCProcedure;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCTable;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCView;
import org.netbeans.modules.db.metadata.model.spi.SchemaImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCSchema
extends SchemaImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCSchema.class.getName());
    protected final JDBCCatalog jdbcCatalog;
    protected final String name;
    protected final boolean _default;
    protected final boolean synthetic;
    protected Map<String, Table> tables;
    protected Map<String, View> views;
    protected Map<String, Procedure> procedures;

    public JDBCSchema(JDBCCatalog jDBCCatalog, String string, boolean bl, boolean bl2) {
        this.jdbcCatalog = jDBCCatalog;
        this.name = string;
        this._default = bl;
        this.synthetic = bl2;
    }

    @Override
    public final Catalog getParent() {
        return this.jdbcCatalog.getCatalog();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isDefault() {
        return this._default;
    }

    @Override
    public final boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public final Collection<Table> getTables() {
        return this.initTables().values();
    }

    @Override
    public final Table getTable(String string) {
        return MetadataUtilities.find(string, this.initTables());
    }

    @Override
    public View getView(String string) {
        return MetadataUtilities.find(string, this.initViews());
    }

    @Override
    public Collection<View> getViews() {
        return this.initViews().values();
    }

    @Override
    public Procedure getProcedure(String string) {
        return this.initProcedures().get(string);
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return this.initProcedures().values();
    }

    @Override
    public void refresh() {
        this.tables = null;
        this.views = null;
        this.procedures = null;
    }

    public String toString() {
        return "JDBCSchema[name='" + this.name + "',default=" + this._default + ",synthetic=" + this.synthetic + "]";
    }

    protected JDBCTable createJDBCTable(String string) {
        return new JDBCTable(this, string);
    }

    protected JDBCProcedure createJDBCProcedure(String string) {
        return new JDBCProcedure(this, string);
    }

    protected JDBCView createJDBCView(String string) {
        return new JDBCView(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Table> linkedHashMap = new LinkedHashMap<String, Table>();
        try {
            ResultSet resultSet = this.jdbcCatalog.getJDBCMetadata().getDmd().getTables(this.jdbcCatalog.getName(), this.name, "%", new String[]{"TABLE", "SYSTEM TABLE"});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    Table table = this.createJDBCTable(string).getTable();
                    linkedHashMap.put(string, table);
                    LOGGER.log(Level.FINE, "Created table {0}", table);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.tables = Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createViews() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, View> linkedHashMap = new LinkedHashMap<String, View>();
        try {
            ResultSet resultSet = this.jdbcCatalog.getJDBCMetadata().getDmd().getTables(this.jdbcCatalog.getName(), this.name, "%", new String[]{"VIEW"});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    View view = this.createJDBCView(string).getView();
                    linkedHashMap.put(string, view);
                    LOGGER.log(Level.FINE, "Created view {0}", view);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.views = Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProcedures() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Procedure> linkedHashMap = new LinkedHashMap<String, Procedure>();
        try {
            ResultSet resultSet = this.jdbcCatalog.getJDBCMetadata().getDmd().getProcedures(this.jdbcCatalog.getName(), this.name, "%");
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("PROCEDURE_NAME");
                    Procedure procedure = this.createJDBCProcedure(string).getProcedure();
                    linkedHashMap.put(string, procedure);
                    LOGGER.log(Level.FINE, "Created procedure {0}", procedure);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.procedures = Collections.unmodifiableMap(linkedHashMap);
    }

    private Map<String, Table> initTables() {
        if (this.tables != null) {
            return this.tables;
        }
        this.createTables();
        return this.tables;
    }

    public final JDBCCatalog getJDBCCatalog() {
        return this.jdbcCatalog;
    }

    private Map<String, View> initViews() {
        if (this.views != null) {
            return this.views;
        }
        this.createViews();
        return this.views;
    }

    private Map<String, Procedure> initProcedures() {
        if (this.procedures != null) {
            return this.procedures;
        }
        this.createProcedures();
        return this.procedures;
    }
}

