/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.openide.util.NbBundle;

public class HgHookImpl
extends HgHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"changeset", "author", "date", "message"};
    private HookPanel panel;
    private final String name = NbBundle.getMessage(HgHookImpl.class, (String)"LBL_VCSHook");
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HgHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public HgHookContext beforeCommit(HgHookContext hgHookContext) throws IOException {
        Repository repository = this.getSelectedRepository();
        if (hgHookContext.getFiles().length == 0) {
            if (repository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, repository);
            }
            LOG.warning("calling hg beforeCommit for zero files");
            return null;
        }
        if (repository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(hgHookContext.getFiles(), repository);
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "hg beforeCommit start for " + file);
        if (this.isLinkSelected()) {
            String string = hgHookContext.getMessage();
            VCSHooksConfig.Format format = VCSHooksConfig.getInstance().getHgIssueInfoTemplate();
            String string2 = format.getFormat();
            string2 = HookUtils.prepareFormatString(string2, SUPPORTED_ISSUE_INFO_VARIABLES);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for " + file);
                return null;
            }
            String string3 = new MessageFormat(string2).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook issue info '" + string3 + "'");
            string = format.isAbove() ? string3 + "\n" + string : string + "\n" + string3;
            hgHookContext = new HgHookContext(hgHookContext.getFiles(), string, hgHookContext.getLogEntries());
            return hgHookContext;
        }
        return super.beforeCommit(hgHookContext);
    }

    public void afterCommit(HgHookContext hgHookContext) {
        VCSHooksConfig.getInstance().setHgLink(this.isLinkSelected());
        VCSHooksConfig.getInstance().setHgResolve(this.isResolveSelected());
        VCSHooksConfig.getInstance().setHgAfterCommit(this.isCommitSelected());
        if (hgHookContext.getFiles().length == 0) {
            LOG.warning("calling hg afterCommit for zero files");
            return;
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "hg afterCommit start for " + file);
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in hg afterCommit for " + file);
            return;
        }
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for " + file);
            return;
        }
        String string = null;
        if (this.isLinkSelected()) {
            String string2 = hgHookContext.getLogEntries()[0].getAuthor();
            String string3 = hgHookContext.getLogEntries()[0].getChangeset();
            Date date = hgHookContext.getLogEntries()[0].getDate();
            String string4 = hgHookContext.getLogEntries()[0].getMessage();
            String string5 = VCSHooksConfig.getInstance().getHgRevisionTemplate().getFormat();
            string5 = HookUtils.prepareFormatString(string5, SUPPORTED_REVISION_VARIABLES);
            string = new MessageFormat(string5).format(new Object[]{string3, string2, date != null ? CC_DATE_FORMAT.format(date) : "", string4}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " hg afterCommit message '" + string + "'");
        }
        if (this.isCommitSelected()) {
            issue.addComment(string, this.isResolveSelected());
            issue.open();
        } else {
            VCSHooksConfig.getInstance().setHgPushAction(hgHookContext.getLogEntries()[0].getChangeset(), new VCSHooksConfig.PushOperation(issue.getID(), string, this.isResolveSelected()));
            LOG.log(Level.FINE, "schedulig issue  " + file);
        }
        LOG.log(Level.FINE, "hg afterCommit end for " + file);
        VCSHooksConfig.logHookUsage("HG", this.getSelectedRepository());
    }

    public HgHookContext beforePush(HgHookContext hgHookContext) throws IOException {
        return super.beforePush(hgHookContext);
    }

    public void afterPush(HgHookContext hgHookContext) {
        HgHookContext.LogEntry[] logEntryArray;
        if (hgHookContext.getFiles().length == 0) {
            LOG.warning("calling after push for zero files");
            return;
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "push hook start for " + file);
        Repository repository = null;
        for (HgHookContext.LogEntry logEntry : logEntryArray = hgHookContext.getLogEntries()) {
            VCSHooksConfig.PushOperation pushOperation = VCSHooksConfig.getInstance().popHGPushAction(logEntry.getChangeset());
            if (pushOperation == null) {
                LOG.log(Level.FINE, " no push hook scheduled for " + file);
                continue;
            }
            if (repository == null && (repository = BugtrackingOwnerSupport.getInstance().getRepository(file, true)) == null) {
                LOG.log(Level.WARNING, " could not find issue tracker for " + file);
                break;
            }
            Issue issue = repository.getIssue(pushOperation.getIssueID());
            if (issue == null) {
                LOG.log(Level.FINE, " no issue found with id " + pushOperation.getIssueID());
                continue;
            }
            issue.addComment(pushOperation.getMsg(), this.isResolveSelected());
        }
        LOG.log(Level.FINE, "push hook end for " + file);
    }

    public JPanel createComponent(HgHookContext hgHookContext) {
        File file;
        LOG.finer("HgHookImpl.createComponent()");
        if (hgHookContext.getFiles().length == 0) {
            file = null;
            LOG.warning("creating hg hook component for zero files");
        } else {
            file = hgHookContext.getFiles()[0];
        }
        this.panel = new HookPanel();
        this.panel.resolveCheckBox.setSelected(VCSHooksConfig.getInstance().getHgResolve());
        boolean bl = VCSHooksConfig.getInstance().getHgAfterCommit();
        this.panel.commitRadioButton.setSelected(bl);
        this.panel.pushRadioButton.setSelected(!bl);
        if (file != null) {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (File)file);
        } else {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (boolean)false);
        }
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HgHookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private void onShowFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getHgRevisionTemplate(), VCSHooksConfig.getDefaultHgRevisionTemplate(), SUPPORTED_REVISION_VARIABLES, VCSHooksConfig.getInstance().getHgIssueInfoTemplate(), VCSHooksConfig.getDefaultIssueInfoTemplate(), SUPPORTED_ISSUE_INFO_VARIABLES);
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setHgRevisionTemplate(formatPanel.getIssueFormat());
            VCSHooksConfig.getInstance().setHgIssueInfoTemplate(formatPanel.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private boolean isCommitSelected() {
        return this.panel != null && this.panel.commitRadioButton.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

