/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCompletionPopup
extends JPopupMenu
implements KeyListener {
    private JList list;
    private JTextField textField;
    private JFileChooser chooser;

    public FileCompletionPopup(JFileChooser jFileChooser, JTextField jTextField, Vector<File> vector) {
        this.list = new JList<File>(vector);
        this.textField = jTextField;
        this.chooser = jFileChooser;
        this.list.setVisibleRowCount(4);
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add(jScrollPane);
        this.list.setFocusable(false);
        jScrollPane.setFocusable(false);
        this.setFocusable(false);
        this.list.addFocusListener(new FocusHandler());
        this.list.addMouseListener(new MouseHandler());
        this.list.addMouseMotionListener(new MouseHandler());
        jTextField.addKeyListener(this);
    }

    public void setDataList(Vector vector) {
        this.list.setListData(vector);
        this.ensureSelection();
    }

    private void setSelectNext() {
        if (this.list.getModel().getSize() > 0) {
            int n = (this.list.getSelectedIndex() + 1) % this.list.getModel().getSize();
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    private void setSelectPrevious() {
        if (this.list.getModel().getSize() > 0) {
            int n = this.list.getSelectedIndex() == -1 ? 0 : this.list.getSelectedIndex();
            n = n == 0 ? this.list.getModel().getSize() - 1 : n - 1;
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    public void showPopup(JTextComponent jTextComponent, int n, int n2) {
        if (this.list.getModel().getSize() == 0) {
            return;
        }
        this.setPreferredSize(new Dimension(jTextComponent.getWidth(), jTextComponent.getHeight() * 4));
        this.show(jTextComponent, n, n2);
        this.ensureSelection();
    }

    private void ensureSelection() {
        if (this.list.getSelectedIndex() == -1 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isVisible()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 40: {
                this.setSelectNext();
                keyEvent.consume();
                break;
            }
            case 38: {
                this.setSelectPrevious();
                keyEvent.consume();
                break;
            }
            case 27: {
                this.setVisible(false);
                this.textField.requestFocus();
                keyEvent.consume();
            }
        }
        if (this.isCompletionKey(n, this.textField)) {
            File file = (File)this.list.getSelectedValue();
            if (file != null) {
                if (file.equals(this.chooser.getCurrentDirectory())) {
                    this.chooser.firePropertyChange("directoryChanged", false, true);
                } else {
                    this.chooser.setSelectedFiles(new File[]{file});
                    this.chooser.setCurrentDirectory(file);
                }
                if (file.isDirectory()) {
                    try {
                        Document document = this.textField.getDocument();
                        document.insertString(document.getLength(), File.separator, null);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Cannot append directory separator.", badLocationException);
                    }
                }
            }
            this.setVisible(false);
            this.textField.requestFocus();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean isCompletionKey(int n, JTextField jTextField) {
        if (n == 10 || n == 9) {
            return true;
        }
        return n == 39 && jTextField.getCaretPosition() >= jTextField.getDocument().getLength() - 1;
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FileCompletionPopup.this.setVisible(false);
                FileCompletionPopup.this.textField.requestFocus();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == FileCompletionPopup.this.list) {
                Point point = mouseEvent.getPoint();
                int n = FileCompletionPopup.this.list.locationToIndex(point);
                Rectangle rectangle = new Rectangle();
                FileCompletionPopup.this.list.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    FileCompletionPopup.this.list.setSelectedIndex(n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == FileCompletionPopup.this.list) {
                return;
            }
            if (FileCompletionPopup.this.isVisible()) {
                MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                FileCompletionPopup.this.list.computeVisibleRect(rectangle);
                Point point = mouseEvent2.getPoint();
                int n = FileCompletionPopup.this.list.locationToIndex(point);
                if (rectangle.contains(point)) {
                    FileCompletionPopup.this.list.setSelectedIndex(n);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = FileCompletionPopup.this.list.locationToIndex(point);
            FileCompletionPopup.this.list.setSelectedIndex(n);
            FileCompletionPopup.this.setVisible(false);
            File file = (File)FileCompletionPopup.this.list.getSelectedValue();
            if (file == null) {
                return;
            }
            if (file.equals(FileCompletionPopup.this.chooser.getCurrentDirectory())) {
                FileCompletionPopup.this.chooser.firePropertyChange("directoryChanged", false, true);
            } else {
                FileCompletionPopup.this.chooser.setCurrentDirectory(file);
            }
            FileCompletionPopup.this.textField.requestFocus();
        }

        private MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), FileCompletionPopup.this.list);
            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return mouseEvent2;
        }
    }
}

