/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.ui.commands.FrameworkCommandChooser;
import org.netbeans.modules.php.api.ui.commands.RefreshPhpModuleRunnable;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameworkCommandSupport {
    private static final Map<PhpModule, List<FrameworkCommand>> COMMANDS_CACHE = new WeakHashMap<PhpModule, List<FrameworkCommand>>();
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    protected final PhpModule phpModule;
    private PluginListener pluginListener;

    protected FrameworkCommandSupport(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public abstract String getFrameworkName();

    public abstract void runCommand(CommandDescriptor var1);

    protected abstract String getOptionsPath();

    protected abstract File getPluginsDirectory();

    protected ExternalProcessBuilder getProcessBuilder(boolean bl) {
        PhpInterpreter phpInterpreter;
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            if (bl) {
                UiUtils.invalidScriptProvided(invalidPhpProgramException.getLocalizedMessage());
            }
            return null;
        }
        assert (phpInterpreter.isValid()) : "php interpreter must be valid";
        return phpInterpreter.getProcessBuilder();
    }

    protected abstract List<FrameworkCommand> getFrameworkCommandsInternal();

    public PhpModule getPhpModule() {
        return this.phpModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrameworkCommand> getFrameworkCommands() {
        List<FrameworkCommand> list;
        Map<PhpModule, List<FrameworkCommand>> map = COMMANDS_CACHE;
        synchronized (map) {
            list = COMMANDS_CACHE.get(this.phpModule);
        }
        return list;
    }

    public ExecutionDescriptor getDescriptor() {
        return this.getDescriptor(null);
    }

    public ExecutionDescriptor getDescriptor(ExecutionDescriptor.InputProcessorFactory inputProcessorFactory) {
        ExecutionDescriptor executionDescriptor = PhpProgram.getExecutionDescriptor().postExecution((Runnable)new RefreshPhpModuleRunnable(this.phpModule)).errProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY);
        String string = this.getOptionsPath();
        if (string != null) {
            executionDescriptor = executionDescriptor.optionsPath(string);
        }
        executionDescriptor = inputProcessorFactory != null ? executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ProxyInputProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY, inputProcessorFactory)) : executionDescriptor.outProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY);
        return executionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshFrameworkCommands() {
        Object object;
        List<FrameworkCommand> list = this.getFrameworkCommandsInternal();
        File file = this.getPluginsDirectory();
        if (file != null) {
            assert (!file.isFile()) : "Plugins is expected to be a directory: " + file;
            object = this;
            synchronized (object) {
                if (this.pluginListener == null) {
                    this.pluginListener = new PluginListener();
                    FileUtil.addFileChangeListener((FileChangeListener)this.pluginListener, (File)file);
                }
            }
        }
        object = COMMANDS_CACHE;
        synchronized (object) {
            COMMANDS_CACHE.put(this.phpModule, list);
        }
    }

    public final void refreshFrameworkCommandsLater(final Runnable runnable) {
        EXECUTOR.submit(new Runnable(){

            public void run() {
                FrameworkCommandSupport.this.refreshFrameworkCommands();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public ExternalProcessBuilder createCommand(String string, String ... stringArray) {
        return this.createCommandInternal(string, stringArray, true);
    }

    public ExternalProcessBuilder createSilentCommand(String string, String ... stringArray) {
        return this.createCommandInternal(string, stringArray, false);
    }

    public String getOutputTitle(CommandDescriptor commandDescriptor) {
        return this.getOutputTitle(commandDescriptor.getFrameworkCommand().getCommand(), commandDescriptor.getCommandParams());
    }

    public String getOutputTitle(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.phpModule.getDisplayName());
        stringBuilder.append(" (");
        stringBuilder.append(string);
        for (String string2 : stringArray) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void runCommand() {
        FrameworkCommandChooser.open(this);
    }

    private ExternalProcessBuilder createCommandInternal(String string, String[] stringArray, boolean bl) {
        ExternalProcessBuilder externalProcessBuilder = this.getProcessBuilder(bl);
        if (externalProcessBuilder == null) {
            return null;
        }
        externalProcessBuilder = externalProcessBuilder.addArgument(string);
        for (String string2 : stringArray) {
            externalProcessBuilder = externalProcessBuilder.addArgument(string2);
        }
        return externalProcessBuilder;
    }

    public static final class CommandDescriptor {
        private final FrameworkCommand task;
        private final String[] params;
        private final boolean debug;

        public CommandDescriptor(FrameworkCommand frameworkCommand, String string, boolean bl) {
            Parameters.notNull((CharSequence)"task", (Object)frameworkCommand);
            Parameters.notNull((CharSequence)"params", (Object)string);
            this.task = frameworkCommand;
            this.params = Utilities.parseParameters((String)string.trim());
            this.debug = bl;
        }

        public FrameworkCommand getFrameworkCommand() {
            return this.task;
        }

        public String[] getCommandParams() {
            return this.params;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }

    private class PluginListener
    implements FileChangeListener {
        private PluginListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            this.changed();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.changed();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.changed();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed() {
            Map map = COMMANDS_CACHE;
            synchronized (map) {
                COMMANDS_CACHE.remove(FrameworkCommandSupport.this.getPhpModule());
            }
        }
    }

    public static final class ProxyInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final List<ExecutionDescriptor.InputProcessorFactory> factories;

        public ProxyInputProcessorFactory(ExecutionDescriptor.InputProcessorFactory ... inputProcessorFactoryArray) {
            Parameters.notNull((CharSequence)"proxied", (Object)inputProcessorFactoryArray);
            this.factories = new ArrayList<ExecutionDescriptor.InputProcessorFactory>(inputProcessorFactoryArray.length);
            for (ExecutionDescriptor.InputProcessorFactory inputProcessorFactory : inputProcessorFactoryArray) {
                if (inputProcessorFactory == null) continue;
                this.factories.add(inputProcessorFactory);
            }
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            InputProcessor[] inputProcessorArray = new InputProcessor[this.factories.size()];
            for (int i = 0; i < inputProcessorArray.length; ++i) {
                inputProcessorArray[i] = this.factories.get(i).newInputProcessor(inputProcessor);
            }
            return InputProcessors.proxy((InputProcessor[])inputProcessorArray);
        }
    }

    public static interface RunCommand {
        public void runCommand(CommandDescriptor var1);
    }
}

