/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.upgrade.systemoptions.ColorProcessor;
import org.netbeans.upgrade.systemoptions.CvsSettingsProcessor;
import org.netbeans.upgrade.systemoptions.DocumentationSettingsProcessor;
import org.netbeans.upgrade.systemoptions.FileProcessor;
import org.netbeans.upgrade.systemoptions.HashMapProcessor;
import org.netbeans.upgrade.systemoptions.HashSetProcessor;
import org.netbeans.upgrade.systemoptions.HostPropertyProcessor;
import org.netbeans.upgrade.systemoptions.IntrospectedInfoProcessor;
import org.netbeans.upgrade.systemoptions.ListProcessor;
import org.netbeans.upgrade.systemoptions.NbClassPathProcessor;
import org.netbeans.upgrade.systemoptions.StringPropertyProcessor;
import org.netbeans.upgrade.systemoptions.TaskTagsProcessor;
import org.netbeans.upgrade.systemoptions.URLProcessor;
import org.netbeans.upgrade.systemoptions.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PropertyProcessor {
    private String className;
    private static Map<String, String> results;
    private static Map<String, PropertyProcessor> clsname2Delegate;
    private static PropertyProcessor DEFAULT;
    private static PropertyProcessor TYPES;
    private boolean types;

    private static void registerPropertyProcessor(PropertyProcessor propertyProcessor) {
        if (clsname2Delegate.put(propertyProcessor.className, propertyProcessor) != null) {
            throw new IllegalArgumentException();
        }
    }

    private PropertyProcessor(boolean bl) {
        this.types = bl;
    }

    protected PropertyProcessor(String string) {
        this(false);
        this.className = string;
    }

    static Map<String, String> processProperty(String string, Object object, boolean bl) {
        PropertyProcessor propertyProcessor;
        results = new HashMap<String, String>();
        PropertyProcessor propertyProcessor2 = propertyProcessor = bl ? TYPES : PropertyProcessor.findDelegate(object);
        if (propertyProcessor == null) {
            propertyProcessor = DEFAULT;
        }
        assert (propertyProcessor != null);
        propertyProcessor.processPropertyImpl(string, object);
        return results;
    }

    abstract void processPropertyImpl(String var1, Object var2);

    protected final void addProperty(String string, String string2) {
        if (results.put(string, string2) != null) {
            throw new IllegalArgumentException(string);
        }
    }

    private static PropertyProcessor findDelegate(Object object) {
        String string = Utils.getClassNameFromObject(object);
        return clsname2Delegate.get(string);
    }

    static {
        clsname2Delegate = new HashMap<String, PropertyProcessor>();
        PropertyProcessor.registerPropertyProcessor(new TaskTagsProcessor());
        PropertyProcessor.registerPropertyProcessor(new HostPropertyProcessor());
        PropertyProcessor.registerPropertyProcessor(new FileProcessor());
        PropertyProcessor.registerPropertyProcessor(new NbClassPathProcessor());
        PropertyProcessor.registerPropertyProcessor(new HashMapProcessor());
        PropertyProcessor.registerPropertyProcessor(new IntrospectedInfoProcessor());
        PropertyProcessor.registerPropertyProcessor(new ListProcessor());
        PropertyProcessor.registerPropertyProcessor(new URLProcessor());
        PropertyProcessor.registerPropertyProcessor(new ColorProcessor("java.awt.Color"));
        PropertyProcessor.registerPropertyProcessor(new ColorProcessor("org.netbeans.beaninfo.editors.ColorEditor.SuperColor"));
        PropertyProcessor.registerPropertyProcessor(new StringPropertyProcessor());
        PropertyProcessor.registerPropertyProcessor(new HashSetProcessor("org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig.PersistentHashSet"));
        PropertyProcessor.registerPropertyProcessor(new HashSetProcessor("org.netbeans.modules.subversion.settings.SvnModuleConfig.PersistentHashSet"));
        PropertyProcessor.registerPropertyProcessor(new CvsSettingsProcessor());
        PropertyProcessor.registerPropertyProcessor(new DocumentationSettingsProcessor());
        DEFAULT = new PropertyProcessor(false){

            void processPropertyImpl(String string, Object object) {
                String string2 = null;
                string2 = Utils.valueFromObjectWrapper(object);
                this.addProperty(string, string2);
            }
        };
        TYPES = new PropertyProcessor(true){

            void processPropertyImpl(String string, Object object) {
                this.addProperty(string, Utils.getClassNameFromObject(object));
            }
        };
    }
}

