/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsRecognizer
extends DefaultHandler {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Session settings 1.0//EN";
    static final ErrorManager err = ErrorManager.getDefault().getInstance(SettingsRecognizer.class.getName());
    private static final String ELM_SETTING = "settings";
    private static final String ATR_SETTING_VERSION = "version";
    private static final String ELM_MODULE = "module";
    private static final String ATR_MODULE_NAME = "name";
    private static final String ATR_MODULE_SPEC = "spec";
    private static final String ATR_MODULE_IMPL = "impl";
    private static final String ELM_INSTANCE = "instance";
    private static final String ATR_INSTANCE_CLASS = "class";
    private static final String ATR_INSTANCE_METHOD = "method";
    private static final String ELM_INSTANCEOF = "instanceof";
    private static final String ATR_INSTANCEOF_CLASS = "class";
    private static final String ELM_SERIALDATA = "serialdata";
    private static final String ATR_SERIALDATA_CLASS = "class";
    private boolean header;
    private Stack<String> stack;
    private String version;
    private String instanceClass;
    private String instanceMethod;
    private Set<String> instanceOf = new HashSet<String>();
    private byte[] serialdata;
    private CharArrayWriter chaos = null;
    private String codeName;
    private String codeNameBase;
    private int codeNameRelease;
    private String moduleImpl;
    private final FileObject source;
    private static final byte[] MODULE_SETTINGS_INTRO = "<?xml version=\"1.0\"?> <!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\"> <settings version=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_INTRO_END = "> <".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_NAME = "odule name=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_SPEC = "spec=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_IMPL = "impl=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_TAG_END = "> <".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE = "nstance".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE_CLZ = "class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE_MTD = "method=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_OF = "f class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_SERIAL = "erialdata class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_END = "settings>".getBytes();

    public SettingsRecognizer(boolean bl, FileObject fileObject) {
        this.header = bl;
        this.source = fileObject;
    }

    public boolean isAllRead() {
        return !this.header;
    }

    public void setAllRead(boolean bl) {
        if (!this.header) {
            return;
        }
        this.header = bl;
    }

    public String getSettingsVerison() {
        return this.version;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String getModuleImpl() {
        return this.moduleImpl;
    }

    public Set getInstanceOf() {
        return this.instanceOf;
    }

    public String getMethodName() {
        return this.instanceMethod;
    }

    public InputStream getSerializedInstance() {
        if (this.serialdata == null) {
            return null;
        }
        return new ByteArrayInputStream(this.serialdata);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (INSTANCE_DTD_ID.equals(string)) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.header) {
            return;
        }
        String string = this.stack.peek();
        if (ELM_SERIALDATA.equals(string)) {
            if (this.chaos == null) {
                this.chaos = new CharArrayWriter(n2);
            }
            this.chaos.write(cArray, n, n2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stack.push(string3);
        if (ELM_SETTING.equals(string3)) {
            this.version = attributes.getValue(ATR_SETTING_VERSION);
        } else if (ELM_MODULE.equals(string3)) {
            this.codeName = attributes.getValue(ATR_MODULE_NAME);
            this.resolveModuleElm(this.codeName);
            this.moduleImpl = attributes.getValue(ATR_MODULE_IMPL);
            try {
                String string4 = attributes.getValue(ATR_MODULE_SPEC);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException(numberFormatException);
            }
        } else if (ELM_INSTANCEOF.equals(string3)) {
            this.instanceOf.add(Utilities.translate((String)attributes.getValue("class")));
        } else if (ELM_INSTANCE.equals(string3)) {
            this.instanceClass = attributes.getValue("class");
            if (this.instanceClass == null) {
                System.err.println("Hint: NPE is caused by broken settings file: " + this.source);
            }
            this.instanceClass = Utilities.translate((String)this.instanceClass);
            this.instanceMethod = attributes.getValue(ATR_INSTANCE_METHOD);
        } else if (ELM_SERIALDATA.equals(string3)) {
            this.instanceClass = attributes.getValue("class");
            this.instanceClass = Utilities.translate((String)this.instanceClass);
            if (this.header) {
                throw new StopSAXException();
            }
        }
    }

    private void resolveModuleElm(String string) {
        if (string != null) {
            int n = string.indexOf("/");
            if (n == -1) {
                this.codeNameBase = string;
                this.codeNameRelease = -1;
            } else {
                this.codeNameBase = string.substring(0, n);
                try {
                    this.codeNameRelease = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)numberFormatException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                    errorManager.annotate((Throwable)numberFormatException, "Source: " + this.source);
                    errorManager.notify(1, (Throwable)numberFormatException);
                    this.codeNameRelease = -1;
                }
            }
        } else {
            this.codeNameBase = null;
            this.codeNameRelease = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.stack.pop();
        if (ELM_SERIALDATA.equals(string4) && this.chaos != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.chaos.size() >> 1);
            try {
                this.chars2Bytes(byteArrayOutputStream, this.chaos.toCharArray(), 0, this.chaos.size());
                this.serialdata = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
            finally {
                this.chaos = null;
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readSerial(InputStream inputStream) throws IOException, ClassNotFoundException {
        Object object;
        if (inputStream == null) {
            return null;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            Object object2;
            object = object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                errorManager.annotate((Throwable)iOException, "Source: " + this.source);
                errorManager.annotate((Throwable)iOException, "Cannot read class: " + this.instanceClass);
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)classNotFoundException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                errorManager.annotate((Throwable)classNotFoundException, "Source: " + this.source);
                throw classNotFoundException;
            }
        }
        objectInputStream.close();
        return object;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = null;
        object = this.readSerial(this.getSerializedInstance());
        if (object == null) {
            if (this.instanceMethod != null) {
                object = this.createFromMethod(this.instanceClass, this.instanceMethod);
            } else {
                Class clazz = this.instanceClass();
                if (SharedClassObject.class.isAssignableFrom(clazz)) {
                    object = SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), (boolean)false);
                    if (null != object) {
                        try {
                            Method method = SharedClassObject.class.getDeclaredMethod("reset", new Class[0]);
                            method.setAccessible(true);
                            method.invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    } else {
                        object = SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), (boolean)true);
                    }
                } else {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)iOException, (Throwable)exception);
                        errorManager.annotate((Throwable)iOException, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        errorManager.annotate((Throwable)iOException, "Class: " + clazz);
                        errorManager.annotate((Throwable)iOException, "Source: " + this.source);
                        throw iOException;
                    }
                }
            }
        }
        return object;
    }

    private static String getFileContent(FileObject fileObject) {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream());
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer(1024);
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
    }

    private Object createFromMethod(String string, String string2) throws ClassNotFoundException, IOException {
        String string3;
        String string4;
        int n = this.instanceMethod.lastIndexOf(46);
        if (n > 0) {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        } else {
            string4 = string;
            string3 = string2;
        }
        Class clazz = this.loadClass(string4);
        try {
            Object object;
            try {
                Method method = clazz.getMethod(string3, FileObject.class);
                method.setAccessible(true);
                object = method.invoke(null, this.source);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method method = clazz.getMethod(string3, new Class[0]);
                method.setAccessible(true);
                object = method.invoke(null, new Object[0]);
            }
            if (object == null) {
                throw new IOException("Null return not permitted from " + string4 + "." + string3);
            }
            return object;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error reading " + this.source + ": " + exception);
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)iOException, "Class: " + clazz);
            errorManager.annotate((Throwable)iOException, "Method: " + string2);
            errorManager.annotate((Throwable)iOException, (Throwable)exception);
            errorManager.annotate((Throwable)iOException, "Content:\n" + SettingsRecognizer.getFileContent(this.source));
            throw iOException;
        }
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        if (this.instanceClass == null) {
            throw new ClassNotFoundException(this.source + ": missing 'class' attribute in 'instance' element");
        }
        return this.loadClass(this.instanceClass);
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(string);
    }

    public String instanceName() {
        if (this.instanceClass == null) {
            return "";
        }
        return this.instanceClass;
    }

    private int tr(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private void chars2Bytes(OutputStream outputStream, char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        block0: while (n3 < n2) {
            int n4;
            if ((n4 = this.tr(cArray[n3++])) < 0) continue;
            byte by = (byte)(n4 << 4);
            while (n3 < n2) {
                if ((n4 = this.tr(cArray[n3++])) < 0) continue;
                by = (byte)(by + (byte)n4);
                outputStream.write(by);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        Object object;
        Set<String> set;
        InputStream inputStream = null;
        try {
            if (this.header) {
                if (err.isLoggable(1) && this.source.getSize() < 12000L) {
                    set = (Set<String>)new byte[(int)this.source.getSize()];
                    object = this.source.getInputStream();
                    int n = ((InputStream)object).read((byte[])set);
                    if (n != ((Set<String>)set).length) {
                        throw new IOException("Could not read " + ((Set<String>)set).length + " bytes from " + this.source + " just " + n);
                    }
                    err.log("Parsing:" + new String((byte[])set));
                    ((InputStream)object).close();
                    inputStream = new ByteArrayInputStream((byte[])set);
                } else {
                    inputStream = new BufferedInputStream(this.source.getInputStream());
                }
                set = this.quickParse(new BufferedInputStream(inputStream));
                if (set != null) {
                    this.instanceOf = set;
                    return;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.stack = new Stack();
        try {
            inputStream = this.source.getInputStream();
            set = XMLUtil.createXMLReader();
            set.setContentHandler(this);
            set.setErrorHandler(this);
            set.setEntityResolver(this);
            set.parse(new InputSource(new BufferedInputStream(inputStream)));
        }
        catch (StopSAXException stopSAXException) {
        }
        catch (SAXException sAXException) {
            object = new IOException(this.source.toString());
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)object, (Throwable)sAXException);
            if (sAXException.getException() != null) {
                errorManager.annotate((Throwable)object, (Throwable)sAXException.getException());
            }
            errorManager.annotate((Throwable)object, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
            errorManager.annotate((Throwable)object, "Source: " + this.source);
            throw object;
        }
        finally {
            this.stack = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader reader) throws IOException {
        this.stack = new Stack();
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            xMLReader.parse(new InputSource(reader));
        }
        catch (StopSAXException stopSAXException) {
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(reader.toString());
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)iOException, (Throwable)sAXException);
            if (sAXException.getException() != null) {
                errorManager.annotate((Throwable)iOException, (Throwable)sAXException.getException());
            }
            throw iOException;
        }
        finally {
            this.stack = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Set<String> quickParse(InputStream var1_1) throws IOException {
        var2_2 = new HashSet<String>();
        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INTRO)) {
            SettingsRecognizer.err.log("Could not read intro " + this.source);
            return null;
        }
        this.version = this.readTo(var1_1, '\"');
        if (this.version == null) {
            SettingsRecognizer.err.log("Could not read version " + this.source);
            return null;
        }
        if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INTRO_END)) {
            SettingsRecognizer.err.log("Could not read stuff after cnb " + this.source);
            return null;
        }
        block6: while (true) lbl-1000:
        // 7 sources

        {
            var3_3 = var1_1.read();
            switch (var3_3) {
                case 109: {
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_NAME)) {
                        SettingsRecognizer.err.log("Could not read up to <module name=\" " + this.source);
                        return null;
                    }
                    var4_4 = this.readTo(var1_1, '\"');
                    if (var4_4 == null) {
                        SettingsRecognizer.err.log("Could not read module name value " + this.source);
                        return null;
                    }
                    var4_4 = var4_4.intern();
                    this.resolveModuleElm(var4_4);
                    var3_3 = var1_1.read();
                    if (var3_3 != 47) ** GOTO lbl30
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of module tag " + this.source);
                    return null;
lbl30:
                    // 1 sources

                    if (var3_3 != 32) {
                        SettingsRecognizer.err.log("Could not space after module name " + this.source);
                        return null;
                    }
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_SPEC)) {
                        SettingsRecognizer.err.log("Could not read up to spec=\" " + this.source);
                        return null;
                    }
                    var5_5 = this.readTo(var1_1, '\"');
                    if (var5_5 == null) {
                        SettingsRecognizer.err.log("Could not read module spec value " + this.source);
                        return null;
                    }
                    var3_3 = var1_1.read();
                    if (var3_3 != 47) ** GOTO lbl45
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of <module name spec/> tag " + this.source);
                    return null;
lbl45:
                    // 1 sources

                    if (var3_3 != 32) {
                        SettingsRecognizer.err.log("Could not read space after module name " + this.source);
                        return null;
                    }
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_MODULE_IMPL)) {
                        SettingsRecognizer.err.log("Could not read up to impl=\" " + this.source);
                        return null;
                    }
                    this.moduleImpl = this.readTo(var1_1, '\"');
                    if (this.moduleImpl == null) {
                        SettingsRecognizer.err.log("Could not read module impl value " + this.source);
                        return null;
                    }
                    this.moduleImpl = this.moduleImpl.intern();
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to /> < " + this.source);
                    return null;
                }
                case 105: {
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE)) {
                        SettingsRecognizer.err.log("Could not read up to instance " + this.source);
                        return null;
                    }
                    var3_3 = var1_1.read();
                    if (var3_3 != 111) ** GOTO lbl81
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_OF)) {
                        SettingsRecognizer.err.log("Could not read up to instance");
                        return null;
                    }
                    var6_6 = this.readTo(var1_1, '\"');
                    if (var6_6 == null) {
                        SettingsRecognizer.err.log("Could not read instanceof value " + this.source);
                        return null;
                    }
                    var6_6 = Utilities.translate((String)var6_6).intern();
                    var2_2.add(var6_6);
                    if (var1_1.read() != 47) {
                        SettingsRecognizer.err.log("No / at end of <instanceof> " + var6_6 + " " + this.source);
                        return null;
                    }
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to next tag after <instanceof> " + var6_6 + " " + this.source);
                    return null;
lbl81:
                    // 1 sources

                    if (var3_3 != 32) ** GOTO lbl113
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_CLZ)) {
                        SettingsRecognizer.err.log("Could not read up to class=\" " + this.source);
                        return null;
                    }
                    this.instanceClass = this.readTo(var1_1, '\"');
                    if (this.instanceClass == null) {
                        SettingsRecognizer.err.log("Could not read instance class value " + this.source);
                        return null;
                    }
                    this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                    var3_3 = var1_1.read();
                    if (var3_3 != 47) ** GOTO lbl95
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of instance tag " + this.source);
                    return null;
lbl95:
                    // 1 sources

                    if (var3_3 != 32) {
                        SettingsRecognizer.err.log("Could not space after instance class " + this.source);
                        return null;
                    }
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_MTD)) {
                        SettingsRecognizer.err.log("Could not read up to method=\" " + this.source);
                        return null;
                    }
                    this.instanceMethod = this.readTo(var1_1, '\"');
                    if (this.instanceMethod == null) {
                        SettingsRecognizer.err.log("Could not read method value " + this.source);
                        return null;
                    }
                    this.instanceMethod = this.instanceMethod.intern();
                    var3_3 = var1_1.read();
                    if (var3_3 == 47) {
                        if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) continue block6;
                        SettingsRecognizer.err.log("Could not read up to end of instance tag " + this.source);
                        return null;
                    }
                    SettingsRecognizer.err.log("Strange stuff after method attribute " + this.source);
                    return null;
lbl113:
                    // 1 sources

                    SettingsRecognizer.err.log("Could not read after to instance " + this.source);
                    return null;
                }
                case 115: {
                    if (!this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_SERIAL)) {
                        SettingsRecognizer.err.log("Could not read up to <serialdata class=\" " + this.source);
                        return null;
                    }
                    this.instanceClass = this.readTo(var1_1, '\"');
                    if (this.instanceClass == null) {
                        SettingsRecognizer.err.log("Could not read serialdata class value " + this.source);
                        return null;
                    }
                    this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                    var3_3 = var1_1.read();
                    if (var3_3 == 62) break block6;
                    SettingsRecognizer.err.log("Could not read up to end of serialdata tag " + this.source);
                    return null;
                }
                case 47: {
                    if (this.expect(var1_1, SettingsRecognizer.MODULE_SETTINGS_END)) break block6;
                    SettingsRecognizer.err.log("Could not read up to end of settings tag " + this.source);
                    return null;
                }
                default: {
                    SettingsRecognizer.err.log("Strange stuff after <" + (char)var3_3 + " " + this.source);
                    return null;
                }
            }
            break;
        }
        if (this.instanceClass != null && !var2_2.isEmpty()) {
            return var2_2;
        }
        return null;
    }

    private boolean expect(InputStream inputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read();
            if (n3 == 10 || n3 == 13 || n3 == 32 || n3 == 9) {
                if (bl) continue;
                bl = true;
                n3 = 32;
            } else {
                bl = false;
            }
            if (n3 == byArray[n2++]) continue;
            return false;
        }
        if (byArray[n - 1] == 10) {
            if (!inputStream.markSupported()) {
                throw new IOException("Mark not supported");
            }
            inputStream.mark(1);
            n2 = inputStream.read();
            if (n2 != -1 && n2 != 10 && n2 != 13) {
                inputStream.reset();
            }
        }
        return true;
    }

    private String readTo(InputStream inputStream, char c) throws IOException {
        if (c == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        boolean bl = false;
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n > 126) {
                return null;
            }
            if (n == 10 || n == 13) {
                if (bl) continue;
                bl = true;
                n = 10;
            } else {
                if (n < 32 && n != 9) {
                    return null;
                }
                bl = false;
            }
            if (n == c) {
                return charArrayWriter.toString();
            }
            charArrayWriter.write(n);
        }
        return null;
    }

    static final class StopSAXException
    extends SAXException {
        public StopSAXException() {
            super("Parser stopped");
        }
    }
}

