/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.actions.DebugAction;
import org.netbeans.modules.glassfish.common.actions.RefreshAction;
import org.netbeans.modules.glassfish.common.actions.RestartAction;
import org.netbeans.modules.glassfish.common.actions.StartServerAction;
import org.netbeans.modules.glassfish.common.actions.StopServerAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewMgr {
    private static final Logger LOGGER = Logger.getLogger("glassfish");
    private static final boolean strictFilter = Boolean.getBoolean("glassfish.logger.strictfilter");
    private static final int DELAY = 1000;
    private static final Map<String, WeakReference<LogViewMgr>> instances = new HashMap<String, WeakReference<LogViewMgr>>();
    private final String uri;
    private InputOutput io;
    private final List<WeakReference<LoggerRunnable>> readers = Collections.synchronizedList(new ArrayList());
    private final Locale logLocale = this.getLogLocale();
    private final String logBundleName = this.getLogBundle();
    private final String localizedWarning = this.getLocalized(Level.WARNING.getName());
    private final String localizedSevere = this.getLocalized(Level.SEVERE.getName());
    private final Map<String, String> localizedLevels = this.getLevelMap();
    private AtomicBoolean visibleCheck = new AtomicBoolean();
    private final long VISIBILITY_CHECK_DELAY = 60000L;
    private final String OUTPUT_WINDOW_TCID = "output";
    private volatile long lastVisibleCheck = 0L;
    private WeakReference<TopComponent> outputTCRef = new WeakReference<Object>(null);
    private volatile Method setClosedMethod;
    private static Pattern colorPattern = Pattern.compile("\\033\\[([\\d]{1,3})(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?(?:;([\\d]{1,3}))?m");
    private static final Color LOG_RED = new Color(204, 0, 0);
    private static final Color LOG_GREEN = new Color(0, 192, 0);
    private static final Color LOG_YELLOW = new Color(204, 204, 0);
    private static final Color LOG_BLUE = Color.BLUE;
    private static final Color LOG_MAGENTA = new Color(204, 0, 204);
    private static final Color LOG_CYAN = new Color(0, 153, 255);
    private static Color[] colorTable = new Color[]{Color.BLACK, LOG_RED, LOG_GREEN, LOG_YELLOW, LOG_BLUE, LOG_MAGENTA, LOG_CYAN};
    private static final WeakHashMap<ServerInstance, InputOutput> ioWeakMap = new WeakHashMap();

    private LogViewMgr(String string) {
        this.uri = string;
        this.io = LogViewMgr.getServerIO(string);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewMgr getInstance(String string) {
        LogViewMgr logViewMgr = null;
        Map<String, WeakReference<LogViewMgr>> map = instances;
        synchronized (map) {
            WeakReference<LogViewMgr> weakReference = instances.get(string);
            LogViewMgr logViewMgr2 = logViewMgr = weakReference != null ? (LogViewMgr)weakReference.get() : null;
            if (logViewMgr == null) {
                logViewMgr = new LogViewMgr(string);
                instances.put(string, new WeakReference<LogViewMgr>(logViewMgr));
            }
        }
        return logViewMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureActiveReader(List<Recognizer> list, File file) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            boolean bl = false;
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                bl = true;
                break;
            }
            if (!bl && file != null) {
                this.readFiles(list, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInputStreams(List<Recognizer> list, InputStream ... inputStreamArray) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (InputStream inputStream : inputStreamArray) {
                LoggerRunnable loggerRunnable = new LoggerRunnable(list, inputStream, false);
                this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                requestProcessor.post((Runnable)loggerRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFiles(List<Recognizer> list, File ... fileArray) {
        List<WeakReference<LoggerRunnable>> list2 = this.readers;
        synchronized (list2) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (File file : fileArray) {
                try {
                    LoggerRunnable loggerRunnable = new LoggerRunnable(list, new FileInputStream(file), true);
                    this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                    requestProcessor.post((Runnable)loggerRunnable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.log(Level.FINE, fileNotFoundException.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReaders() {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                loggerRunnable.stop();
            }
            this.readers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReader(LoggerRunnable loggerRunnable) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            int n = this.readers.size();
            for (int i = 0; i < n; ++i) {
                WeakReference<LoggerRunnable> weakReference = this.readers.get(i);
                if (loggerRunnable != weakReference.get()) continue;
                this.readers.remove(i);
                break;
            }
        }
    }

    public synchronized void write(String string, boolean bl) {
        OutputWriter outputWriter = this.getWriter(bl);
        if (outputWriter != null) {
            outputWriter.print(string);
        }
    }

    public synchronized void write(String string, OutputListener outputListener, boolean bl, boolean bl2) {
        try {
            OutputWriter outputWriter = this.getWriter(bl2);
            if (outputWriter != null) {
                outputWriter.println(string, outputListener, bl);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, iOException.getLocalizedMessage(), iOException);
        }
    }

    private OutputWriter getWriter(boolean bl) {
        OutputWriter outputWriter;
        OutputWriter outputWriter2 = outputWriter = bl ? this.io.getErr() : this.io.getOut();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getIOWriter: closed = " + this.io.isClosed() + " [ " + (bl ? "STDERR" : "STDOUT") + " ]" + ", output error flag = " + outputWriter.checkError());
        }
        if (outputWriter.checkError()) {
            InputOutput inputOutput = LogViewMgr.getServerIO(this.uri);
            if (inputOutput == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to recreate I/O for " + this.uri + ", still in error state");
                }
                outputWriter = null;
            } else {
                this.io = inputOutput;
                outputWriter = bl ? this.io.getErr() : this.io.getOut();
            }
        }
        return outputWriter;
    }

    private Locale getLogLocale() {
        String string = System.getProperty("user.language");
        if (string != null) {
            return new Locale(string, System.getProperty("user.country", ""), System.getProperty("user.variant", ""));
        }
        return Locale.getDefault();
    }

    private String getLogBundle() {
        return Level.INFO.getResourceBundleName();
    }

    private String getLocalized(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.logBundleName, this.logLocale);
        String string2 = resourceBundle.getString(string);
        return string2 != null ? string2 : string;
    }

    private Map<String, String> getLevelMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Level level : new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING}) {
            String string = level.getName();
            hashMap.put(string, this.getLocalized(string));
        }
        return hashMap;
    }

    private String getLocalizedLevel(String string) {
        String string2 = this.localizedLevels.get(string);
        return string2 != null ? string2 : string;
    }

    public synchronized void selectIO() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "selectIO: closed = " + this.io.isClosed() + ", output error flag = " + this.io.getOut().checkError());
        }
        if (this.io.isClosed()) {
            this.io.select();
            this.invokeSetClosed(this.io, false);
        }
        if (System.currentTimeMillis() > this.lastVisibleCheck + 60000L) {
            Mutex.EVENT.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (LogViewMgr.this.visibleCheck.getAndSet(true)) {
                        try {
                            TopComponent topComponent = null;
                            if (LogViewMgr.this.outputTCRef != null) {
                                topComponent = (TopComponent)LogViewMgr.this.outputTCRef.get();
                            }
                            if (topComponent == null && (topComponent = WindowManager.getDefault().findTopComponent("output")) != null) {
                                LogViewMgr.this.outputTCRef = new WeakReference<TopComponent>(topComponent);
                            }
                            if (topComponent != null && !topComponent.isOpened()) {
                                topComponent.open();
                            }
                            LogViewMgr.this.lastVisibleCheck = System.currentTimeMillis();
                        }
                        finally {
                            LogViewMgr.this.visibleCheck.set(false);
                        }
                    }
                }
            });
        }
    }

    private void invokeSetClosed(InputOutput inputOutput, boolean bl) {
        block4: {
            if (this.setClosedMethod == null) {
                this.setClosedMethod = this.initSetClosedMethod(inputOutput);
            }
            if (this.setClosedMethod != null) {
                try {
                    this.setClosedMethod.invoke((Object)inputOutput, bl);
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block4;
                    LOGGER.log(Level.FINER, "invokeSetClosed", exception);
                }
            }
        }
    }

    private Method initSetClosedMethod(InputOutput inputOutput) {
        Method method;
        block2: {
            method = null;
            try {
                Class<?> clazz = inputOutput.getClass();
                method = clazz.getDeclaredMethod("setClosed", Boolean.TYPE);
                method.setAccessible(true);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINER)) break block2;
                LOGGER.log(Level.FINER, "initSetClosedMethod", exception);
            }
        }
        return method;
    }

    private boolean filter(String string) {
        return string.startsWith("INFO: Started bundle ") || string.startsWith("INFO: Stopped bundle ") || string.startsWith("INFO: ### ") || string.startsWith("felix.") || string.startsWith("log4j:");
    }

    private static final String stripNewline(String string) {
        int n = string.length();
        if (n > 0 && '\n' == string.charAt(n - 1)) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private boolean isWarning(String string) {
        return string.startsWith(this.localizedWarning) || string.startsWith(this.localizedSevere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getServerIO(String string) {
        Object object;
        Object object2;
        ServerInstance serverInstance = null;
        Iterator<GlassfishInstanceProvider> iterator = GlassfishInstanceProvider.getProviders(true).iterator();
        while (serverInstance == null && iterator.hasNext()) {
            object2 = iterator.next();
            serverInstance = ((GlassfishInstanceProvider)object2).getInstance(string);
        }
        if (null == serverInstance) {
            return null;
        }
        object2 = ioWeakMap;
        synchronized (object2) {
            object = ioWeakMap.get(serverInstance);
            if (object != null) {
                boolean bl = true;
                if (object.isClosed() && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Output window for " + string + " is closed.");
                }
                if (object.getOut().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Standard out for " + string + " is in error state.");
                    }
                    bl = false;
                }
                if (object.getErr().checkError()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Standard error for " + string + " is in error state.");
                    }
                    bl = false;
                }
                if (bl) {
                    return object;
                }
                if (!object.isClosed()) {
                    object.closeInputOutput();
                }
                ioWeakMap.put(serverInstance, null);
            }
        }
        object2 = serverInstance.getFullNode();
        if (object2 == null) {
            return null;
        }
        object = (GlassfishModule)object2.getLookup().lookup(GlassfishModule.class);
        if (object == null) {
            return null;
        }
        Action[] actionArray = new Action[]{new StartServerAction.OutputAction((GlassfishModule)object), new DebugAction.OutputAction((GlassfishModule)object), new RestartAction.OutputAction((GlassfishModule)object), new StopServerAction.OutputAction((GlassfishModule)object), new RefreshAction.OutputAction((GlassfishModule)object)};
        InputOutput inputOutput = null;
        WeakHashMap<ServerInstance, InputOutput> weakHashMap = ioWeakMap;
        synchronized (weakHashMap) {
            inputOutput = ioWeakMap.get(serverInstance);
            if (inputOutput == null) {
                inputOutput = IOProvider.getDefault().getIO(serverInstance.getDisplayName(), actionArray);
                ioWeakMap.put(serverInstance, inputOutput);
            }
        }
        return inputOutput;
    }

    private static interface Filter {
        public String process(char var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogFileFilter
    extends StateFilter {
        private String time;
        private String type;
        private String version;
        private String classinfo;
        private String threadinfo;
        private boolean multiline;
        private final Map<String, String> typeMap;

        public LogFileFilter(Map<String, String> map) {
            this.typeMap = map;
            this.reset();
        }

        @Override
        protected void reset() {
            super.reset();
            this.threadinfo = "";
            this.classinfo = "";
            this.version = "";
            this.type = "";
            this.time = "";
            this.multiline = false;
        }

        private String getLocalizedType(String string) {
            String string2 = this.typeMap.get(string);
            return string2 != null ? string2 : string;
        }

        @Override
        public String process(char c) {
            String string = null;
            switch (this.state) {
                case 0: {
                    if (c == '[') {
                        this.state = 1;
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 1: {
                    if (c == '#') {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append('[');
                    this.msg.append(c);
                    break;
                }
                case 2: {
                    if (c == '|') {
                        this.state = 3;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append(c);
                        string = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.state = 0;
                    this.msg.append('[');
                    this.msg.append('#');
                    this.msg.append(c);
                    break;
                }
                case 3: {
                    if (c == '|') {
                        this.state = 4;
                        this.time = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 4: {
                    if (c == '|') {
                        this.state = 5;
                        this.type = this.getLocalizedType(this.msg.toString());
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 5: {
                    if (c == '|') {
                        this.state = 6;
                        this.version = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 6: {
                    if (c == '|') {
                        this.state = 7;
                        this.classinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 7: {
                    if (c == '|') {
                        this.state = 8;
                        this.threadinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 8: {
                    if (c == '|') {
                        this.state = 9;
                        this.message = this.msg.toString();
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        this.msg.append('\n');
                        string = !this.multiline ? this.type + ": " + this.msg.toString() : this.msg.toString();
                        this.multiline = true;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 9: {
                    if (c == '#') {
                        this.state = 10;
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append(c);
                    break;
                }
                case 10: {
                    if (c == ']') {
                        this.state = 0;
                        this.msg.setLength(0);
                        string = (this.multiline ? this.message : this.type + ": " + this.message) + '\n';
                        this.reset();
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append('#');
                    this.msg.append(c);
                }
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoggerRunnable
    implements Runnable {
        private final List<Recognizer> recognizers;
        private final InputStream inputStream;
        private final boolean ignoreEof;
        private volatile boolean shutdown;

        public LoggerRunnable(List<Recognizer> list, InputStream inputStream, boolean bl) {
            this.recognizers = list;
            this.inputStream = inputStream;
            this.ignoreEof = bl;
            this.shutdown = false;
        }

        public void stop() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            BufferedReader bufferedReader = null;
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + this.inputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                LogFileFilter logFileFilter = this.ignoreEof ? new LogFileFilter(LogViewMgr.this.localizedLevels) : (LogViewMgr.this.uri.contains("]deployer:gfv3ee6:") ? new LogFileFilter(LogViewMgr.this.localizedLevels) : new StreamFilter());
                char[] cArray = new char[1024];
                int n = 0;
                while (!this.shutdown && n != -1) {
                    if (this.ignoreEof) {
                        while (!this.shutdown && bufferedReader.ready()) {
                            String string2 = logFileFilter.process((char)bufferedReader.read());
                            if (string2 == null) continue;
                            this.processLine(string2);
                        }
                    } else {
                        while (!this.shutdown && (n = bufferedReader.read(cArray)) != -1) {
                            for (int i = 0; i < n; ++i) {
                                String string3 = logFileFilter.process(cArray[i]);
                                if (string3 == null) continue;
                                this.processLine(string3);
                            }
                            if (bufferedReader.ready()) continue;
                        }
                    }
                    try {
                        if (this.ignoreEof) {
                            LogViewMgr.this.io.getErr().close();
                            LogViewMgr.this.io.getOut().close();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "I/O exception reading server log", iOException);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "I/O exception closing server log", iOException);
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, "I/O exception closing stream buffer", iOException);
                    }
                }
                LogViewMgr.this.removeReader(this);
                Thread.currentThread().setName(string);
            }
            LogViewMgr.this.io.getErr().close();
            LogViewMgr.this.io.getOut().close();
        }

        private void processLine(String string) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "processing text: '" + string + "'");
            }
            if (strictFilter && LogViewMgr.this.filter(string)) {
                return;
            }
            Message message = new Message(string);
            message.process(this.recognizers);
            message.print();
            LogViewMgr.this.selectIO();
            if (this.shutdown) {
                LogViewMgr.this.io.getErr().close();
                LogViewMgr.this.io.getOut().close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Message {
        private String message;
        private int level;
        private Color color;
        private OutputListener listener;

        public Message(String string) {
            this.message = string;
        }

        void process(List<Recognizer> list) {
            this.processLevel();
            this.processColors();
            this.processRecognizers(list);
        }

        private void processLevel() {
            this.level = 0;
            int n = this.message.substring(0, Math.min(this.message.length(), 15)).indexOf(58);
            if (n != -1) {
                try {
                    String string = this.message.substring(0, n);
                    this.level = Level.parse(string).intValue();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private void processColors() {
            try {
                Matcher matcher = colorPattern.matcher(this.message);
                boolean bl = matcher.find();
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(this.message.length());
                    do {
                        int n = matcher.groupCount();
                        for (int i = 1; i < n && matcher.group(i) != null; ++i) {
                            int n2 = Integer.parseInt(matcher.group(i));
                            if (n2 < 30 || n2 > 36 || this.color != null) continue;
                            this.color = colorTable[n2 - 30];
                        }
                        matcher.appendReplacement(stringBuffer, "");
                    } while (bl = matcher.find());
                    matcher.appendTail(stringBuffer);
                    this.message = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
            if (this.color == null && this.level > 0) {
                if (this.level <= Level.FINE.intValue()) {
                    this.color = LOG_GREEN;
                } else if (this.level <= Level.INFO.intValue()) {
                    this.color = Color.GRAY;
                }
            }
        }

        private void processRecognizers(List<Recognizer> list) {
            if (this.message.length() > 500) {
                return;
            }
            Iterator<Recognizer> iterator = list.iterator();
            while (iterator.hasNext() && this.listener == null) {
                this.listener = iterator.next().processLine(this.message);
            }
        }

        void print() {
            OutputWriter outputWriter = LogViewMgr.this.getWriter(this.level >= 900);
            try {
                if (this.color != null && this.listener == null && IOColorLines.isSupported((InputOutput)LogViewMgr.this.io)) {
                    this.message = LogViewMgr.stripNewline(this.message);
                    IOColorLines.println((InputOutput)LogViewMgr.this.io, (CharSequence)this.message, (Color)this.color);
                } else if (outputWriter != null) {
                    if (this.listener != null) {
                        this.message = LogViewMgr.stripNewline(this.message);
                        outputWriter.println(this.message, this.listener, false);
                    } else {
                        outputWriter.print(this.message);
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    private static abstract class StateFilter
    implements Filter {
        protected String message;
        protected int state = 0;
        protected StringBuilder msg = new StringBuilder(128);

        StateFilter() {
        }

        protected void reset() {
            this.message = "";
        }

        public abstract String process(char var1);
    }

    private static final class StreamFilter
    extends StateFilter {
        private static final Pattern messagePattern = Pattern.compile("([\\p{Lu}]{0,16}?):|([^\\r\\n]{0,24}?\\d\\d?:\\d\\d?:\\d\\d?)");
        private String line;

        public StreamFilter() {
            this.reset();
        }

        protected void reset() {
            super.reset();
            this.line = "";
        }

        public String process(char c) {
            String string = null;
            if (c == '\n') {
                if (this.msg.length() > 0) {
                    this.msg.append(c);
                    this.line = this.msg.toString();
                    this.msg.setLength(0);
                    Matcher matcher = messagePattern.matcher(this.line);
                    string = matcher.find() && matcher.start() == 0 && matcher.groupCount() > 1 && matcher.group(2) != null ? null : this.line;
                }
            } else if (c != '\r') {
                this.msg.append(c);
            }
            return string;
        }
    }
}

