/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.Retriever;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddDomainLocationPanel locationPanel2 = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String domainsDir;
    private String domainName;
    private GlassfishInstanceProvider gip;
    private transient String[] steps = null;
    private int httpPort = -1;
    private int httpsPort = 8181;
    private int adminPort = 4848;
    private String installRoot;
    private String glassfishRoot;
    private String hostName;

    public ServerWizardIterator(GlassfishInstanceProvider glassfishInstanceProvider) {
        assert (null != glassfishInstanceProvider);
        this.gip = glassfishInstanceProvider;
        this.setHostName("localhost");
    }

    private ServerWizardIterator() {
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return this.gip.getDisplayName() + " AddInstanceIterator";
    }

    public static void showInformation(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public Set instantiate() throws IOException {
        File file;
        HashSet<ServerInstance> hashSet = new HashSet<ServerInstance>();
        File file2 = new File(this.installRoot);
        this.ensureExecutable(file2);
        if (null != this.domainsDir) {
            this.handleLocalDomains(hashSet, file2);
        } else {
            this.handleRemoteDomains(hashSet, file2);
        }
        RegisteredDerbyServer registeredDerbyServer = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
        if (null != registeredDerbyServer && (file = new File(file2, "javadb")).exists() && file.isDirectory() && file.canRead()) {
            registeredDerbyServer.initialize(file.getAbsolutePath());
        }
        NbPreferences.forModule(this.getClass()).put(this.gip.getInstallRootKey(), this.installRoot);
        return hashSet;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_Domain")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.locationPanel2 == null) {
            this.locationPanel2 = new AddDomainLocationPanel(this);
            this.locationPanel2.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.locationPanel2};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.getPanels()[this.index];
        JComponent jComponent = (JComponent)panel.getComponent();
        jComponent.putClientProperty("WizardPanel_contentData", this.getSteps());
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.getIndex()));
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    protected final void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public String formatUri(String string, String string2, int n) {
        return this.gip.formatUri(string, string2, n);
    }

    String getDefaultInstallDirectoryName() {
        return this.gip.getDefaultInstallName();
    }

    int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int n) {
        this.httpPort = n;
    }

    int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int n) {
        this.adminPort = n;
    }

    public void setHttpsPort(int n) {
        this.httpsPort = n;
    }

    public void setInstallRoot(String string) {
        this.installRoot = string;
    }

    String getGlassfishRoot() {
        return this.glassfishRoot;
    }

    public void setGlassfishRoot(String string) {
        this.glassfishRoot = string;
    }

    String getInstallRootProperty() {
        return this.gip.getInstallRootProperty();
    }

    String getNameOfBits() {
        return this.gip.getDisplayName();
    }

    boolean hasServer(String string) {
        return this.gip.hasServer(string);
    }

    boolean isValidInstall(File file, File file2, WizardDescriptor wizardDescriptor) {
        String string = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)FileUtil.normalizeFile((File)file).getPath());
        if (this.gip.getDefaultInstallName().equals(GlassfishInstanceProvider.PRELUDE_DEFAULT_NAME)) {
            string = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_PreludeInstallationInvalid", (Object)FileUtil.normalizeFile((File)file).getPath());
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        File file3 = ServerUtilities.getJarName(file2.getAbsolutePath(), "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (file3 == null || !file3.exists()) {
            return false;
        }
        File file4 = new File(file2, "config" + File.separator + "glassfish.container");
        if (!file4.exists()) {
            return false;
        }
        for (String string2 : this.gip.getRequiredFiles()) {
            file4 = new File(file2, string2);
            if (file4.exists()) continue;
            return false;
        }
        for (String string2 : this.gip.getExcludedFiles()) {
            file4 = new File(file2, string2);
            if (!file4.exists()) continue;
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"   ");
        return true;
    }

    public void setDomainLocation(String string) {
        if (null == string) {
            this.domainsDir = null;
            this.domainName = null;
        } else {
            int n = string.lastIndexOf(File.separator);
            this.domainsDir = string.substring(0, n);
            this.domainName = string.substring(n + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureExecutable(File file) {
        Object object2;
        void file2;
        if (Utilities.isWindows()) {
            return;
        }
        if (!Utils.canWrite(file)) {
            return;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Object object3 = new String[]{"bin", "glassfish/bin", "javadb/bin", "javadb/frameworks/NetworkServer/bin", "javadb/frameworks/embedded/bin"};
        int n = ((String[])object3).length;
        boolean bl = false;
        while (file2 < n) {
            String string = object3[file2];
            object2 = new File(file, string);
            if (object2.exists()) {
                arrayList.add((String[])object2);
            }
            ++file2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        object3 = new File("/bin/chmod");
        if (!((File)object3).isFile()) {
            object3 = new File("/usr/bin/chmod");
        }
        if (((File)object3).isFile()) {
            try {
                for (File stringBuilder : arrayList) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(((File)object3).getAbsolutePath());
                    arrayList2.add("u+rx");
                    object2 = stringBuilder.list();
                    for (String string : object2) {
                        if (string.indexOf(46) != -1 && !string.endsWith(".ksh")) continue;
                        arrayList2.add(string);
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(arrayList2);
                    processBuilder.directory(stringBuilder);
                    Process process = processBuilder.start();
                    int n2 = process.waitFor();
                    if (n2 == 0) continue;
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodFailed", arrayList2, (Object)n2));
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
        } else {
            String string = NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodNotFound");
            StringBuilder stringBuilder = new StringBuilder(string.length() + 50 * arrayList.size());
            stringBuilder.append(string);
            for (Object object2 : arrayList) {
                stringBuilder.append('\n');
                stringBuilder.append(object2);
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)stringBuilder.toString(), 2));
        }
    }

    String getIndirect() {
        return this.gip.getIndirectDownloadUrl();
    }

    String getDirect() {
        return this.gip.getDirectDownloadUrl();
    }

    String getInstallRootKey() {
        return this.gip.getInstallRootKey();
    }

    private void handleLocalDomains(Set<ServerInstance> set, File file) {
        File file2 = new File(this.domainsDir, this.domainName);
        String string = null;
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish").log(Level.INFO, file2.getAbsolutePath(), iOException);
        }
        if (null != string && !string.equals(file2.getAbsolutePath())) {
            this.setDomainLocation(string);
            file2 = new File(this.domainsDir, this.domainName);
        }
        if (!file2.exists() && AddServerLocationPanel.canCreate(file2)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("installfolder", this.installRoot);
            hashMap.put("homefolder", this.glassfishRoot);
            hashMap.put("displayName", (String)this.wizard.getProperty("ServInstWizard_displayName"));
            hashMap.put("domainsfolder", this.domainsDir);
            hashMap.put("domainname", this.domainName);
            CreateDomain createDomain = new CreateDomain("anonymous", "", new File(this.glassfishRoot), hashMap, this.gip, false);
            int n = createDomain.getHttpPort();
            int n2 = createDomain.getAdminPort();
            createDomain.start();
            GlassfishInstance glassfishInstance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, this.domainsDir, this.domainName, n, n2, this.formatUri(this.glassfishRoot, "localhost", n2), this.gip.getUriFragment(), this.gip);
            set.add(glassfishInstance.getCommonInstance());
        } else {
            GlassfishInstance glassfishInstance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, this.domainsDir, this.domainName, this.httpPort, this.adminPort, this.formatUri(this.glassfishRoot, "localhost", this.adminPort), this.gip.getUriFragment(), this.gip);
            set.add(glassfishInstance.getCommonInstance());
        }
    }

    private void handleRemoteDomains(Set<ServerInstance> set, File file) {
        this.httpPort = 8080;
        String string = this.getHostName();
        if ("localhost".equals(string)) {
            string = "127.0.0.1";
        }
        GlassfishInstance glassfishInstance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, null, null, this.httpPort, this.adminPort, this.formatUri(this.glassfishRoot, string, this.adminPort), this.gip.getUriFragment(), this.gip);
        set.add(glassfishInstance.getCommonInstance());
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }
}

