/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerCommand {
    public static final char QUERY_SEPARATOR = '?';
    public static final char PARAM_SEPARATOR = '&';
    protected final String command;
    protected String query = null;
    protected boolean retry = false;

    public ServerCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRequestMethod() {
        return "GET";
    }

    public boolean getDoOutput() {
        return false;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public String getInputName() {
        return null;
    }

    public String getLastModified() {
        return null;
    }

    public boolean retry() {
        return this.retry;
    }

    public boolean handleResponse(int n) {
        return n == 200;
    }

    public boolean readResponse(InputStream inputStream) throws IOException {
        boolean bl = false;
        Manifest manifest = new Manifest();
        manifest.read(inputStream);
        String string = manifest.getMainAttributes().getValue("exit-code");
        if (string.equalsIgnoreCase("Success")) {
            this.readManifest(manifest);
            bl = true;
        } else {
            String string2 = manifest.getMainAttributes().getValue("message");
            if (string2 != null && string2.contains("please wait")) {
                this.retry = true;
            }
            Logger.getLogger("glassfish").log(Level.WARNING, string2);
        }
        return bl;
    }

    public void readManifest(Manifest manifest) throws IOException {
    }

    public boolean processResponse() {
        return true;
    }

    public String toString() {
        return this.query == null ? this.command : this.command + '?' + this.query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetPropertyCommand
    extends ServerCommand {
        private Manifest info;
        private Map<String, String> propertyMap;

        public GetPropertyCommand(String string) {
            super("get");
            this.query = "pattern=" + string;
            this.propertyMap = new HashMap<String, String>();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            for (String string : this.info.getEntries().keySet()) {
                int n = string.indexOf(61);
                if (n >= 0) {
                    try {
                        this.propertyMap.put(string.substring(0, n), URLDecoder.decode(URLDecoder.decode(string.substring(n + 1), "UTF-8"), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                this.propertyMap.put(string, "");
            }
            return true;
        }

        public Map<String, String> getData() {
            return this.propertyMap;
        }
    }

    public static final class SetPropertyCommand
    extends ServerCommand {
        private Manifest info;

        public SetPropertyCommand(String string, String string2, String string3) {
            super("set");
            this.query = MessageFormat.format(string3, string, string2);
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            return this.info != null;
        }
    }
}

