/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.logging.Level;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.CharSubSequence;
import org.netbeans.lib.lexer.TokenList;

public abstract class PreprocessedTextStorage
implements CharSequence {
    private final CharSequence rawText;
    private final char[] preprocessedChars;
    private final int preprocessedStartIndex;
    private final int totalRawLengthShift;
    private final int length;

    public static PreprocessedTextStorage create(CharSequence charSequence, char[] cArray, int n, int n2, int[] nArray) {
        PreprocessedTextStorage preprocessedTextStorage;
        char[] cArray2 = ArrayUtilities.charArray((char[])cArray, (int)n);
        int n3 = nArray[n - 1];
        if (n3 <= 127) {
            byte[] byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)nArray[i];
            }
            preprocessedTextStorage = new ByteRawIndex(charSequence, cArray2, n2, n, n3, byArray);
        } else if (n3 <= Short.MAX_VALUE) {
            short[] sArray = new short[n];
            for (int i = n - 1; i >= 0; --i) {
                sArray[i] = (short)nArray[i];
            }
            preprocessedTextStorage = new ShortRawIndex(charSequence, cArray2, n2, n, n3, sArray);
        } else {
            int[] nArray2 = new int[n];
            System.arraycopy(cArray, 0, nArray2, 0, n);
            preprocessedTextStorage = new IntRawIndex(charSequence, cArray2, n2, n, n3, nArray2);
        }
        if (TokenList.LOG.isLoggable(Level.FINE)) {
            super.consistencyCheck();
        }
        return preprocessedTextStorage;
    }

    public static PreprocessedTextStorage create(CharSequence charSequence, char[] cArray, int n, int n2, int[] nArray, char[] cArray2, int[] nArray2, int n3, int n4) {
        PreprocessedTextStorage preprocessedTextStorage;
        int n5 = cArray2.length - n3;
        n2 -= n5;
        int n6 = n5 + n + n4;
        char[] cArray3 = new char[n6];
        System.arraycopy(cArray2, n3, cArray3, 0, n5);
        System.arraycopy(cArray, 0, cArray3, n5, n);
        System.arraycopy(cArray2, 0, cArray3, n5 + n, n4);
        int n7 = n4 > 0 ? nArray2[n4 - 1] : (n > 0 ? nArray[n - 1] : nArray2[cArray2.length - 1]);
        int n8 = n6 - 1;
        if (n7 <= 127) {
            int n9;
            byte[] byArray = new byte[n6];
            for (n9 = n4 - 1; n9 >= 0; --n9) {
                byArray[n8--] = (byte)nArray2[n9];
            }
            for (n9 = n - 1; n9 >= 0; --n9) {
                byArray[n8--] = (byte)nArray[n9];
            }
            for (n9 = cArray2.length - 1; n9 >= n3; --n9) {
                byArray[n8--] = (byte)nArray2[n9];
            }
            preprocessedTextStorage = new ByteRawIndex(charSequence, cArray3, n2, n6, n7, byArray);
        } else if (n7 <= Short.MAX_VALUE) {
            int n10;
            short[] sArray = new short[n6];
            for (n10 = n4 - 1; n10 >= 0; --n10) {
                sArray[n8--] = (short)nArray2[n10];
            }
            for (n10 = n - 1; n10 >= 0; --n10) {
                sArray[n8--] = (short)nArray[n10];
            }
            for (n10 = cArray2.length - 1; n10 >= n3; --n10) {
                sArray[n8--] = (short)nArray2[n10];
            }
            preprocessedTextStorage = new ShortRawIndex(charSequence, cArray3, n2, n6, n7, sArray);
        } else {
            int n11;
            int[] nArray3 = new int[n6];
            for (n11 = n4 - 1; n11 >= 0; --n11) {
                nArray3[n8--] = nArray2[n11];
            }
            for (n11 = n - 1; n11 >= 0; --n11) {
                nArray3[n8--] = nArray[n11];
            }
            for (n11 = cArray2.length - 1; n11 >= n3; --n11) {
                nArray3[n8--] = nArray2[n11];
            }
            preprocessedTextStorage = new IntRawIndex(charSequence, cArray3, n2, n6, n7, nArray3);
        }
        if (TokenList.LOG.isLoggable(Level.FINE)) {
            super.consistencyCheck();
        }
        return preprocessedTextStorage;
    }

    protected PreprocessedTextStorage(CharSequence charSequence, char[] cArray, int n, int n2, int n3) {
        this.rawText = charSequence;
        this.preprocessedChars = cArray;
        this.preprocessedStartIndex = n;
        this.totalRawLengthShift = n3;
        this.length = n2;
    }

    protected abstract int prepRawLengthShift(int var1);

    public final int rawLength(int n) {
        if (n > this.preprocessedStartIndex) {
            int n2 = n - this.preprocessedStartIndex;
            n = n2 <= this.preprocessedChars.length ? (n += this.prepRawLengthShift(n2 - 1)) : (n += this.totalRawLengthShift);
        }
        return n;
    }

    public final int rawLengthShift(int n) {
        if (n < this.preprocessedStartIndex) {
            return n;
        }
        if ((n -= this.preprocessedStartIndex) <= this.preprocessedChars.length) {
            return this.prepRawLengthShift(n);
        }
        return this.totalRawLengthShift;
    }

    public final char charAt(int n) {
        CharSequenceUtilities.checkIndexValid((int)n, (int)this.length);
        if (n < this.preprocessedStartIndex) {
            return this.rawText.charAt(n);
        }
        int n2 = n - this.preprocessedStartIndex;
        if (n2 < this.preprocessedChars.length) {
            return this.preprocessedChars[n2];
        }
        return this.rawText.charAt(n + this.totalRawLengthShift);
    }

    public final CharSequence subSequence(int n, int n2) {
        return new CharSubSequence((CharSequence)this, n, n2);
    }

    public final int length() {
        return this.length;
    }

    private void consistencyCheck() {
        int n = 0;
        for (int i = 0; i < this.preprocessedChars.length; ++i) {
            int n2 = this.prepRawLengthShift(i);
            if (n2 < n) {
                throw new IllegalStateException("rls=" + n2 + " < lastRLS=" + n + " at index=" + i);
            }
            n = n2;
        }
    }

    private static final class ByteRawIndex
    extends PreprocessedTextStorage {
        private final byte[] preprocessedRawLengthShifts;

        ByteRawIndex(CharSequence charSequence, char[] cArray, int n, int n2, int n3, byte[] byArray) {
            super(charSequence, cArray, n, n2, n3);
            this.preprocessedRawLengthShifts = byArray;
        }

        protected final int prepRawLengthShift(int n) {
            return this.preprocessedRawLengthShifts[n];
        }
    }

    private static final class IntRawIndex
    extends PreprocessedTextStorage {
        private final int[] preprocessedRawLengthShifts;

        IntRawIndex(CharSequence charSequence, char[] cArray, int n, int n2, int n3, int[] nArray) {
            super(charSequence, cArray, n, n2, n3);
            this.preprocessedRawLengthShifts = nArray;
        }

        protected final int prepRawLengthShift(int n) {
            return this.preprocessedRawLengthShifts[n];
        }
    }

    private static final class ShortRawIndex
    extends PreprocessedTextStorage {
        private final short[] preprocessedRawLengthShifts;

        ShortRawIndex(CharSequence charSequence, char[] cArray, int n, int n2, int n3, short[] sArray) {
            super(charSequence, cArray, n, n2, n3);
            this.preprocessedRawLengthShifts = sArray;
        }

        protected final int prepRawLengthShift(int n) {
            return this.preprocessedRawLengthShifts[n];
        }
    }
}

