/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinLexerInputOperation;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableJoinTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListListUpdate;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JoinTokenListChange<T extends TokenId>
extends TokenListChange<T> {
    EmbeddedTokenList<T> charModTokenList;
    private TokenListListUpdate<T> tokenListListUpdate;
    private int relexTokenListIndex;
    private List<RelexTokenListChange<T>> relexChanges;
    private RelexTokenListChange<T> lastRelexChange;
    private JoinLexerInputOperation<T> joinLexerInputOperation;

    public JoinTokenListChange(MutableJoinTokenList<T> mutableJoinTokenList) {
        super(mutableJoinTokenList);
    }

    public List<? extends TokenListChange<T>> relexChanges() {
        return this.relexChanges;
    }

    public TokenListListUpdate<T> tokenListListUpdate() {
        return this.tokenListListUpdate;
    }

    public void setTokenListListUpdate(TokenListListUpdate<T> tokenListListUpdate) {
        this.tokenListListUpdate = tokenListListUpdate;
    }

    public void setStartInfo(JoinLexerInputOperation<T> joinLexerInputOperation, int n) {
        this.joinLexerInputOperation = joinLexerInputOperation;
        this.relexTokenListIndex = joinLexerInputOperation.activeTokenListIndex();
        this.relexChanges = new ArrayList<RelexTokenListChange<T>>(this.tokenListListUpdate.addedTokenListCount() + 3);
        this.lastRelexChange = new RelexTokenListChange<T>(joinLexerInputOperation.tokenList(this.relexTokenListIndex));
        this.lastRelexChange.setIndex(n);
        int n2 = joinLexerInputOperation.lastTokenEndOffset();
        this.lastRelexChange.setOffset(n2);
        this.lastRelexChange.setMatchOffset(n2);
        this.lastRelexChange.setParentChangeIsBoundsChange(this.parentChangeIsBoundsChange);
        this.relexChanges.add(this.lastRelexChange);
    }

    public void setNoRelexStartInfo() {
        this.relexTokenListIndex = this.tokenListListUpdate.modTokenListIndex;
        this.relexChanges = new ArrayList<RelexTokenListChange<T>>(1);
    }

    @Override
    public void addToken(AbstractToken<T> abstractToken, int n, Object object) {
        int n2 = this.joinLexerInputOperation.skipTokenListCount();
        if (n2 > 0) {
            while (--n2 >= 0) {
                this.lastRelexChange.finish();
                this.addRelexChange();
            }
            this.joinLexerInputOperation.clearSkipTokenListCount();
        }
        if (abstractToken.getClass() == JoinToken.class) {
            JoinToken joinToken = (JoinToken)abstractToken;
            List list = joinToken.joinedParts();
            int n3 = joinToken.extraTokenListSpanCount();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                this.lastRelexChange.joinTokenLastPartShift = n3 - i;
                if (((EmbeddedTokenList)this.lastRelexChange.tokenList()).textLength() > 0) {
                    PartToken partToken = list.get(n4++);
                    this.lastRelexChange.addToken(partToken, 0, null);
                }
                this.addRelexChange();
            }
            abstractToken = list.get(n4);
        }
        this.lastRelexChange.addToken(abstractToken, n, object);
        this.addedEndOffset = this.lastRelexChange.addedEndOffset;
        this.tokenChangeInfo().updateAddedTokenCount(1);
    }

    private void addRelexChange() {
        EmbeddedTokenList<T> embeddedTokenList = this.joinLexerInputOperation.tokenList(this.relexTokenListIndex + this.relexChanges.size());
        this.lastRelexChange = new RelexTokenListChange<T>(embeddedTokenList);
        int n = embeddedTokenList.startOffset();
        this.lastRelexChange.setOffset(n);
        this.lastRelexChange.setParentChangeIsBoundsChange(this.parentChangeIsBoundsChange);
        this.relexChanges.add(this.lastRelexChange);
    }

    @Override
    public int increaseMatchIndex() {
        EmbeddedTokenList embeddedTokenList;
        MutableJoinTokenList mutableJoinTokenList = (MutableJoinTokenList)this.tokenList();
        AbstractToken abstractToken = mutableJoinTokenList.tokenOrEmbeddingUnsync(this.matchIndex).token();
        this.matchOffset = abstractToken.getClass() == JoinToken.class ? ((JoinToken)abstractToken).endOffset() : (this.matchIndex == mutableJoinTokenList.activeStartJoinIndex() ? ((embeddedTokenList = mutableJoinTokenList.activeTokenList()) != this.charModTokenList ? embeddedTokenList.startOffset() + abstractToken.length() : (this.matchOffset += abstractToken.length())) : (this.matchOffset += abstractToken.length()));
        ++this.matchIndex;
        return this.matchOffset;
    }

    @Override
    public AbstractToken<T> removeLastAddedToken() {
        AbstractToken abstractToken = this.lastRelexChange.removeLastAddedToken();
        if (abstractToken.getClass() == PartToken.class) {
            int n = ((JoinToken)((PartToken)abstractToken).joinToken()).extraTokenListSpanCount();
            for (int i = n - 1; i >= 0; --i) {
                this.relexChanges.remove(this.relexChanges.size() - 1);
            }
            this.lastRelexChange = this.relexChanges.get(this.relexChanges.size() - 1);
            abstractToken = this.lastRelexChange.removeLastAddedToken();
        }
        if (this.lastRelexChange.addedTokenOrEmbeddings().size() == 0) {
            this.relexChanges.remove(this.relexChanges.size() - 1);
        }
        this.addedEndOffset = this.lastRelexChange.addedEndOffset;
        this.tokenChangeInfo().updateAddedTokenCount(-1);
        return abstractToken;
    }

    void replaceTokenLists() {
        MutableJoinTokenList mutableJoinTokenList = (MutableJoinTokenList)this.tokenList();
        mutableJoinTokenList.moveIndexGap(this.tokenListListUpdate.modTokenListIndex + this.tokenListListUpdate.removedTokenListCount);
        this.tokenListListUpdate.replaceTokenLists(mutableJoinTokenList.tokenListStartIndex());
        mutableJoinTokenList.base().tokenListModNotify(this.tokenListListUpdate.tokenListCountDiff());
    }

    public void replaceTokens(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        int n;
        int n2;
        TokenListChange tokenListChange;
        int n3;
        MutableJoinTokenList mutableJoinTokenList = (MutableJoinTokenList)this.tokenList();
        int n4 = mutableJoinTokenList.tokenStartLocalIndex(this.matchIndex);
        int n5 = mutableJoinTokenList.activeTokenListIndex();
        if (n5 < (n3 = this.tokenListListUpdate.modTokenListIndex + this.tokenListListUpdate.removedTokenListCount)) {
            n5 = n3;
            n4 = 0;
        }
        int n6 = n5 + this.tokenListListUpdate.tokenListCountDiff();
        if (n4 != 0) {
            ++n6;
        }
        int n7 = this.relexTokenListIndex + this.relexChanges.size();
        while (n7 < n6) {
            RelexTokenListChange<T> relexTokenListChange = new RelexTokenListChange<T>(this.tokenListListUpdate.afterUpdateTokenList(mutableJoinTokenList, n7++));
            relexTokenListChange.setParentChangeIsBoundsChange(this.parentChangeIsBoundsChange);
            this.relexChanges.add(relexTokenListChange);
        }
        int n8 = n6 - 1;
        if (n4 != 0 && n8 >= this.relexTokenListIndex) {
            tokenListChange = this.relexChanges.get(n8 - this.relexTokenListIndex);
            tokenListChange.setMatchIndex(n4);
            --n8;
        }
        while (n8 >= this.relexTokenListIndex) {
            tokenListChange = this.relexChanges.get(n8 - this.relexTokenListIndex);
            tokenListChange.setMatchIndex(tokenListChange.tokenList().tokenCountCurrent());
            --n8;
        }
        if (this.tokenListListUpdate.isTokenListsMod()) {
            this.replaceTokenLists();
        }
        mutableJoinTokenList.moveIndexGap(this.relexTokenListIndex + this.relexChanges.size());
        if (this.relexTokenListIndex > 0) {
            EmbeddedTokenList embeddedTokenList = mutableJoinTokenList.tokenList(this.relexTokenListIndex - 1);
            n2 = embeddedTokenList.joinInfo.joinTokenIndex() + embeddedTokenList.joinTokenCount();
        } else {
            n2 = 0;
        }
        boolean bl = this.tokenListListUpdate.isTokenListsMod() && this.tokenListListUpdate.removedTokenListCount > 0;
        RemovedTokensCollector removedTokensCollector = new RemovedTokensCollector();
        for (n = 0; n < this.relexChanges.size(); ++n) {
            RelexTokenListChange<T> relexTokenListChange = this.relexChanges.get(n);
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)relexTokenListChange.tokenList();
            if (embeddedTokenList.joinInfo == null) {
                embeddedTokenList.joinInfo = new EmbeddedJoinInfo(mutableJoinTokenList.base(), n2, this.relexTokenListIndex + n);
            } else {
                embeddedTokenList.joinInfo.setRawJoinTokenIndex(n2);
            }
            if (n < this.relexChanges.size() - 1 || relexTokenListChange.index() + relexTokenListChange.removedTokenCount() == embeddedTokenList.tokenCountCurrent()) {
                embeddedTokenList.joinInfo.setJoinTokenLastPartShift(relexTokenListChange.joinTokenLastPartShift);
            }
            embeddedTokenList.replaceTokens(relexTokenListChange, tokenHierarchyEventInfo, embeddedTokenList == this.charModTokenList);
            n2 += embeddedTokenList.joinTokenCount();
            if (bl && n == this.tokenListListUpdate.modTokenListIndex - this.relexTokenListIndex) {
                removedTokensCollector.collectRemovedTokenLists();
                bl = false;
            }
            removedTokensCollector.collectRelexChange(relexTokenListChange);
        }
        if (bl) {
            removedTokensCollector.collectRemovedTokenLists();
        }
        removedTokensCollector.finish();
        int n9 = (n += this.relexTokenListIndex) < mutableJoinTokenList.tokenListCount() ? mutableJoinTokenList.tokenList((int)n).joinInfo.joinTokenIndex() : mutableJoinTokenList.base().joinTokenCount();
        int n10 = n2 - n9;
        mutableJoinTokenList.base().updateJoinTokenCount(n10);
        if (this.relexChanges.size() == 1 && !this.tokenListListUpdate.isTokenListsMod() && this.relexChanges.get(0).isBoundsChange()) {
            this.markBoundsChange();
        }
        mutableJoinTokenList.resetActiveAfterUpdate();
    }

    void collectAddedRemovedEmbeddings(TokenHierarchyUpdate.UpdateItem<T> updateItem) {
        RelexTokenListChange<T> relexTokenListChange;
        int n;
        int n2 = this.tokenListListUpdate.modTokenListIndex - this.relexTokenListIndex;
        for (n = 0; n < n2; ++n) {
            relexTokenListChange = this.relexChanges.get(n);
            updateItem.collectRemovedEmbeddings(relexTokenListChange);
        }
        this.tokenListListUpdate.collectRemovedEmbeddings(updateItem);
        while (n < this.relexChanges.size()) {
            relexTokenListChange = this.relexChanges.get(n);
            updateItem.collectRemovedEmbeddings(relexTokenListChange);
            ++n;
        }
        for (n = 0; n < this.relexChanges.size(); ++n) {
            relexTokenListChange = this.relexChanges.get(n);
            updateItem.collectAddedEmbeddings(relexTokenListChange);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\nTLLUpdate: " + this.tokenListListUpdate + ", relexTLInd=" + this.relexTokenListIndex + ", relexChgs.size()=" + this.relexChanges.size();
    }

    @Override
    public String toStringMods(int n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (RelexTokenListChange<T> relexTokenListChange : this.relexChanges) {
            stringBuilder.append(relexTokenListChange.toStringMods(n));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RelexTokenListChange<T extends TokenId>
    extends TokenListChange<T> {
        int joinTokenLastPartShift;

        RelexTokenListChange(EmbeddedTokenList<T> embeddedTokenList) {
            super(embeddedTokenList);
        }

        void finish() {
            this.setMatchIndex(this.tokenList().tokenCountCurrent());
        }

        @Override
        public String toString() {
            return super.toString() + ", lps=" + this.joinTokenLastPartShift;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RemovedTokensCollector {
        TokenOrEmbedding<T>[] removedTokensOrEs;
        int removedTokensIndex;
        AbstractToken<T> lastBranchToken;

        private RemovedTokensCollector() {
            this.removedTokensOrEs = new TokenOrEmbedding[JoinTokenListChange.this.removedTokenCount()];
        }

        void collectRelexChange(RelexTokenListChange<T> relexTokenListChange) {
            RemovedTokenList removedTokenList = relexTokenListChange.tokenChangeInfo().removedTokenList();
            if (removedTokenList.tokenCount() > 0) {
                TokenOrEmbedding tokenOrEmbedding = removedTokenList.tokenOrEmbedding(0);
                if (tokenOrEmbedding.token().getClass() == PartToken.class) {
                    if (((PartToken)tokenOrEmbedding.token()).joinToken() != this.lastBranchToken) {
                        this.removedTokensOrEs[this.removedTokensIndex++] = tokenOrEmbedding;
                    }
                } else {
                    this.removedTokensOrEs[this.removedTokensIndex++] = tokenOrEmbedding;
                }
                int n = removedTokenList.tokenCount() - 1;
                System.arraycopy(removedTokenList.tokenOrEmbeddings(), 1, this.removedTokensOrEs, this.removedTokensIndex, n);
                this.removedTokensIndex += n;
                this.lastBranchToken = removedTokenList.tokenOrEmbedding(n).token();
                this.lastBranchToken = this.lastBranchToken.getClass() == PartToken.class ? ((PartToken)this.lastBranchToken).joinToken() : null;
            }
        }

        void collectRemovedTokenLists() {
            EmbeddedTokenList<T>[] embeddedTokenListArray = JoinTokenListChange.this.tokenListListUpdate.removedTokenLists();
            for (int i = 0; i < embeddedTokenListArray.length; ++i) {
                EmbeddedTokenList embeddedTokenList = embeddedTokenListArray[i];
                int n = embeddedTokenList.tokenCountCurrent() - 1;
                if (n < 0) continue;
                TokenOrEmbedding tokenOrEmbedding = embeddedTokenList.tokenOrEmbedding(0);
                if (tokenOrEmbedding.token().getClass() == PartToken.class) {
                    if (((PartToken)tokenOrEmbedding.token()).joinToken() != this.lastBranchToken) {
                        this.removedTokensOrEs[this.removedTokensIndex++] = tokenOrEmbedding;
                    }
                } else {
                    this.removedTokensOrEs[this.removedTokensIndex++] = tokenOrEmbedding;
                }
                embeddedTokenList.copyElements(1, n + 1, this.removedTokensOrEs, this.removedTokensIndex);
                this.removedTokensIndex += n;
                this.lastBranchToken = embeddedTokenList.tokenOrEmbedding(n).token();
                this.lastBranchToken = this.lastBranchToken.getClass() == PartToken.class ? ((PartToken)this.lastBranchToken).joinToken() : null;
            }
        }

        void finish() {
            if (this.removedTokensIndex != this.removedTokensOrEs.length) {
                throw new IndexOutOfBoundsException("Invalid removedTokensIndex=" + this.removedTokensIndex + " != removedTokens.length=" + this.removedTokensOrEs.length);
            }
            JoinTokenListChange.this.setRemovedTokens(this.removedTokensOrEs);
        }
    }
}

