/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import java.util.List;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.token.JoinTokenText;
import org.netbeans.lib.lexer.token.PartToken;
import org.netbeans.lib.lexer.token.PropertyToken;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinToken<T extends TokenId>
extends PropertyToken<T> {
    private List<PartToken<T>> joinedParts;
    private int completeLength;
    private int extraTokenListSpanCount;

    public JoinToken(T t, int n, TokenPropertyProvider<T> tokenPropertyProvider, PartType partType) {
        super(t, n, tokenPropertyProvider, partType);
    }

    @Override
    public List<PartToken<T>> joinedParts() {
        return this.joinedParts;
    }

    public void setJoinedParts(List<PartToken<T>> list, int n) {
        assert (list != null) : "joinedParts expected to be non-null";
        this.joinedParts = list;
        for (PartToken<T> partToken : list) {
            this.completeLength += partToken.length();
        }
        this.extraTokenListSpanCount = n;
    }

    public PartToken<T> lastPart() {
        return this.joinedParts.get(this.joinedParts.size() - 1);
    }

    public int extraTokenListSpanCount() {
        return this.extraTokenListSpanCount;
    }

    @Override
    public int offset(TokenHierarchy<?> tokenHierarchy) {
        return this.joinedParts.get(0).offset(tokenHierarchy);
    }

    public int endOffset() {
        PartToken<T> partToken = this.joinedParts.get(this.joinedParts.size() - 1);
        return partToken.offset(null) + partToken.length();
    }

    @Override
    public int length() {
        return this.completeLength;
    }

    @Override
    public CharSequence text() {
        return new JoinTokenText<T>(this.joinedParts, this.completeLength);
    }

    @Override
    public boolean isRemoved() {
        return this.lastPart().isRemoved();
    }

    @Override
    public StringBuilder dumpInfo(StringBuilder stringBuilder, TokenHierarchy<?> tokenHierarchy, boolean bl, boolean bl2, int n) {
        stringBuilder = super.dumpInfo(stringBuilder, tokenHierarchy, bl, bl2, n);
        stringBuilder.append(", ").append(this.joinedParts.size()).append(" parts");
        int n2 = String.valueOf(this.joinedParts.size() - 1).length();
        for (int i = 0; i < this.joinedParts.size(); ++i) {
            stringBuilder.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)(n + 2));
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n2);
            this.joinedParts.get(i).dumpInfo(stringBuilder, tokenHierarchy, bl, bl2, n + 4);
        }
        return stringBuilder;
    }

    @Override
    public StringBuilder dumpText(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i = 0; i < this.joinedParts.size(); ++i) {
            this.joinedParts.get(i).dumpText(stringBuilder, charSequence);
        }
        return stringBuilder;
    }

    @Override
    protected String dumpInfoTokenType() {
        return "JoiT";
    }
}

