/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.html.HtmlDataObject;
import org.netbeans.modules.html.palette.HtmlPaletteFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private static final String DOCUMENT_SAVE_ENCODING = "Document_Save_Encoding";
    private static final String UTF_8_ENCODING = "UTF-8";
    public static boolean showConfirmationDialog = true;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            try {
                HtmlEditorSupport.this.saveDocument();
            }
            catch (UserCancelException userCancelException) {
                // empty catch block
            }
        }
    };

    HtmlEditorSupport(HtmlDataObject htmlDataObject) {
        super((DataObject)htmlDataObject, (CloneableEditorSupport.Env)new Environment(htmlDataObject));
        this.setMIMEType(htmlDataObject.getPrimaryFile().getMIMEType());
    }

    public void saveDocument() throws IOException {
        this.updateEncoding();
        super.saveDocument();
        this.getDataObject().setModified(false);
    }

    void updateEncoding() throws UserCancelException {
        String string = this.getDocumentText();
        String string2 = HtmlDataObject.findEncoding(string);
        String string3 = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        String string4 = null;
        if (string2 != null) {
            if (!this.isSupportedEncoding(string2) || !this.canEncode(string, string2)) {
                string4 = this.canEncode(string, string3) ? string3 : UTF_8_ENCODING;
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_unsupportedEncodingSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2, string4, string4.equals(UTF_8_ENCODING) ? "" : " the original"}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    throw new UserCancelException();
                }
            } else {
                string4 = string2;
            }
        } else if (!this.canEncode(string, string3)) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_badCharConversionSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string3}), 0, 2);
            confirmation.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                throw new UserCancelException();
            }
            string4 = UTF_8_ENCODING;
        } else {
            string4 = string3;
        }
        this.getDocument().putProperty(DOCUMENT_SAVE_ENCODING, string4);
    }

    public void open() {
        String string = ((HtmlDataObject)this.getDataObject()).getFileEncoding();
        String string2 = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        if (string != null && !this.isSupportedEncoding(string) && showConfirmationDialog) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_unsupportedEncodingLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string, string2}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        Charset charset = Charset.forName((String)styledDocument.getProperty(DOCUMENT_SAVE_ENCODING));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        try {
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject htmlDataObject = (HtmlDataObject)this.getDataObject();
        if (htmlDataObject.getCookie(SaveCookie.class) == null) {
            htmlDataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            htmlDataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        HtmlDataObject htmlDataObject = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = htmlDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            htmlDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            htmlDataObject.setModified(false);
        }
    }

    private String getDocumentText() {
        String string = "";
        try {
            StyledDocument styledDocument = this.getDocument();
            if (styledDocument != null) {
                string = styledDocument.getText(styledDocument.getStartPosition().getOffset(), styledDocument.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.WARNING, null, badLocationException);
        }
        return string;
    }

    private boolean canDecodeFile(FileObject fileObject, String string) {
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
            byte[] byArray = new byte[(int)fileObject.getSize()];
            bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            charsetDecoder.decode(ByteBuffer.wrap(byArray));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.WARNING, "Error during charset verification", iOException);
        }
        return false;
    }

    private boolean canEncode(String string, String string2) {
        CharsetEncoder charsetEncoder = Charset.forName(string2).newEncoder();
        return charsetEncoder.canEncode(string);
    }

    private boolean isSupportedEncoding(String string) {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            bl = false;
        }
        return bl;
    }

    protected CloneableEditor createCloneableEditor() {
        return new HtmlEditor(this);
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(HtmlDataObject htmlDataObject) {
            super((DataObject)htmlDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(HtmlEditorSupport.class);
        }
    }

    public static class HtmlEditor
    extends CloneableEditor {
        public HtmlEditor() {
        }

        void associatePalette(HtmlEditorSupport htmlEditorSupport) {
            final DataObject dataObject = htmlEditorSupport.getDataObject();
            if (!dataObject.isValid()) {
                return;
            }
            Node[] nodeArray = new Node[]{dataObject.getNodeDelegate()};
            final InstanceContent instanceContent = new InstanceContent();
            this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)instanceContent), nodeArray[0].getLookup()}));
            instanceContent.add((Object)this.getActionMap());
            this.setActivatedNodes(nodeArray);
            if (dataObject instanceof HtmlDataObject) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            PaletteController paletteController = HtmlPaletteFactory.getPalette(dataObject.getPrimaryFile());
                            instanceContent.add((Object)paletteController);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }
        }

        public HtmlEditor(HtmlEditorSupport htmlEditorSupport) {
            super((CloneableEditorSupport)htmlEditorSupport);
            this.initialize();
        }

        private void initialize() {
            this.associatePalette((HtmlEditorSupport)this.cloneableEditorSupport());
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
        }
    }
}

