/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.text.PositionBounds;

public abstract class Element
implements Serializable {
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected PositionBounds bounds;

    protected Element(PositionBounds positionBounds) {
        this.bounds = positionBounds;
    }

    public PositionBounds getBounds() {
        return this.bounds;
    }

    void update(Element element) {
        this.bounds = element.bounds;
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public final void print() {
        if (this.bounds == null) {
            return;
        }
        try {
            this.bounds.setText(this.getDocumentString());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public abstract String getDocumentString();

    public String toString() {
        if (this.bounds == null) {
            return "(no bounds)";
        }
        return new StringBuffer(16).append('(').append(this.bounds.getBegin().getOffset()).append(", ").append(this.bounds.getEnd().getOffset()).append(')').toString();
    }

    public static abstract class Basic
    extends Element {
        private static final String hexaDigitChars = "0123456789abcdefABCDEF";
        protected String value;

        protected static void appendIsoControlChar(StringBuilder stringBuilder, char c) {
            switch (c) {
                case '\t': {
                    stringBuilder.append('\\').append('t');
                    break;
                }
                case '\n': {
                    stringBuilder.append('\\').append('n');
                    break;
                }
                case '\f': {
                    stringBuilder.append('\\').append('f');
                    break;
                }
                case '\r': {
                    stringBuilder.append('\\').append('r');
                    break;
                }
                default: {
                    stringBuilder.append('\\').append('u');
                    for (int i = 12; i >= 0; i -= 4) {
                        stringBuilder.append(hexaDigitChars.charAt(c >> i & 0xF));
                    }
                }
            }
        }

        protected Basic(PositionBounds positionBounds, String string) {
            super(positionBounds);
            this.value = string;
        }

        void update(Element element) {
            super.update(element);
            this.value = ((Basic)element).value;
        }

        public String toString() {
            return this.value + "   " + super.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
            this.print();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Basic) {
                Basic basic = (Basic)object;
                if (this.value == null) {
                    return basic.value == null;
                }
                return this.value.equals(basic.value);
            }
            return false;
        }
    }

    public static class CommentElem
    extends Basic {
        static final long serialVersionUID = 2418308580934815756L;

        protected CommentElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String getDocumentString() {
            if (this.value == null || this.value.length() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.value);
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c == '\n') {
                    String string = stringBuffer.substring(n, i);
                    String string2 = CommentElem.escapeSpecialChars(string);
                    stringBuffer.replace(n, i, string2);
                    n = (i += string2.length() - string.length()) + 1;
                    bl = false;
                    continue;
                }
                if (bl || " \t\r\n\f".indexOf(c) != -1) continue;
                if (c == '#' || c == '!') {
                    n = i + 1;
                } else {
                    stringBuffer.insert(n, '#');
                    n = ++i;
                }
                bl = true;
            }
            return stringBuffer.toString();
        }

        private static final String escapeSpecialChars(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                assert (c != '\n');
                if (c < ' ' && c != '\t') {
                    Basic.appendIsoControlChar(stringBuilder, c);
                    continue;
                }
                if (c == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            return object instanceof CommentElem && super.equals(object);
        }
    }

    public static class ItemElem
    extends Element
    implements Node.Cookie {
        private KeyElem key;
        private ValueElem value;
        private CommentElem comment;
        private PropertiesStructure parent;
        public static final String PROP_ITEM_KEY = "key";
        public static final String PROP_ITEM_VALUE = "value";
        public static final String PROP_ITEM_COMMENT = "comment";
        static final long serialVersionUID = 1078147817847520586L;

        protected ItemElem(PositionBounds positionBounds, KeyElem keyElem, ValueElem valueElem, CommentElem commentElem) {
            super(positionBounds);
            this.key = keyElem;
            this.value = valueElem;
            this.comment = commentElem;
        }

        void setParent(PropertiesStructure propertiesStructure) {
            this.parent = propertiesStructure;
        }

        private PropertiesStructure getParent() {
            if (this.parent == null) {
                throw new IllegalStateException("Resource Bundle: Parent is missing");
            }
            return this.parent;
        }

        public String toString() {
            return this.comment.toString() + "\n" + (this.key == null ? "" : this.key.toString()) + "\n" + (this.value == null ? "" : this.value.toString()) + "\n";
        }

        public KeyElem getKeyElem() {
            return this.key;
        }

        public ValueElem getValueElem() {
            return this.value;
        }

        public CommentElem getCommentElem() {
            return this.comment;
        }

        void update(Element element) {
            super.update(element);
            if (this.key == null) {
                this.key = ((ItemElem)element).key;
            } else {
                this.key.update(((ItemElem)element).key);
            }
            if (this.value == null) {
                this.value = ((ItemElem)element).value;
            } else {
                this.value.update(((ItemElem)element).value);
            }
            this.comment.update(((ItemElem)element).comment);
        }

        public String getDocumentString() {
            return this.comment.getDocumentString() + (this.key == null ? "" : this.key.getDocumentString()) + (this.value == null ? "" : this.value.getDocumentString());
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public void setKey(String string) {
            String string2 = this.key.getValue();
            if (!string2.equals(string)) {
                this.key.setValue(string);
                this.getParent().itemKeyChanged(string2, this);
                this.firePropertyChange(PROP_ITEM_KEY, string2, string);
            }
        }

        public String getValue() {
            return this.value == null ? null : this.value.getValue();
        }

        public void setValue(String string) {
            String string2 = this.value.getValue();
            if (!string2.equals(string)) {
                if (string2.equals("")) {
                    this.key.print();
                }
                this.value.setValue(string);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_VALUE, string2, string);
            }
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.getValue();
        }

        public void setComment(String string) {
            String string2 = this.comment.getValue();
            if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
                this.comment.setValue(string);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_COMMENT, string2, string);
            }
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ItemElem)) {
                return false;
            }
            ItemElem itemElem = (ItemElem)object;
            return this.isKeyEqual(itemElem) && this.isValueEqual(itemElem) && this.isCommentEqual(itemElem);
        }

        private boolean isKeyEqual(ItemElem itemElem) {
            if (this.key == null) {
                return itemElem.key == null;
            }
            return this.key.equals(itemElem.key);
        }

        private boolean isValueEqual(ItemElem itemElem) {
            if (this.value == null) {
                return itemElem.value == null;
            }
            return this.value.equals(itemElem.value);
        }

        private boolean isCommentEqual(ItemElem itemElem) {
            if (this.comment == null) {
                return itemElem.comment == null;
            }
            return this.comment.equals(itemElem.comment);
        }
    }

    public static class KeyElem
    extends Basic {
        static final long serialVersionUID = 6828294289485744331L;

        protected KeyElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String getDocumentString() {
            return KeyElem.escapeSpecialChars(this.value) + "=";
        }

        private static final String escapeSpecialChars(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < ' ') {
                    Basic.appendIsoControlChar(stringBuilder, c);
                    continue;
                }
                switch (c) {
                    case '!': 
                    case '#': {
                        if (i != 0) break;
                        stringBuilder.append('\\');
                        break;
                    }
                    case ' ': 
                    case ':': 
                    case '=': 
                    case '\\': {
                        stringBuilder.append('\\');
                    }
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            return object instanceof KeyElem && super.equals(object);
        }
    }

    public static class ValueElem
    extends Basic {
        static final long serialVersionUID = 4662649023463958853L;

        protected ValueElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String getDocumentString() {
            return ValueElem.escapeSpecialChars(this.value) + "\n";
        }

        private static final String escapeSpecialChars(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
            boolean bl = true;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                boolean bl2 = false;
                if (c == '\\') {
                    bl = false;
                    bl2 = true;
                } else if (bl) {
                    if (c == ' ') {
                        bl2 = true;
                    } else {
                        boolean bl3 = bl = c == '\t' || c == '\r' || c == '\n' || c == '\f';
                    }
                }
                if (c < ' ') {
                    Basic.appendIsoControlChar(stringBuilder, c);
                    continue;
                }
                if (bl2) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }
}

