/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

final class PropertiesEncoding
extends FileEncodingQueryImplementation {
    PropertiesEncoding() {
    }

    public Charset getEncoding(FileObject fileObject) {
        assert (!fileObject.isValid() || fileObject.isData());
        try {
            return new PropCharset(fileObject);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    static final class PropCharset
    extends Charset
    implements FileChangeListener {
        private final Reference<FileObject> fileRef;
        private URL fileURL;

        PropCharset(FileObject fileObject) throws FileStateInvalidException {
            super("ISO-8859-1", null);
            this.fileRef = new WeakReference<FileObject>(fileObject);
            fileObject.addFileChangeListener((FileChangeListener)this);
            this.updateURL(fileObject);
        }

        PropCharset() {
            super("ISO-8859-1", null);
            this.fileRef = null;
        }

        public boolean contains(Charset charset) {
            return true;
        }

        public CharsetEncoder newEncoder() {
            return new PropCharsetEncoder(this);
        }

        public CharsetDecoder newDecoder() {
            long l = this.fileRef != null ? this.getFileSize() : -1L;
            return l > 0L ? new PropCharsetDecoder(this, l) : new PropCharsetDecoder(this);
        }

        private long getFileSize() {
            FileObject fileObject = this.getFile();
            return fileObject != null && fileObject.isValid() ? fileObject.getSize() : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject getFile() {
            URL uRL;
            FileObject fileObject = this.fileRef.get();
            PropCharset propCharset = this;
            synchronized (propCharset) {
                uRL = this.fileURL;
            }
            if (fileObject == null && uRL != null) {
                fileObject = URLMapper.findFileObject((URL)uRL);
            }
            return fileObject;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.updateURL(fileRenameEvent.getFile());
        }

        public void fileChanged(FileEvent fileEvent) {
            this.updateURL(fileEvent.getFile());
        }

        private synchronized void updateURL(FileObject fileObject) {
            try {
                this.fileURL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.fileURL = null;
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            assert (false);
        }
    }

    static final class PropCharsetDecoder
    extends CharsetDecoder {
        private final Logger log = Logger.getLogger(this.getClass().getName().replace('$', '.'));
        private static final float avgCharsPerByte = 1.0f;
        private static final float maxCharsPerByte = 6.0f;
        private static final int maxCharsPerByteInt = 6;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 8192;
        private static final int SIZE_UNKNOWN = -1;
        private long inputSize;
        private int bytesDecoded = 0;
        private final byte[] inBuf = new byte[8192];
        private final char[] outBuf = new char[8192];
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private State state;
        private int unicodeBytesRead;
        private int unicodeValue;
        private char[] unicodeValueChars = new char[4];
        private static final String hexadecimalChars = "0123456789abcdefABCDEF";

        PropCharsetDecoder(Charset charset) {
            this(charset, -1L);
        }

        PropCharsetDecoder(Charset charset, long l) {
            super(charset, 1.0f, 6.0f);
            this.implReset();
            this.inputSize = l;
        }

        protected void implReset() {
            this.log.finer("");
            this.log.finer("implReset() called");
            this.inputSize = -1L;
            this.bytesDecoded = 0;
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
            this.state = State.INITIAL;
            this.unicodeBytesRead = 0;
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            this.log.finer("");
            this.log.finer("decodeLoop() called");
            if (this.log.isLoggable(Level.FINEST)) {
                String string = String.format("%5d", byteBuffer.remaining());
                String string2 = String.format("%5d", charBuffer.remaining());
                this.log.finest("    - input:  " + string + " bytes");
                this.log.finest("    - output: " + string2 + " chars");
            }
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(byteBuffer);
                    do {
                        this.bytesDecoded += this.decodeBuf();
                        assert ((long)this.bytesDecoded != this.inputSize || this.emptyIn);
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        if (this.emptyIn && this.hasPendingCharacters() && (this.inputSize == -1L || (long)this.bytesDecoded >= this.inputSize)) {
                            this.handlePendingCharacters();
                        }
                        this.flushOutBuf(charBuffer);
                        if (!this.fullOut) continue;
                        this.log.finest(" - returning OVERFLOW");
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn);
                    break;
                }
                this.log.finest(" - returning UNDERFLOW");
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException bufferOverflowException) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        private boolean hasPendingCharacters() {
            return this.state != State.INITIAL;
        }

        private void handlePendingCharacters() {
            this.log.finer("handlePendingCharacters()");
            if (!this.hasPendingCharacters()) {
                this.log.finer(" - no pending characters");
                return;
            }
            switch (this.state) {
                case INITIAL: {
                    assert (false);
                    break;
                }
                case BACKSLASH: {
                    this.log.finer(" - backslash pending");
                    this.outBuf[this.outBufPos++] = 92;
                    break;
                }
                case UNICODE: {
                    this.log.finer(" - broken \\u.... sequence pending");
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("    - " + this.unicodeBytesRead + " unicode value bytes pending");
                    }
                    assert (this.unicodeBytesRead >= 0 && this.unicodeBytesRead < 4);
                    this.flushUnicodeSequence();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.state = State.INITIAL;
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            this.log.finer("");
            this.log.finer("implFlush() called");
            this.fullOut = charBuffer.hasRemaining();
            return this.flushOutBuf(charBuffer) ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }

        private void readIn(ByteBuffer byteBuffer) {
            this.log.finer("filling inBuf: ");
            if (this.emptyIn) {
                this.log.finer(" - input empty (emptyIn already set)");
                return;
            }
            int n = byteBuffer.remaining();
            if (n == 0) {
                this.log.finer(" - input empty (emptyIn will be set)");
                this.emptyIn = true;
                return;
            }
            int n2 = this.inBuf.length - this.inBufPos;
            if (n2 == 0) {
                this.log.finer(" - no space remaining in inBuf");
                return;
            }
            int n3 = Math.min(n, n2);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(" - " + n3 + " bytes will be read");
            }
            byteBuffer.get(this.inBuf, this.inBufPos, n3);
            this.inBufPos += n3;
            this.emptyInBuf = false;
            if (n3 == n) {
                assert (byteBuffer.remaining() == 0);
                this.log.finer(" - all remaining bytes were read (emptyIn will be set)");
                this.emptyIn = true;
            }
        }

        private int decodeBuf() {
            int n;
            this.log.finer("decoding inBuf, writing to outBuf");
            if (this.emptyInBuf) {
                this.log.finer(" - inBuf is empty - nothing to decode");
                return 0;
            }
            int n2 = 0;
            this.log.finest(" - decoding bytes:");
            this.log.finest("     - initial state: " + (Object)((Object)this.state));
            while (n2 < this.inBufPos && this.outBufPos <= 8186) {
                n = this.decodeByte(this.inBuf[n2++]);
                if (this.log.isLoggable(Level.FINEST)) {
                    StringBuilder stringBuilder = new StringBuilder(60);
                    stringBuilder.append("     - byte 0x");
                    stringBuilder.append(PropCharsetDecoder.hexavalue(this.inBuf[n2 - 1]));
                    stringBuilder.append(" => ").append((Object)this.state);
                    this.log.finest(stringBuilder.toString());
                }
                if (n >= 0) continue;
                --n2;
                this.log.finer("          - last byte returned to be processed again");
                this.unicodeBytesRead = 0;
                this.unicodeValue = 0;
                this.state = State.INITIAL;
            }
            n = this.inBufPos - n2;
            if (n != 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(" - " + n + " bytes will remain in the inBuf");
                }
                System.arraycopy(this.inBuf, n2, this.inBuf, 0, n);
            } else {
                this.log.finer(" - all bytes were successfully decoded");
            }
            this.inBufPos = n;
            this.emptyInBuf = this.inBufPos == 0;
            return n2;
        }

        private boolean flushOutBuf(CharBuffer charBuffer) {
            this.log.finer("flushing outBuf");
            if (this.outBufPos == 0) {
                this.log.finer(" - outBuf is empty - nothing to flush");
                return false;
            }
            if (this.fullOut) {
                this.log.finer(" - output CharBuffer is full (fullOut already set)");
                return true;
            }
            int n = charBuffer.remaining();
            if (n == 0) {
                this.log.finer(" - output CharBuffer is full (fullOut will be set)");
                this.fullOut = true;
                return true;
            }
            int n2 = Math.min(n, this.outBufPos);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(" - " + n2 + " chars will be written");
            }
            charBuffer.put(this.outBuf, 0, n2);
            int n3 = this.outBufPos - n2;
            if (n3 != 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(" - " + n3 + " bytes will remain in the outBuf");
                }
                System.arraycopy(this.outBuf, n2, this.outBuf, 0, n3);
            } else {
                this.log.finer(" - all bytes were successfully flushed");
            }
            this.outBufPos = n3;
            if (n2 == n) {
                assert (charBuffer.remaining() == 0);
                this.log.finer(" - output CharBuffer is now full (fullOut will be set)");
                this.fullOut = true;
            }
            return n3 != 0;
        }

        private int decodeByte(byte n) {
            int n2;
            int n3 = this.outBufPos;
            int n4 = n2 = n >= 0 ? n : n + 256;
            assert (n2 >= 0 && (n2 & 0xFF) == n2);
            char c = (char)n2;
            switch (this.state) {
                case INITIAL: {
                    if (c == '\\') {
                        this.state = State.BACKSLASH;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = c;
                    break;
                }
                case BACKSLASH: {
                    if (c == 'u') {
                        this.state = State.UNICODE;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = c;
                    this.state = State.INITIAL;
                    break;
                }
                case UNICODE: {
                    boolean bl = false;
                    int n5 = hexadecimalChars.indexOf(c);
                    if (n5 >= 0) {
                        if (n5 > 15) {
                            n5 -= 6;
                        }
                        assert (n5 <= 15);
                        this.unicodeValue = this.unicodeValue << 4 | n5;
                        if (++this.unicodeBytesRead == 4) {
                            if (this.unicodeValue <= 32) {
                                this.unicodeValueChars[3] = c;
                                this.flushUnicodeSequence();
                            } else {
                                this.outBuf[this.outBufPos++] = (char)this.unicodeValue;
                            }
                            this.state = State.INITIAL;
                        } else {
                            this.unicodeValueChars[this.unicodeBytesRead - 1] = c;
                        }
                    } else {
                        bl = true;
                        this.flushUnicodeSequence();
                        this.state = State.INITIAL;
                    }
                    if (this.state == State.UNICODE) break;
                    this.unicodeBytesRead = 0;
                    this.unicodeValue = 0;
                    if (!bl) break;
                    return -1;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.outBufPos - n3;
        }

        private void flushUnicodeSequence() {
            this.outBuf[this.outBufPos++] = 92;
            this.outBuf[this.outBufPos++] = 117;
            for (int i = 0; i < this.unicodeBytesRead; ++i) {
                this.outBuf[this.outBufPos++] = this.unicodeValueChars[i];
            }
            this.unicodeBytesRead = 0;
            this.unicodeValue = 0;
        }

        private static char[] hexavalue(byte n) {
            int n2 = n >= 0 ? n : n + 256;
            char[] cArray = new char[]{hexadecimalChars.charAt(n2 / 16), hexadecimalChars.charAt(n2 % 16)};
            return cArray;
        }

        char[] decodeBytesForTests(byte[] byArray) throws CharacterCodingException {
            CharBuffer charBuffer = this.decode(ByteBuffer.wrap(byArray));
            char[] cArray = charBuffer.array();
            int n = charBuffer.limit();
            if (n == cArray.length) {
                return cArray;
            }
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            return cArray2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            INITIAL,
            BACKSLASH,
            UNICODE;

        }
    }

    static final class PropCharsetEncoder
    extends CharsetEncoder {
        private static final int avgEncodedTokenLen = 3;
        private static final int maxEncodedTokenLen = 6;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 24576;
        private final char[] inBuf = new char[8192];
        private final byte[] outBuf = new byte[24576];
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private static final byte zeroByte = 48;
        private static final byte[] hexadecimalChars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        PropCharsetEncoder(Charset charset) {
            super(charset, 3.0f, 6.0f);
            this.implReset();
        }

        PropCharsetEncoder() {
            super(new PropCharset(), 3.0f, 6.0f);
            this.implReset();
        }

        protected void implReset() {
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(charBuffer);
                    do {
                        this.encodeBuf();
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        this.flushOutBuf(byteBuffer);
                        if (!this.fullOut) continue;
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn);
                    break;
                }
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException bufferOverflowException) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            return this.flushOutBuf(byteBuffer) ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }

        private void readIn(CharBuffer charBuffer) {
            if (this.emptyIn) {
                return;
            }
            int n = charBuffer.remaining();
            if (n == 0) {
                this.emptyIn = true;
                return;
            }
            int n2 = this.inBuf.length - this.inBufPos;
            if (n2 == 0) {
                return;
            }
            int n3 = Math.min(n, n2);
            charBuffer.get(this.inBuf, this.inBufPos, n3);
            this.inBufPos += n3;
            this.emptyInBuf = false;
            if (n3 == n) {
                assert (charBuffer.remaining() == 0);
                this.emptyIn = true;
            }
        }

        private void encodeBuf() {
            if (this.emptyInBuf) {
                return;
            }
            int n = 0;
            while (n < this.inBufPos && this.outBufPos <= 24570) {
                this.encodeChar(this.inBuf[n++]);
            }
            int n2 = this.inBufPos - n;
            if (n2 != 0) {
                System.arraycopy(this.inBuf, n, this.inBuf, 0, n2);
            }
            this.inBufPos = n2;
            this.emptyInBuf = this.inBufPos == 0;
        }

        private boolean flushOutBuf(ByteBuffer byteBuffer) {
            if (this.fullOut) {
                return true;
            }
            int n = byteBuffer.remaining();
            if (n == 0) {
                this.fullOut = true;
                return true;
            }
            if (this.outBufPos == 0) {
                return false;
            }
            int n2 = Math.min(n, this.outBufPos);
            byteBuffer.put(this.outBuf, 0, n2);
            int n3 = this.outBufPos - n2;
            if (n3 != 0) {
                System.arraycopy(this.outBuf, n2, this.outBuf, 0, n3);
            }
            this.outBufPos = n3;
            if (n2 == n) {
                assert (byteBuffer.remaining() == 0);
                this.fullOut = true;
            }
            return n3 != 0;
        }

        private int encodeChar(char c) {
            int n = this.outBufPos;
            char c2 = c;
            if (c == '\r' || c == '\n' || c == '\t' || c == '\f') {
                this.outBuf[this.outBufPos++] = (byte)c;
            } else if (c < ' ' || c > '~') {
                this.outBuf[this.outBufPos++] = 92;
                this.outBuf[this.outBufPos++] = 117;
                if (c >= '\u0100') {
                    this.outBuf[this.outBufPos++] = hexadecimalChars[c2 >> 12 & 0xF];
                    this.outBuf[this.outBufPos++] = hexadecimalChars[c2 >> 8 & 0xF];
                } else {
                    this.outBuf[this.outBufPos++] = 48;
                    this.outBuf[this.outBufPos++] = 48;
                }
                this.outBuf[this.outBufPos++] = hexadecimalChars[c2 >> 4 & 0xF];
                this.outBuf[this.outBufPos++] = hexadecimalChars[c2 & 0xF];
            } else {
                this.outBuf[this.outBufPos++] = (byte)c;
            }
            return this.outBufPos - n;
        }

        byte[] encodeCharForTests(char c) {
            this.reset();
            int n = this.encodeChar(c);
            byte[] byArray = new byte[n];
            System.arraycopy(this.outBuf, 0, byArray, 0, n);
            return byArray;
        }

        byte[] encodeStringForTests(String string) throws CharacterCodingException {
            ByteBuffer byteBuffer = this.encode(CharBuffer.wrap(string));
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.limit();
            if (n == byArray.length) {
                return byArray;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
    }
}

