/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DefaultOpenFileImpl
implements OpenFileImpl,
Runnable {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final FileObject fileObject;
    private final int line;

    private DefaultOpenFileImpl(FileObject fileObject, int n) {
        this.fileObject = fileObject;
        this.line = n;
    }

    public DefaultOpenFileImpl() {
        this.fileObject = null;
        this.line = -1;
    }

    protected final void setStatusLine(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    protected void notifyCannotOpen(String string) {
        assert (EventQueue.isDispatchThread());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)string)));
    }

    private boolean openEditor(EditorCookie editorCookie, int n) {
        StyledDocument styledDocument;
        JEditorPane[] jEditorPaneArray;
        assert (EventQueue.isDispatchThread());
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("openEditor(EditorCookie, line=" + n + ')');
        }
        if ((jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
            Container container;
            this.log.finest("open pane(s) found");
            if (n >= 0) {
                int n2 = DefaultOpenFileImpl.getCursorOffset(editorCookie.getDocument(), n);
                jEditorPaneArray[0].setCaretPosition(n2);
            }
            if ((container = SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPaneArray[0])) != null) {
                ((TopComponent)container).requestActive();
            } else assert (false);
            return true;
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)iOException, string));
            return false;
        }
        editorCookie.open();
        if (n >= 0) {
            this.openDocAtLine(editorCookie, styledDocument, n);
        }
        return true;
    }

    private void openDocAtLine(EditorCookie editorCookie, StyledDocument styledDocument, int n) {
        assert (EventQueue.isDispatchThread());
        assert (n >= 0);
        assert (editorCookie.getDocument() == styledDocument);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("openDocAtLine(EditorCookie, Document, line=" + n + ')');
        }
        int n2 = DefaultOpenFileImpl.getCursorOffset(styledDocument, n);
        new SetCursorTask(editorCookie, n2).perform();
    }

    private static int getCursorOffset(StyledDocument styledDocument, int n) {
        assert (EventQueue.isDispatchThread());
        assert (n >= 0);
        try {
            return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
            int n2 = element.getElementCount();
            if (n >= n2) {
                return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
            }
            throw indexOutOfBoundsException;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class clazz, int n) {
        assert (EventQueue.isDispatchThread());
        if (clazz == EditorCookie.Observable.class || clazz == EditorCookie.class) {
            return this.openEditor((EditorCookie)cookie, n);
        }
        if (clazz == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (clazz == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (clazz == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private final boolean openDataObjectByCookie(DataObject dataObject, int n) {
        block3: {
            Node.Cookie cookie;
            Class<OpenCookie> clazz;
            block2: {
                clazz = OpenCookie.class;
                cookie = dataObject.getCookie(OpenCookie.class);
                if (cookie != null) break block2;
                clazz = EditCookie.class;
                cookie = dataObject.getCookie(EditCookie.class);
                if (cookie != null) break block2;
                clazz = ViewCookie.class;
                cookie = dataObject.getCookie(ViewCookie.class);
                if (cookie == null) break block3;
            }
            return this.openByCookie(cookie, clazz, n);
        }
        return false;
    }

    public void run() {
        assert (EventQueue.isDispatchThread());
        this.open(this.fileObject, this.line);
    }

    public boolean open(FileObject fileObject, int n) {
        Node node;
        Action action;
        DataObject dataObject;
        String string;
        block15: {
            Node.Cookie cookie;
            Class<EditorCookie.Observable> clazz;
            block16: {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("open(" + fileObject.getNameExt() + ", line=" + n + ") called from thread " + Thread.currentThread().getName());
                }
                if (!EventQueue.isDispatchThread()) {
                    this.log.finest(" - rescheduling to EDT using invokeLater(...)");
                    EventQueue.invokeLater(new DefaultOpenFileImpl(fileObject, n));
                    return true;
                }
                assert (EventQueue.isDispatchThread());
                this.log.finest(" - yes, it is an EDT");
                string = fileObject.getNameExt();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    return false;
                }
                if (n == -1) break block15;
                clazz = EditorCookie.Observable.class;
                cookie = dataObject.getCookie(EditorCookie.Observable.class);
                if (cookie != null) break block16;
                clazz = EditorCookie.class;
                cookie = dataObject.getCookie(EditorCookie.class);
                if (cookie == null) break block15;
            }
            boolean bl = this.openByCookie(cookie, clazz, n);
            return bl;
        }
        if ((action = (node = dataObject.getNodeDelegate()).getPreferredAction()) != null && !(action instanceof FileSystemAction) && !(action instanceof ToolsAction)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(" - using preferred action (\"" + action.getValue("Name") + "\" - " + action.getClass().getName() + ") for opening the file");
            }
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(node.getLookup());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("    - it is a ContextAwareAction");
                    this.log.finest("    - using a context-aware instance instead (\"" + action.getValue("Name") + "\" - " + action.getClass().getName() + ')');
                }
            }
            this.log.finest("   - will call action.actionPerformed(...)");
            action.actionPerformed(new ActionEvent(node, 0, ""));
            return true;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_opening", (Object)string));
        boolean bl = this.openDataObjectByCookie(dataObject, n);
        if (bl) {
            return true;
        }
        if (fileObject.isFolder() || FileUtil.isArchiveFile((FileObject)fileObject)) {
            Node node2 = dataObject.getNodeDelegate();
            if (node2 != null) {
                NodeOperation.getDefault().explore(node2);
                return true;
            }
            return false;
        }
        return false;
    }

    final class SetCursorTask
    implements Runnable,
    PropertyChangeListener {
        private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 200;
        private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 10000;
        private static final int MAX_TRIES = 50;
        private final EditorCookie editorCookie;
        private final EditorCookie.Observable observable;
        private final int offset;
        private volatile boolean success = false;

        private SetCursorTask(EditorCookie editorCookie, int n) {
            this.editorCookie = editorCookie;
            this.observable = editorCookie instanceof EditorCookie.Observable ? (EditorCookie.Observable)editorCookie : null;
            this.offset = n;
            if (DefaultOpenFileImpl.this.log.isLoggable(Level.FINEST)) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask.<init>");
                DefaultOpenFileImpl.this.log.finest(" - observable: " + (this.observable != null));
            }
        }

        private void perform() {
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: perform()");
            DefaultOpenFileImpl.this.log.finest("SetCursorTask: Calling tryNow() for the first time...");
            if (this.tryNow()) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask:    SUCCESS!");
                return;
            }
            if (this.observable != null) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask: addPropertyChangeListener...");
                this.observable.addPropertyChangeListener((PropertyChangeListener)this);
                DefaultOpenFileImpl.this.log.finest("SetCursorTask: tryNow() after adding the listener...");
                if (this.tryNow()) {
                    DefaultOpenFileImpl.this.log.finest("SetCursorTask:    SUCCESS!");
                    return;
                }
            } else {
                this.trySeveralTimes();
            }
        }

        private boolean tryNow() {
            assert (!this.success);
            JEditorPane[] jEditorPaneArray = this.editorCookie.getOpenedPanes();
            if (jEditorPaneArray != null) {
                this.success = true;
                jEditorPaneArray[0].setCaretPosition(this.offset);
                return true;
            }
            return false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: propertyChange()");
            assert ("openedPanes".equals(propertyChangeEvent.getPropertyName()));
            this.observable.removePropertyChangeListener((PropertyChangeListener)this);
            Mutex.EVENT.writeAccess((Runnable)this);
        }

        private void trySeveralTimes() {
            DefaultOpenFileImpl.this.log.finest("SetCursorTask: trySeveralTimes()");
            RequestProcessor.getDefault().post((Runnable)new ScheduledOpenTask(), 200);
        }

        public void run() {
            assert (EventQueue.isDispatchThread());
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: run()");
            if (this.success) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask:   - already done");
                return;
            }
            DefaultOpenFileImpl.this.log.finest("SetCursorTask:   tryNow() from run()");
            this.tryNow();
            if (this.observable != null && !this.success) {
                assert (false);
                this.notifyCouldNotOpen();
            }
        }

        private void notifyCouldNotOpen() {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_couldNotOpenAt"), 1));
        }

        class ScheduledOpenTask
        implements Runnable {
            private volatile int remainingTries = 50;

            ScheduledOpenTask() {
            }

            public void run() {
                try {
                    EventQueue.invokeAndWait(SetCursorTask.this);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
                if (!SetCursorTask.this.success) {
                    if (--this.remainingTries != 0) {
                        RequestProcessor.getDefault().post((Runnable)this, 200);
                    } else {
                        SetCursorTask.this.notifyCouldNotOpen();
                    }
                }
            }
        }
    }
}

