/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecentFiles {
    private static List<HistoryItem> history = new ArrayList<HistoryItem>();
    private static Preferences prefs;
    private static final Object HISTORY_LOCK;
    private static final String PREFS_NODE = "RecentFilesHistory";
    private static final String PROP_URL_PREFIX = "RecentFilesURL.";
    private static final String SEPARATOR = "; time=";
    static final int MAX_HISTORY_ITEMS = 15;

    private RecentFiles() {
    }

    public static void init() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List<HistoryItem> list = RecentFiles.load();
                Object object = HISTORY_LOCK;
                synchronized (object) {
                    history.addAll(0, list);
                }
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowRegistryL());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HistoryItem> getRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory(false);
            return Collections.unmodifiableList(history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory(true);
            return !history.isEmpty();
        }
    }

    static List<HistoryItem> load() {
        String[] stringArray;
        Preferences preferences = RecentFiles.getPrefs();
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, backingStoreException.getMessage(), backingStoreException);
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>();
        for (String string : stringArray) {
            String string2 = preferences.get(string, null);
            if (string.startsWith(PROP_URL_PREFIX) && string2 != null) {
                try {
                    int n = new Integer(string.substring(PROP_URL_PREFIX.length()));
                    HistoryItem historyItem = new HistoryItem(n, new URL(string2));
                    int n2 = arrayList.indexOf(historyItem);
                    if (n2 == -1) {
                        arrayList.add(historyItem);
                        continue;
                    }
                    preferences.remove(PROP_URL_PREFIX + Math.max(((HistoryItem)arrayList.get(n2)).id, n));
                    ((HistoryItem)arrayList.get(n2)).id = Math.min(((HistoryItem)arrayList.get(n2)).id, n);
                }
                catch (Exception exception) {
                    Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, exception.getMessage(), exception);
                    preferences.remove(string);
                }
                continue;
            }
            preferences.remove(string);
        }
        Collections.sort(arrayList);
        RecentFiles.store(arrayList);
        return arrayList;
    }

    static void store() {
        RecentFiles.store(history);
    }

    static void store(List<HistoryItem> list) {
        Preferences preferences = RecentFiles.getPrefs();
        for (int i = 0; i < list.size(); ++i) {
            HistoryItem historyItem = list.get(i);
            if (historyItem.id != i && historyItem.id >= list.size()) {
                preferences.remove(PROP_URL_PREFIX + historyItem.id);
            }
            historyItem.id = i;
            preferences.put(PROP_URL_PREFIX + i, historyItem.getURL().toExternalForm());
        }
    }

    static Preferences getPrefs() {
        if (prefs == null) {
            prefs = NbPreferences.forModule(RecentFiles.class).node(PREFS_NODE);
        }
        return prefs;
    }

    private static void addFile(TopComponent topComponent) {
        if (topComponent instanceof CloneableTopComponent) {
            RecentFiles.addFile(RecentFiles.obtainURL(topComponent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFile(URL uRL) {
        if (uRL != null) {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem historyItem = null;
                while (history.remove(historyItem = RecentFiles.findHistoryItem(uRL))) {
                }
                historyItem = new HistoryItem(0, uRL);
                history.add(0, historyItem);
                for (int i = 15; i < history.size(); ++i) {
                    history.remove(i);
                }
                RecentFiles.store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFile(TopComponent topComponent) {
        URL uRL;
        if (topComponent instanceof CloneableTopComponent && (uRL = RecentFiles.obtainURL(topComponent)) != null) {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem historyItem = RecentFiles.findHistoryItem(uRL);
                if (historyItem != null) {
                    history.remove(historyItem);
                }
                RecentFiles.store();
            }
        }
    }

    private static URL obtainURL(TopComponent topComponent) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            return RecentFiles.convertFile2URL(fileObject);
        }
        return null;
    }

    private static HistoryItem findHistoryItem(URL uRL) {
        for (HistoryItem historyItem : history) {
            if (!uRL.equals(historyItem.getURL())) continue;
            return historyItem;
        }
        return null;
    }

    static URL convertFile2URL(FileObject fileObject) {
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
        if (uRL == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, "convertFile2URL: URL can't be found for FileObject " + fileObject);
        }
        return uRL;
    }

    static FileObject convertURL2File(URL uRL) {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, "convertURL2File: File can't be found for URL " + uRL);
        }
        return fileObject;
    }

    private static void checkHistory(boolean bl) {
        assert (Thread.holdsLock(HISTORY_LOCK));
        Iterator<HistoryItem> iterator = history.iterator();
        while (iterator.hasNext()) {
            HistoryItem historyItem = iterator.next();
            FileObject fileObject = RecentFiles.convertURL2File(historyItem.getURL());
            if (fileObject == null || !fileObject.isValid()) {
                iterator.remove();
                continue;
            }
            if (!bl) continue;
            break;
        }
    }

    static {
        HISTORY_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HistoryItem
    implements Comparable<HistoryItem> {
        private int id;
        private URL fileURL;
        private String fileName;

        HistoryItem(int n, URL uRL) {
            this.fileURL = uRL;
            this.id = n;
        }

        public URL getURL() {
            return this.fileURL;
        }

        public String getFileName() {
            if (this.fileName == null) {
                int n = this.fileURL.getFile().lastIndexOf(47);
                this.fileName = n != -1 && n < this.fileURL.getFile().length() ? this.fileURL.getFile().substring(n + 1) : this.fileURL.getFile();
            }
            return this.fileName;
        }

        @Override
        public int compareTo(HistoryItem historyItem) {
            return this.id - historyItem.id;
        }

        public boolean equals(Object object) {
            if (object instanceof HistoryItem) {
                return ((HistoryItem)object).getURL().equals(this.fileURL);
            }
            return false;
        }
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("tcClosed".equals(propertyChangeEvent.getPropertyName())) {
                RecentFiles.addFile((TopComponent)propertyChangeEvent.getNewValue());
            }
            if ("tcOpened".equals(propertyChangeEvent.getPropertyName())) {
                RecentFiles.removeFile((TopComponent)propertyChangeEvent.getNewValue());
            }
        }
    }
}

