/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeListener;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultViewPanel
extends JPanel {
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final boolean SHOW_CONTEXT_BY_DEFAULT = true;
    private boolean contextViewEnabled = true;
    private boolean ignoreContextButtonToggle = false;
    private boolean hasResults = false;
    private ResultTreeModel treeModel = null;
    final JTree tree;
    private final NodeListener nodeListener;
    private ResultModel resultModel = null;
    private BasicSearchCriteria basicSearchCriteria;
    private List<SearchType> searchTypes;
    private double dividerLocation = -1.0;
    private String searchScopeType;
    private MessageFormat nodeCountFormat;
    private MessageFormat nodeCountFormatFullText;
    private IssuesPanel issuesPanel;
    private final JScrollPane treeView;
    private final CardLayout resultViewCards;
    private JSplitPane splitPane;
    private final JPanel resultsPanel;
    private final JToolBar toolBar;
    private JSeparator toolbarSeparator;
    private JButton btnShowDetails = new JButton();
    private JButton btnModifySearch = new JButton();
    private JButton btnStop = new JButton();
    private JButton btnReplace = new JButton();
    private JButton btnPrev;
    private JButton btnNext;
    private JToggleButton btnDisplayContext = new JToggleButton();
    private JToolBar.Separator sepDisplayContext;
    private boolean contextViewVisible = false;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private final ArrowStatusUpdater arrowUpdater;
    private ContextView contextView;
    private int objectsCount = 0;
    private SearchTask task;
    private MatchingObject matchingObjIndexCacheObj = null;
    private int matchingObjIndexCacheIndex = -1;

    public ResultViewPanel(SearchTask searchTask) {
        this.setLayout(new GridBagLayout());
        this.arrowUpdater = new ArrowStatusUpdater(this);
        this.task = searchTask;
        this.treeModel = this.createTreeModel();
        this.nodeListener = new NodeListener();
        this.tree = this.createTree(this.treeModel, this.nodeListener, this.arrowUpdater);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.resultViewCards = new CardLayout();
        this.resultsPanel = new JPanel(this.resultViewCards);
        this.toolBar = new JToolBar(1);
        this.btnDisplayContext.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/res/context.gif", (boolean)true));
        this.btnDisplayContext.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TOOLTIP_ShowContext"));
        this.btnDisplayContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ShowContext"));
        this.btnDisplayContext.setSelected(true);
        this.btnPrev = new JButton();
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/res/prev.png", (boolean)true));
        this.btnPrev.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TEXT_BUTTON_PREV_MATCH"));
        this.btnNext = new JButton();
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/res/next.png", (boolean)true));
        this.btnNext.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TEXT_BUTTON_NEXT_MATCH"));
        this.toolBar.add(this.btnDisplayContext);
        this.sepDisplayContext = new JToolBar.Separator();
        this.toolBar.add(this.sepDisplayContext);
        this.toolBar.add(this.btnPrev);
        this.toolBar.add(this.btnNext);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.btnPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewPanel.this.goToNext(false);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewPanel.this.goToNext(true);
            }
        });
        this.btnDisplayContext.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ResultViewPanel.this.ignoreContextButtonToggle) {
                    ResultViewPanel.this.contextViewEnabled = itemEvent.getStateChange() == 1;
                    ResultViewPanel.this.updateContextViewVisibility();
                }
            }
        });
        this.toolbarSeparator = new JSeparator();
        this.toolbarSeparator.setOrientation(1);
        this.btnShowDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewPanel.this.fillOutput();
            }
        });
        this.btnModifySearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewPanel.this.customizeCriteria();
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Manager.getInstance().stopSearching(ResultViewPanel.this.getTask());
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultViewPanel.this.replaceMatches();
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_STOP"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDetails, (String)NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_FILL"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReplace, (String)NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnModifySearch, (String)NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.btnStop.setEnabled(false);
        this.btnShowDetails.setEnabled(false);
        this.btnReplace.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.btnReplace);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.btnShowDetails);
        jPanel.add(this.btnModifySearch);
        jPanel.add(this.btnStop);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        this.add((Component)this.toolBar, this.getToolbarConstraints());
        this.add((Component)this.toolbarSeparator, this.getToolbarSeparatorConstraints());
        this.add((Component)this.resultsPanel, this.getMainPanelConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 7;
        this.add((Component)jPanel, gridBagConstraints);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.initAccessibility();
        this.resultModelChanged();
        if (isMacLaf) {
            this.tree.setBackground(macBackground);
            this.treeView.setBackground(macBackground);
            this.toolBar.setBackground(macBackground);
            this.resultsPanel.setBackground(macBackground);
            jPanel.setBackground(macBackground);
        }
    }

    ResultModel getResultModel() {
        return this.resultModel;
    }

    void setResultModel(ResultModel resultModel) {
        boolean bl = this.resultModel != null && this.resultModel.searchAndReplace;
        boolean bl2 = resultModel != null && resultModel.searchAndReplace;
        this.resultModel = resultModel;
        this.basicSearchCriteria = resultModel.basicCriteria;
        this.searchTypes = Arrays.asList(resultModel.getSearchGroup().getSearchTypes());
        this.searchScopeType = resultModel.getSearchGroup().getSearchScope().getTypeId();
        this.treeModel = new ResultTreeModel(resultModel);
        this.tree.setModel(this.treeModel);
        if (bl2 != bl) {
            this.tree.setCellRenderer(new NodeRenderer(bl2));
            this.setBtnReplaceVisible(bl2);
        }
        if (resultModel != null) {
            this.hasResults = !resultModel.isEmpty();
            this.hasDetails = this.hasResults && resultModel.hasDetails();
            resultModel.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
        }
        this.resultModelChanged();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ResultView.class);
        AccessibleContext accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_VerticalScrollbar"));
        accessibleContext = this.treeView.getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_ResultTree"));
        accessibleContext.setAccessibleDescription(resourceBundle.getString("ACSD_ResultTree"));
        this.btnReplace.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_REPLACE"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintTask(new PrintDetailsTask(this.resultModel.getFoundObjects(), this.basicSearchCriteria, this.searchTypes));
    }

    private synchronized void updateObjectsCount(int n) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null) {
            return;
        }
        ++this.objectsCount;
        this.hasResults = true;
        this.setRootDisplayName(this.resultModel.isBasicCriteriaOnly && this.resultModel.basicCriteria.isFullText() ? this.nodeCountFormatFullText.format(new Object[]{new Integer(this.objectsCount), new Integer(n)}) : this.nodeCountFormat.format(new Object[]{new Integer(this.objectsCount)}));
    }

    void objectFound(Object object, final int n) {
        assert (!EventQueue.isDispatchThread());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultViewPanel.this.updateObjectsCount(n);
            }
        });
    }

    void rememberInput(String string, BasicSearchCriteria basicSearchCriteria, List<SearchType> list) {
        this.searchScopeType = string;
        this.basicSearchCriteria = basicSearchCriteria;
        this.searchTypes = list;
    }

    void componentOpened() {
        if (this.searchScopeType == null) {
            this.setBtnModifyEnabled(false);
        }
    }

    void componentClosed() {
        this.rememberInput(null, null, null);
        if (this.contextView != null) {
            this.contextView.unbindFromTreeSelection(this.tree);
            this.contextView = null;
        }
        if (this.splitPane != null) {
            this.rememberDividerLocation();
            this.resultsPanel.remove(this.splitPane);
            this.splitPane = null;
        }
        this.contextViewVisible = false;
    }

    void resultModelChanged() {
        this.updateDisplayContextButton();
        this.updateContextViewVisibility();
        if (this.contextView != null) {
            this.contextView.setResultModel(this.resultModel);
        }
        this.nodeListener.setSelectionChangeEnabled(true);
        this.btnPrev.setEnabled(this.resultModel != null);
        this.btnNext.setEnabled(this.resultModel != null);
        this.resetMatchingObjIndexCache();
        this.objectsCount = 0;
    }

    private SearchTask getTask() {
        return this.task;
    }

    private void resetMatchingObjIndexCache() {
        this.matchingObjIndexCacheObj = null;
        this.matchingObjIndexCacheIndex = -1;
    }

    private ResultTreeModel createTreeModel() {
        ResultTreeModel resultTreeModel = new ResultTreeModel(null);
        resultTreeModel.setRootDisplayName(this.getInitialRootNodeText());
        return resultTreeModel;
    }

    private JTree createTree(ResultTreeModel resultTreeModel, NodeListener nodeListener, ArrowStatusUpdater arrowStatusUpdater) {
        JTree jTree = new JTree(resultTreeModel);
        NodeRenderer nodeRenderer = new NodeRenderer(false);
        jTree.setCellRenderer(nodeRenderer);
        jTree.setRowHeight(nodeRenderer.getTreeCellRendererComponent((JTree)jTree, (Object)resultTreeModel, (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height + 2);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        jTree.addMouseListener(nodeListener);
        jTree.addKeyListener(nodeListener);
        jTree.addTreeWillExpandListener(nodeListener);
        jTree.addTreeExpansionListener(nodeListener);
        jTree.setToggleClickCount(0);
        jTree.addMouseListener(arrowStatusUpdater);
        jTree.addKeyListener(arrowStatusUpdater);
        return jTree;
    }

    private String getInitialRootNodeText() {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    void setRootDisplayName(String string) {
        this.treeModel.setRootDisplayName(string);
    }

    private boolean isSearchAndReplace() {
        return this.resultModel != null && this.resultModel.searchAndReplace;
    }

    private void setFinalRootNodeText() {
        Object[] objectArray;
        String string;
        String string2;
        assert (EventQueue.isDispatchThread());
        int n = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)n, (Object)this.resultModel.getTotalDetailsCount()) + ' ' + this.resultModel.getLimitDisplayName());
            return;
        }
        if (n == 0) {
            string2 = NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND");
        } else {
            if (this.resultModel.searchAndReplace) {
                string = "TEXT_MSG_FOUND_X_NODES_REPLACE";
                objectArray = new Object[4];
            } else if (this.resultModel.isBasicCriteriaOnly && this.resultModel.basicCriteria.isFullText()) {
                string = "TEXT_MSG_FOUND_X_NODES_FULLTEXT";
                objectArray = new Object[2];
            } else {
                string = "TEXT_MSG_FOUND_X_NODES";
                objectArray = new Object[]{new Integer(this.objectsCount)};
            }
            if (objectArray.length > 1) {
                objectArray[1] = new Integer(this.resultModel.getTotalDetailsCount());
            }
            if (objectArray.length > 2) {
                objectArray[2] = this.resultModel.basicCriteria.getTextPatternExpr();
                objectArray[3] = this.resultModel.basicCriteria.getReplaceExpr();
            }
            string2 = NbBundle.getMessage(this.getClass(), (String)string, (Object[])objectArray);
        }
        string = this.resultModel.getExceptionMsg();
        objectArray = string == null ? string2 : string2 + " (" + string + ")";
        this.setRootDisplayName((String)objectArray);
    }

    boolean isSearchInProgress() {
        return this.searchInProgress;
    }

    void updateShowAllDetailsBtn() {
        assert (EventQueue.isDispatchThread());
        if (this.hasResults && !this.searchInProgress) {
            this.tree.setSelectionPath(new TreePath(this.tree.getModel().getRoot()));
        }
        this.setBtnShowDetailsEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    void searchStarted() {
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"TXT_RootSearchedNodes"));
        this.nodeCountFormatFullText = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"TXT_RootSearchedNodesFulltext"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.setBtnModifyEnabled(true);
        this.setBtnStopEnabled(true);
        this.setBtnReplaceEnabled(false);
        this.arrowUpdater.update();
    }

    void searchFinished() {
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.resultModel != null ? this.resultModel.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.setBtnStopEnabled(false);
        this.setBtnReplaceEnabled(true);
        this.arrowUpdater.update();
    }

    void searchInterrupted() {
        this.searchFinished();
    }

    void searchCancelled() {
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.setBtnStopEnabled(false);
        this.setBtnReplaceEnabled(true);
        this.arrowUpdater.update();
    }

    void displayIssues(IssuesPanel issuesPanel) {
        if (issuesPanel != null) {
            this.issuesPanel = issuesPanel;
            this.remove(this.toolBar);
            this.remove(this.toolbarSeparator);
            this.remove(this.resultsPanel);
            this.add((Component)issuesPanel, this.getMainPanelConstraints());
            this.validate();
            this.repaint();
        }
    }

    void removeIssuesPanel() {
        if (this.issuesPanel != null) {
            this.remove(this.issuesPanel);
            this.add((Component)this.toolBar, this.getToolbarConstraints());
            this.add((Component)this.toolbarSeparator, this.getToolbarSeparatorConstraints());
            this.add((Component)this.resultsPanel, this.getMainPanelConstraints());
            this.issuesPanel = null;
            this.validate();
            this.repaint();
        }
    }

    private GridBagConstraints getMainPanelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    private GridBagConstraints getToolbarConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    private GridBagConstraints getToolbarSeparatorConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayContextButton() {
        boolean bl = this.isSearchAndReplace();
        this.btnDisplayContext.setVisible(bl);
        this.sepDisplayContext.setVisible(bl);
        this.ignoreContextButtonToggle = true;
        try {
            this.btnDisplayContext.setSelected(bl && this.contextViewEnabled);
        }
        finally {
            this.ignoreContextButtonToggle = false;
        }
    }

    private void updateContextViewVisibility() {
        this.setContextViewVisible(this.isSearchAndReplace() && this.contextViewEnabled);
    }

    private void setContextViewVisible(boolean bl) {
        String string;
        assert (EventQueue.isDispatchThread());
        assert (this.splitPane == null == (this.contextView == null));
        int n = this.resultsPanel.getComponentCount();
        if (bl == this.contextViewVisible && n != 0) {
            return;
        }
        this.contextViewVisible = bl;
        if (!bl) {
            string = "tree only";
            assert (n < 2);
            this.resultsPanel.add((Component)this.treeView, string);
            if (this.contextView != null) {
                this.contextView.unbindFromTreeSelection(this.tree);
                this.rememberDividerLocation();
            }
        } else {
            assert (this.resultModel != null);
            string = "tree and context";
            if (this.splitPane == null) {
                this.contextView = new ContextView(this.resultModel);
                this.splitPane = new JSplitPane(1, true, this.treeView, this.contextView);
                this.splitPane.setBorder(BorderFactory.createEmptyBorder());
                this.splitPane.setResizeWeight(0.4);
                if (isMacLaf) {
                    this.contextView.setBackground(macBackground);
                    this.splitPane.setBackground(macBackground);
                }
                this.resultsPanel.add((Component)this.splitPane, string);
            } else {
                this.splitPane.setLeftComponent(this.treeView);
            }
            this.setDividerLocation();
            this.contextView.bindToTreeSelection(this.tree);
        }
        this.resultViewCards.show(this.resultsPanel, string);
        this.treeView.setVisible(true);
    }

    void goToNext(boolean bl) {
        TreePath treePath;
        assert (EventQueue.isDispatchThread());
        assert (this.resultModel != null);
        if (!this.hasResults) {
            return;
        }
        TreePath treePath2 = this.tree.getLeadSelectionPath();
        if (treePath2 == null) {
            treePath2 = new TreePath(this.tree.getModel().getRoot());
        }
        if ((treePath = this.findNextPath(treePath2, bl)) != null) {
            this.tree.expandPath(treePath.getParentPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollRectToVisible(this.tree.getPathBounds(treePath));
            this.arrowUpdater.update();
            this.goToDetail(treePath);
        }
    }

    private void goToDetail(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object != null && object instanceof TextDetail.DetailNode) {
            TextDetail.DetailNode detailNode = (TextDetail.DetailNode)((Object)object);
            detailNode.gotoDetail();
        }
    }

    private TreePath findNextPath(TreePath treePath, boolean bl) {
        TreePath treePath2;
        TreePath treePath3 = treePath.getParentPath();
        if (treePath3 == null) {
            Object object = treePath.getLastPathComponent();
            treePath2 = bl ? this.getNextDetail(object, null, -1, bl) : null;
        } else {
            Object object = treePath.getLastPathComponent();
            if (object.getClass() == MatchingObject.class) {
                Object object2 = treePath3.getLastPathComponent();
                MatchingObject matchingObject = (MatchingObject)object;
                treePath2 = this.getNextDetail(object2, matchingObject, -1, bl);
            } else {
                Object object3 = treePath3.getParentPath().getLastPathComponent();
                Object object4 = treePath3.getLastPathComponent();
                assert (object4.getClass() == MatchingObject.class);
                MatchingObject matchingObject = (MatchingObject)object4;
                int n = this.tree.getRowForPath(treePath3);
                int n2 = this.tree.getRowForPath(treePath);
                int n3 = n2 - n - 1;
                treePath2 = this.getNextDetail(object3, matchingObject, n3, bl);
            }
        }
        return treePath2;
    }

    private TreePath getNextDetail(Object object, MatchingObject matchingObject, int n, boolean bl) {
        if (matchingObject != null) {
            int n2;
            int n3 = n2 = bl ? n + 1 : n - 1;
            if (n2 >= 0 && n2 < this.resultModel.getDetailsCount(matchingObject)) {
                return new TreePath(new Object[]{object, matchingObject, this.resultModel.getDetails(matchingObject)[n2]});
            }
        } else if (!bl) {
            return null;
        }
        MatchingObject[] matchingObjectArray = this.resultModel.getMatchingObjects();
        int n4 = this.getMatchingObjIndex(matchingObjectArray, matchingObject, bl);
        if (bl) {
            for (int i = n4 + 1; i < matchingObjectArray.length; ++i) {
                MatchingObject matchingObject2 = matchingObjectArray[i];
                if (!this.resultModel.hasDetails(matchingObject2)) continue;
                return new TreePath(new Object[]{object, matchingObject2, this.resultModel.getDetails(matchingObject2)[0]});
            }
        } else {
            for (int i = n4 - 1; i >= 0; --i) {
                MatchingObject matchingObject3 = matchingObjectArray[i];
                if (!this.resultModel.hasDetails(matchingObject3)) continue;
                Node[] nodeArray = this.resultModel.getDetails(matchingObject3);
                return new TreePath(new Object[]{object, matchingObject3, nodeArray[nodeArray.length - 1]});
            }
        }
        return null;
    }

    private int getMatchingObjIndex(MatchingObject[] matchingObjectArray, MatchingObject matchingObject, boolean bl) {
        if (matchingObject == null) {
            return -1;
        }
        if (matchingObject == this.matchingObjIndexCacheObj) {
            assert (this.matchingObjIndexCacheIndex != -1);
            return this.matchingObjIndexCacheIndex;
        }
        int n = -1;
        if (this.matchingObjIndexCacheIndex != -1) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = Math.min(this.matchingObjIndexCacheIndex + 1, matchingObjectArray.length - 1);
                n3 = Math.min(this.matchingObjIndexCacheIndex + 3, matchingObjectArray.length - 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    if (matchingObjectArray[n2] != matchingObject) continue;
                    n = n2;
                    break;
                }
                if (n == -1 && this.matchingObjIndexCacheIndex > 0 && matchingObjectArray[n2 = this.matchingObjIndexCacheIndex - 1] == matchingObject) {
                    n = n2;
                }
            } else {
                n4 = Math.max(this.matchingObjIndexCacheIndex - 1, 0);
                n3 = Math.max(this.matchingObjIndexCacheIndex - 3, 0);
                for (n2 = n4; n2 >= n3; --n2) {
                    if (matchingObjectArray[n2] != matchingObject) continue;
                    n = n2;
                    break;
                }
                if (n == -1 && this.matchingObjIndexCacheIndex < matchingObjectArray.length - 1 && matchingObjectArray[n2 = this.matchingObjIndexCacheIndex + 1] == matchingObject) {
                    n = n2;
                }
            }
        }
        if (n == -1) {
            for (int i = 0; i < matchingObjectArray.length; ++i) {
                if (matchingObject != matchingObjectArray[i]) continue;
                n = i;
                break;
            }
        }
        if (n != -1) {
            this.matchingObjIndexCacheObj = matchingObject;
            this.matchingObjIndexCacheIndex = n;
        }
        return n;
    }

    private static List<SearchType> cloneAvailableSearchTypes(List<SearchType> list) {
        Collection<? extends SearchType> collection = Utils.getSearchTypes();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (SearchType object : collection) {
            arrayList.add(object.getClass().getName());
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList2 = new ArrayList(list.size());
        for (SearchType searchType : list) {
            if (!arrayList.contains(searchType.getClass().getName())) continue;
            arrayList2.add((SearchType)searchType.clone());
        }
        return arrayList2;
    }

    private void customizeCriteria() {
        assert (EventQueue.isDispatchThread());
        BasicSearchCriteria basicSearchCriteria = this.basicSearchCriteria != null ? new BasicSearchCriteria(this.basicSearchCriteria) : new BasicSearchCriteria();
        List<SearchType> list = ResultViewPanel.cloneAvailableSearchTypes(this.searchTypes);
        SearchPanel searchPanel = new SearchPanel(SearchScopeRegistry.getDefault().getSearchScopes(), this.searchScopeType, basicSearchCriteria, list);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        SearchScope searchScope = searchPanel.getSearchScope();
        this.searchScopeType = searchScope.getTypeId();
        this.basicSearchCriteria = searchPanel.getBasicSearchCriteria();
        this.searchTypes = searchPanel.getSearchTypes();
        Manager.getInstance().stopSearching(this.task);
        this.task = new SearchTask(searchScope, this.basicSearchCriteria, searchPanel.getCustomizedSearchTypes());
        ResultView.getInstance().addSearchPair(this, this.task);
        Manager.getInstance().scheduleSearchTask(this.task);
    }

    private void replaceMatches() {
        assert (EventQueue.isDispatchThread());
        this.nodeListener.setSelectionChangeEnabled(false);
        this.btnReplace.setEnabled(false);
        ReplaceTask replaceTask = new ReplaceTask(this.resultModel.getMatchingObjects());
        ResultView.getInstance().addReplacePair(replaceTask, this);
        Manager.getInstance().scheduleReplaceTask(replaceTask);
    }

    void setBtnModifyEnabled(boolean bl) {
        this.btnModifySearch.setEnabled(bl);
    }

    void setBtnStopEnabled(boolean bl) {
        this.btnStop.setEnabled(bl);
    }

    void setBtnReplaceEnabled(boolean bl) {
        this.btnReplace.setEnabled(bl && !this.basicSearchCriteria.isReplacePatternInvalid());
    }

    void setBtnShowDetailsEnabled(boolean bl) {
        this.btnShowDetails.setEnabled(bl);
    }

    void setBtnReplaceVisible(boolean bl) {
        this.btnReplace.setVisible(bl);
    }

    private void rememberDividerLocation() {
        if (this.splitPane == null) {
            return;
        }
        this.dividerLocation = (double)this.splitPane.getDividerLocation() / (double)(this.splitPane.getWidth() - this.splitPane.getDividerSize());
    }

    private void setDividerLocation() {
        assert (this.splitPane != null);
        if (this.dividerLocation != -1.0) {
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    private class ArrowStatusUpdater
    implements KeyListener,
    MouseListener {
        private ResultViewPanel resultViewPanel;

        public ArrowStatusUpdater(ResultViewPanel resultViewPanel2) {
            this.resultViewPanel = resultViewPanel2;
        }

        private void update() {
            if (ResultViewPanel.this.resultModel == null || ResultViewPanel.this.tree == null) {
                return;
            }
            if (!this.resultViewPanel.hasResults) {
                ResultViewPanel.this.btnPrev.setEnabled(false);
                ResultViewPanel.this.btnNext.setEnabled(false);
            } else {
                TreePath treePath = ResultViewPanel.this.tree.getLeadSelectionPath();
                if (treePath == null) {
                    ResultViewPanel.this.btnPrev.setEnabled(false);
                    ResultViewPanel.this.btnNext.setEnabled(true);
                } else {
                    ResultViewPanel.this.btnPrev.setEnabled(ResultViewPanel.this.findNextPath(treePath, false) != null);
                    ResultViewPanel.this.btnNext.setEnabled(ResultViewPanel.this.findNextPath(treePath, true) != null);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10 || n == 32 || n == 38 || n == 40 || n == 37 || n == 39) {
                this.update();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.update();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

