/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final int REPOSITORY_STATUS_UNKNOWN = 0;
    public static final int REPOSITORY_STATUS_UPDATED = 85;
    public static final int REPOSITORY_STATUS_PATCHED = 80;
    public static final int REPOSITORY_STATUS_MODIFIED = 77;
    public static final int REPOSITORY_STATUS_CONFLICT = 67;
    public static final int REPOSITORY_STATUS_MERGEABLE = 71;
    public static final int REPOSITORY_STATUS_ADDED = 65;
    public static final int REPOSITORY_STATUS_REMOVED = 82;
    public static final int REPOSITORY_STATUS_REMOVED_REMOTELY = 89;
    public static final int REPOSITORY_STATUS_UPTODATE = 65536;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private final CvsVersioningSystem cvs;
    private final CvsLiteAdminHandler sah;
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private final List<RefreshRequest> refreshRequests = new ArrayList<RefreshRequest>(10);
    private final RequestProcessor.Task refreshRequestsTask;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache(CvsVersioningSystem cvsVersioningSystem) {
        this.cvs = cvsVersioningSystem;
        this.refreshRequestsTask = org.netbeans.modules.versioning.util.Utils.createTask((Runnable)new RefreshRequestRunnable());
        this.sah = (CvsLiteAdminHandler)this.cvs.getAdminHandler();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    private File[] listFiles(File file) {
        Set<File> set = this.getScannedFiles(file).keySet();
        return set.toArray(new File[set.size()]);
    }

    public File[] listFiles(Context context, int n) {
        Object object;
        Object object2;
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : map.keySet()) {
            object2 = map.get(file);
            if (((FileInformation)object2).isDirectory() || (((FileInformation)object2).getStatus() & n) == 0) continue;
            object = context.getRootFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                File file2 = object[i];
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!Utils.isParentOrEqual(file2, file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        if (context.getExclusions().size() > 0) {
            for (File file : context.getExclusions()) {
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (File)object2.next();
                    if (!Utils.isParentOrEqual(file, (File)object)) continue;
                    object2.remove();
                }
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public FileInformation getStatus(File file) {
        if (file == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "File shouldn't be null");
            return FILE_INFORMATION_NOTMANAGED;
        }
        if (file.getName().equals("CVS")) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, 0);
        }
        return new FileInformation(8, false);
    }

    public void refresh(File file, int n, boolean bl) {
        this.refreshLater(new RefreshRequest(file, n, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLater(RefreshRequest refreshRequest) {
        List<RefreshRequest> list = this.refreshRequests;
        synchronized (list) {
            this.refreshRequests.add(refreshRequest);
        }
        this.refreshRequestsTask.schedule(777);
    }

    public FileInformation refreshNow(File file, int n, boolean bl) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        Entry entry = null;
        try {
            entry = this.cvs.getAdminHandler().getEntry(file);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        FileInformation fileInformation2 = this.createFileInformation(file, entry, n);
        if ((fileInformation2.getStatus() & 0x6A0) == 0 && n == 0 && fileInformation != null && (fileInformation.getStatus() & 0x6A0) != 0) {
            fileInformation2 = (fileInformation2.getStatus() & 0x19D4) != 0 ? new FileInformation(128, fileInformation2.isDirectory()) : (fileInformation.getStatus() == 128 ? new FileInformation(32, fileInformation.isDirectory()) : fileInformation);
        }
        if (FileStatusCache.equivalent(fileInformation2, fileInformation)) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        if (fileInformation == null && !fileInformation2.isDirectory() && fileInformation2.getStatus() == 8) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
        if (fileInformation2.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", null);
        } else if (fileInformation2.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation2);
        }
        this.turbo.writeEntry((Object)file2, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        if (file.isDirectory() && this.needRecursiveRefresh(fileInformation2, fileInformation)) {
            File[] fileArray = this.listFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.refresh(fileArray[i], 0);
            }
        }
        this.fireFileStatusChanged(file, fileInformation, fileInformation2);
        return fileInformation2;
    }

    public FileInformation refresh(File file, int n) {
        return this.refreshNow(file, n, false);
    }

    FileInformation createFileInformation(File file) {
        Entry entry = null;
        try {
            entry = this.cvs.getAdminHandler().getEntry(file);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return this.createFileInformation(file, entry, 0);
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        Entry entry;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        Entry entry2 = fileInformation.getEntry(null);
        return entry2 == (entry = fileInformation2.getEntry(null)) || entry2 == null || entry == null || FileStatusCache.equal(entry2, entry);
    }

    private static boolean equal(Entry entry, Entry entry2) {
        if (!entry.getRevision().equals(entry2.getRevision())) {
            return false;
        }
        return entry.getStickyInformation() == entry2.getStickyInformation() || entry.getStickyInformation() != null && entry.getStickyInformation().equals(entry2.getStickyInformation());
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        return fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1;
    }

    public void refreshCached(File file, int n) {
        this.refresh(file, n);
    }

    public void clearVirtualDirectoryContents(File file, boolean bl, File[] fileArray) {
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
            File file2 = entry.getKey();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (Utils.isParentOrEqual(fileArray[i], file2)) continue block0;
                }
            }
            if (!Utils.isParentOrEqual(file, file2) || !bl && !file.equals(file2.getParentFile())) continue;
            this.refresh(file2, 0);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File file) {
        Map map = (Map)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (map != null) {
            for (File file2 : map.keySet()) {
                this.refresh(file2, 0, false);
            }
        }
    }

    private Map<File, FileInformation> getScannedFiles(File file) {
        if (file.getName().equals("CVS")) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> map = (Map<File, FileInformation>)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (map != null) {
            return map;
        }
        if (!file.exists()) {
            return NOT_MANAGED_MAP;
        }
        file = FileUtil.normalizeFile((File)file);
        map = this.scanFolder(file);
        this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", map);
        for (File file2 : map.keySet()) {
            FileInformation fileInformation = map.get(file2);
            if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
            this.fireFileStatusChanged(file2, null, fileInformation);
        }
        return map;
    }

    private Map<File, FileInformation> scanFolder(File file) {
        Serializable serializable;
        Object object;
        File file2;
        int n;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(fileArray.length);
        Entry[] entryArray = null;
        try {
            entryArray = this.sah.getEntriesAsArray(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (n = 0; n < fileArray.length; ++n) {
            Entry entry;
            file2 = fileArray[n];
            object = file2.getName();
            if (((String)object).equals("CVS") || !(serializable = this.createFileInformation(file2, entry = this.getEntry(file, entryArray, file2), 0)).isDirectory() && serializable.getStatus() == 8) continue;
            hashMap.put(file2, (FileInformation)serializable);
        }
        if (entryArray != null) {
            block3: for (n = 0; n < entryArray.length; ++n) {
                file2 = entryArray[n];
                object = new File(file, file2.getName());
                for (int i = 0; i < fileArray.length; ++i) {
                    serializable = fileArray[i];
                    if (((File)object).equals(serializable)) continue block3;
                }
                FileInformation fileInformation = this.createFileInformation((File)object, (Entry)file2, 0);
                hashMap.put((File)object, fileInformation);
            }
        }
        return hashMap;
    }

    private Entry getEntry(File file, Entry[] entryArray, File file2) {
        if (entryArray != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                File file3 = new File(file, entry.getName());
                if (!file2.equals(file3)) continue;
                return entry;
            }
        }
        return null;
    }

    private FileInformation createFileInformation(File file, Entry entry, int n) {
        if (entry == null) {
            if (!CvsVersioningSystem.isManaged(file)) {
                if (file.exists()) {
                    return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
                }
                return FILE_INFORMATION_UNKNOWN;
            }
            return this.createMissingEntryFileInformation(file, n);
        }
        this.cvs.setNotUnignored(file);
        return this.createVersionedFileInformation(entry, file, n);
    }

    private FileInformation createVersionedFileInformation(Entry entry, File file, int n) {
        if (entry.isDirectory()) {
            if (file.exists()) {
                if (new File(file, "CVS").isDirectory()) {
                    return FILE_INFORMATION_UPTODATE_DIRECTORY;
                }
                return new FileInformation(4, true);
            }
            return new FileInformation(2048, true);
        }
        if (entry.isNewUserFile()) {
            return new FileInformation(4096, entry, false);
        }
        if (entry.isUserFileToBeRemoved()) {
            return new FileInformation(256, entry, false);
        }
        if (!this.exists(file)) {
            return new FileInformation(2048, entry, false);
        }
        if (n == 65536) {
            if (!this.entryTimestampMatches(entry, file)) {
                entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(file.lastModified())));
                try {
                    this.sah.setEntry(file, entry);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            return new FileInformation(8, entry, false);
        }
        if (n == 85 || n == 80) {
            return new FileInformation(32, entry, false);
        }
        if (n == 77) {
            FileInformation fileInformation = new FileInformation(16, entry, false);
            return fileInformation;
        }
        if (n == 67) {
            if (this.isLocalConflict(entry, file)) {
                return new FileInformation(64, entry, false);
            }
            return new FileInformation(128, entry, false);
        }
        if (n == 71) {
            return new FileInformation(128, entry, false);
        }
        if (n == 89) {
            return new FileInformation(1024, entry, false);
        }
        if (n == 0 || n == 63) {
            if (this.exists(file)) {
                if (this.isLocalConflict(entry, file)) {
                    return new FileInformation(64, entry, false);
                }
                if (this.entryTimestampMatches(entry, file)) {
                    return new FileInformation(8, entry, false);
                }
                FileInformation fileInformation = new FileInformation(16, entry, false);
                return fileInformation;
            }
            return new FileInformation(2048, entry, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)n);
    }

    private boolean isLocalConflict(Entry entry, File file) {
        return this.exists(file) && entry.hadConflicts() && this.entryTimestampMatches(entry, file);
    }

    private FileInformation createMissingEntryFileInformation(File file, int n) {
        boolean bl = file.isDirectory();
        int n2 = this.getStatus(file.getParentFile()).getStatus();
        if (n2 == 2) {
            return bl ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (n2 == 1) {
            if (bl) {
                return this.isInsideCvsMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        if (n == 65 && bl) {
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        if (n == 0 || n == 63) {
            if (this.exists(file)) {
                if (this.cvs.isIgnored(file)) {
                    return bl ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
                }
                return new FileInformation(4, bl);
            }
            return new FileInformation(0, false);
        }
        if (n == 85) {
            if (file.exists()) {
                return new FileInformation(64, bl);
            }
            return new FileInformation(512, bl);
        }
        if (n == 65536) {
            if (n2 == 4) {
                return new FileInformation(4, bl);
            }
            if (this.exists(file) && Utils.getSticky(file) != null) {
                return new FileInformation(4, bl);
            }
            return this.cvs.isUnignored(file) ? new FileInformation(4, bl) : new FileInformation(2, bl);
        }
        if (n == 89) {
            if (this.exists(file)) {
                return new FileInformation(4, bl);
            }
            return FILE_INFORMATION_UNKNOWN;
        }
        if (n == 67) {
            return new FileInformation(64, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)n + " for: " + file.getAbsolutePath());
    }

    private boolean isInsideCvsMetadata(File file) {
        return file.getAbsolutePath().indexOf(File.separator + "CVS" + File.separator) != -1;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    private boolean entryTimestampMatches(Entry entry, File file) {
        Date date = entry.getLastModified();
        if (date == null) {
            return false;
        }
        long l = date.getTime();
        long l2 = file.lastModified() / 1000L * 1000L;
        if (TimeZone.getDefault().inDaylightTime(entry.getLastModified())) {
            l2 -= (long)TimeZone.getDefault().getDSTSavings();
        }
        return l == l2 || l - l2 == 3600000L || l2 - l == 3600000L;
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, fileInformation, fileInformation2});
    }

    public FileInformation getCachedStatus(File file) {
        if ((file = file.getParentFile()) == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map map = (Map)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        return map != null ? (FileInformation)map.get(file) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }
    }

    private class RefreshRequest {
        final File file;
        final int repositoryStatus;
        final boolean forceChangeEvent;

        RefreshRequest(File file, int n, boolean bl) {
            this.file = file;
            this.repositoryStatus = n;
            this.forceChangeEvent = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshRequestRunnable
    implements Runnable {
        private RefreshRequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<RefreshRequest> arrayList;
            List list = FileStatusCache.this.refreshRequests;
            synchronized (list) {
                arrayList = new ArrayList<RefreshRequest>(FileStatusCache.this.refreshRequests);
                FileStatusCache.this.refreshRequests.clear();
            }
            this.refresh(arrayList);
        }

        private void refresh(List<RefreshRequest> list) {
            for (RefreshRequest refreshRequest : list) {
                FileStatusCache.this.refreshNow(refreshRequest.file, refreshRequest.repositoryStatus, refreshRequest.forceChangeEvent);
            }
        }
    }
}

