/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncTable;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SynchronizePanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
PreferenceChangeListener,
VersioningListener,
ActionListener {
    private ExplorerManager explorerManager;
    private final CvsSynchronizeTopComponent parentTopComponent;
    private final CvsVersioningSystem cvs;
    private Context context;
    private int displayStatuses;
    private boolean pendingRefresh;
    private SyncTable syncTable;
    private RequestProcessor.Task refreshViewTask;
    private ExecutorGroup refreshCommandGroup;
    private static final RequestProcessor rp = new RequestProcessor("CVS-VersioningView", 1);
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnRefresh;
    private JButton btnUpdate;
    private JToolBar jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JToggleButton tgbAll;
    private JToggleButton tgbLocal;
    private JToggleButton tgbRemote;

    public SynchronizePanel(CvsSynchronizeTopComponent cvsSynchronizeTopComponent) {
        this.parentTopComponent = cvsSynchronizeTopComponent;
        this.cvs = CvsVersioningSystem.getInstance();
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.explorerManager = new ExplorerManager();
        this.displayStatuses = 8180;
        this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_All"));
        this.syncTable = new SyncTable();
        this.initComponents();
        this.setComponentsState();
        this.setVersioningComponent(this.syncTable.getComponent());
        this.reScheduleRefresh(0);
        this.jPanel2.setFloatable(false);
        this.jPanel2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jPanel2.setLayout(new ToolbarLayout());
        cvsSynchronizeTopComponent.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        cvsSynchronizeTopComponent.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        cvsSynchronizeTopComponent.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        cvsSynchronizeTopComponent.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.parentTopComponent.getActionMap().put("NextViewAction", new AbstractAction(""){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizePanel.this.onNextInnerView();
            }
        });
        this.parentTopComponent.getActionMap().put("PreviousViewAction", new AbstractAction(""){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizePanel.this.onPrevInnerView();
            }
        });
    }

    private void onPrevInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbRemote.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbAll.setSelected(true);
        } else {
            this.tgbLocal.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbAll.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbLocal.setSelected(true);
        } else {
            this.tgbRemote.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (topComponent == null) {
                return;
            }
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    CvsVersioningSystem getCvs() {
        return this.cvs;
    }

    void setContext(Context context) {
        this.context = context;
        this.reScheduleRefresh(0);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void addNotify() {
        super.addNotify();
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.cvs.getStatusCache().addVersioningListener(this);
        this.cvs.addVersioningListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.reScheduleRefresh(0);
    }

    public void removeNotify() {
        CvsModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.cvs.getStatusCache().removeVersioningListener(this);
        this.cvs.removeVersioningListener(this);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    private void setVersioningComponent(JComponent jComponent) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == this.jPanel2) continue;
            if (component == jComponent) {
                return;
            }
            this.remove(component);
            break;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jComponent, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    private void setComponentsState() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.tgbLocal);
        buttonGroup.add(this.tgbRemote);
        buttonGroup.add(this.tgbAll);
        if (this.displayStatuses == 6612) {
            this.tgbLocal.setSelected(true);
        } else if (this.displayStatuses == 1696) {
            this.tgbRemote.setSelected(true);
        } else {
            this.tgbAll.setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupModels() {
        ProgressHandle progressHandle;
        block12: {
            block10: {
                if (this.context == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SynchronizePanel.this.syncTable.setTableModel(new SyncFileNode[0]);
                        }
                    });
                    return;
                }
                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_Refreshing_Versioning_View"));
                try {
                    String string;
                    String[] stringArray;
                    progressHandle.start();
                    final SyncFileNode[] syncFileNodeArray = this.getNodes(this.cvs.getFileTableModel(this.context, this.displayStatuses));
                    if (syncFileNodeArray == null) {
                        Object var10_3 = null;
                        break block10;
                    }
                    if (syncFileNodeArray.length > 0) {
                        boolean bl = true;
                        String string2 = syncFileNodeArray[0].getSticky();
                        for (int i = 1; i < syncFileNodeArray.length; ++i) {
                            if (Thread.interrupted()) {
                                Object var10_4 = null;
                                SwingUtilities.invokeLater(new Runnable(progressHandle){
                                    final /* synthetic */ ProgressHandle val$ph;
                                    {
                                        this.val$ph = progressHandle;
                                    }

                                    public void run() {
                                        this.val$ph.finish();
                                    }
                                });
                                return;
                            }
                            String string3 = syncFileNodeArray[i].getSticky();
                            if (string3 == string2 || string3 != null && string2 != null && string3.equals(string2)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            stringArray = new String[]{"name", "status", "path"};
                            string = string2.length() == 0 ? null : NbBundle.getMessage(SynchronizePanel.class, (String)"CTL_VersioningView_BranchTitle_Single", (Object)string2);
                        } else {
                            stringArray = new String[]{"name", "sticky", "status", "path"};
                            string = NbBundle.getMessage(SynchronizePanel.class, (String)"CTL_VersioningView_BranchTitle_Multi");
                        }
                    } else {
                        stringArray = null;
                        string = null;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (syncFileNodeArray.length > 0) {
                                SynchronizePanel.this.syncTable.setColumns(stringArray);
                                SynchronizePanel.this.parentTopComponent.setBranchTitle(string);
                                SynchronizePanel.this.setVersioningComponent(SynchronizePanel.this.syncTable.getComponent());
                            } else {
                                SynchronizePanel.this.setVersioningComponent((JComponent)SynchronizePanel.this.noContentComponent);
                            }
                            SynchronizePanel.this.syncTable.setTableModel(syncFileNodeArray);
                        }
                    });
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_6 = null;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        Object var10_5 = null;
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private SyncFileNode[] getNodes(CvsFileTableModel cvsFileTableModel) {
        CvsFileNode[] cvsFileNodeArray = cvsFileTableModel.getNodes();
        SyncFileNode[] syncFileNodeArray = new SyncFileNode[cvsFileNodeArray.length];
        for (int i = 0; i < cvsFileNodeArray.length; ++i) {
            if (Thread.interrupted()) {
                return null;
            }
            CvsFileNode cvsFileNode = cvsFileNodeArray[i];
            syncFileNodeArray[i] = new SyncFileNode(cvsFileNode);
        }
        return syncFileNodeArray;
    }

    private void onCommitAction() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.invokeCommit(this.parentTopComponent.getContentTitle(), this.context, null);
    }

    private void onUpdateAction() {
        this.executeUpdateCommand(false);
    }

    private void onRefreshAction() {
        LifecycleManager.getDefault().saveAll();
        this.refreshStatuses();
    }

    void performRefreshAction() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        this.executeUpdateCommand(true);
        this.reScheduleRefresh(1000);
    }

    private void onDiffAction() {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage(SynchronizePanel.class, (String)"BK0003"));
        executorGroup.progress(NbBundle.getMessage(SynchronizePanel.class, (String)"BK0004"));
        DiffExecutor diffExecutor = new DiffExecutor(this.context, this.parentTopComponent.getContentTitle());
        if (this.displayStatuses == 6612) {
            LifecycleManager.getDefault().saveAll();
            diffExecutor.showLocalDiff(executorGroup);
        } else if (this.displayStatuses == 1696) {
            diffExecutor.showRemoteDiff(executorGroup);
        } else {
            LifecycleManager.getDefault().saveAll();
            diffExecutor.showAllDiff(executorGroup);
        }
    }

    private void executeUpdateCommand(boolean bl) {
        if (this.context == null || this.context.getRootFiles().length == 0) {
            return;
        }
        UpdateCommand updateCommand = new UpdateCommand();
        String string = bl ? NbBundle.getMessage(SynchronizePanel.class, (String)"BK0001") : NbBundle.getMessage(SynchronizePanel.class, (String)"BK0002");
        updateCommand.setDisplayName(string);
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        updateCommand.setFiles(this.context.getRootFiles());
        updateCommand.setBuildDirectories(true);
        updateCommand.setPruneDirectories(true);
        globalOptions.setDoNoChanges(bl);
        this.refreshCommandGroup = new ExecutorGroup(string);
        this.refreshCommandGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, this.cvs, globalOptions, this.parentTopComponent.getContentTitle()));
        final long l = System.currentTimeMillis();
        this.refreshCommandGroup.addBarrier(new Runnable(){

            public void run() {
                if (!SynchronizePanel.this.refreshCommandGroup.isFailed()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SynchronizePanel.this.parentTopComponent.contentRefreshed(l);
                        }
                    });
                }
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SynchronizePanel.this.refreshCommandGroup.execute();
            }
        });
    }

    private void onDisplayedStatusChanged() {
        if (this.tgbLocal.isSelected()) {
            this.setDisplayStatuses(6612);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_Local"));
        } else if (this.tgbRemote.isSelected()) {
            this.setDisplayStatuses(1696);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_Remote"));
        } else if (this.tgbAll.isSelected()) {
            this.setDisplayStatuses(8180);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_All"));
        }
    }

    private void setDisplayStatuses(int n) {
        this.displayStatuses = n;
        this.reScheduleRefresh(0);
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(versioningEvent)) {
                return;
            }
            if (this.cvs.getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.reScheduleRefresh(1000);
            } else {
                this.reScheduleRefresh(200);
            }
        } else if (versioningEvent.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && this.pendingRefresh && versioningEvent.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && this.cvs.getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.pendingRefresh = false;
            this.reScheduleRefresh(0);
        }
    }

    private boolean affectsView(VersioningEvent versioningEvent) {
        File file = (File)versioningEvent.getParams()[0];
        FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
        FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
        if (fileInformation == null ? (fileInformation2.getStatus() & this.displayStatuses) == 0 : (fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        if (this.context != null) {
            return this.context.contains(file);
        }
        return false;
    }

    private void reScheduleRefresh(int n) {
        this.refreshViewTask.schedule(n);
    }

    void deserialize() {
        if (this.syncTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronizePanel.this.syncTable.setDefaultColumnSizes();
                }
            });
        }
    }

    void focus() {
        this.syncTable.focus();
    }

    public void cancelRefresh() {
        if (this.refreshCommandGroup != null) {
            this.refreshCommandGroup.cancel();
        }
        this.refreshViewTask.cancel();
    }

    private void initComponents() {
        this.jPanel2 = new JToolBar();
        this.tgbAll = new JToggleButton();
        this.tgbLocal = new JToggleButton();
        this.tgbRemote = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.btnRefresh = new JButton();
        this.btnDiff = new JButton();
        this.jPanel3 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCommit = new JButton();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/syncview/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.tgbAll, (String)resourceBundle.getString("CTL_Synchronize_Action_All_Label"));
        this.tgbAll.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_All_Tooltip"));
        this.tgbAll.addActionListener(this);
        this.jPanel2.add(this.tgbAll);
        Mnemonics.setLocalizedText((AbstractButton)this.tgbLocal, (String)resourceBundle.getString("CTL_Synchronize_Action_Local_Label"));
        this.tgbLocal.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Local_Tooltip"));
        this.tgbLocal.addActionListener(this);
        this.jPanel2.add(this.tgbLocal);
        Mnemonics.setLocalizedText((AbstractButton)this.tgbRemote, (String)resourceBundle.getString("CTL_Synchronize_Action_Remote_Label"));
        this.tgbRemote.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Remote_Tooltip"));
        this.tgbRemote.addActionListener(this);
        this.jPanel2.add(this.tgbRemote);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(2, 20));
        this.jPanel2.add(this.jSeparator1);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.btnRefresh.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Refresh_Tooltip"));
        this.btnRefresh.setActionCommand(resourceBundle.getString("CTL_Synchronize_TopComponent_Title"));
        this.btnRefresh.setPreferredSize(new Dimension(22, 23));
        this.btnRefresh.addActionListener(this);
        this.jPanel2.add(this.btnRefresh);
        this.btnDiff.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff.png")));
        this.btnDiff.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Diff_Tooltip"));
        this.btnDiff.setPreferredSize(new Dimension(22, 25));
        this.btnDiff.addActionListener(this);
        this.jPanel2.add(this.btnDiff);
        this.jPanel3.setOpaque(false);
        this.jPanel2.add(this.jPanel3);
        this.btnUpdate.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.btnUpdate.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Update_Tooltip"));
        this.btnUpdate.setActionCommand(resourceBundle.getString("CTL_Synchronize_TopComponent_Title"));
        this.btnUpdate.setPreferredSize(new Dimension(22, 25));
        this.btnUpdate.addActionListener(this);
        this.jPanel2.add(this.btnUpdate);
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.btnCommit.setToolTipText(resourceBundle.getString("CTL_CommitForm_Action_Commit_Tooltip"));
        this.btnCommit.setPreferredSize(new Dimension(22, 25));
        this.btnCommit.addActionListener(this);
        this.jPanel2.add(this.btnCommit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tgbAll) {
            this.tgbAllActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.tgbLocal) {
            this.tgbLocalActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.tgbRemote) {
            this.tgbRemoteActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnRefresh) {
            this.btnRefreshActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnDiff) {
            this.btnDiffActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnUpdate) {
            this.btnUpdateActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnCommit) {
            this.btnCommitActionPerformed(actionEvent);
        }
    }

    private void btnDiffActionPerformed(ActionEvent actionEvent) {
        this.onDiffAction();
    }

    private void tgbAllActionPerformed(ActionEvent actionEvent) {
        this.onDisplayedStatusChanged();
    }

    private void btnUpdateActionPerformed(ActionEvent actionEvent) {
        this.onUpdateAction();
    }

    private void tgbRemoteActionPerformed(ActionEvent actionEvent) {
        this.onDisplayedStatusChanged();
    }

    private void tgbLocalActionPerformed(ActionEvent actionEvent) {
        this.onDisplayedStatusChanged();
    }

    private void btnCommitActionPerformed(ActionEvent actionEvent) {
        this.onCommitAction();
    }

    private void btnRefreshActionPerformed(ActionEvent actionEvent) {
        this.onRefreshAction();
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SynchronizePanel.this.setupModels();
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set adjusted = new HashSet();

        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = SynchronizePanel.this.getSize();
            Dimension dimension2 = container.getSize();
            int n = dimension2.width - this.minimumLayoutSize((Container)container).width;
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (!jComponent.isVisible()) continue;
                jComponent.setLocation(n3, 0);
                Dimension dimension3 = jComponent.getPreferredSize();
                int n4 = dimension3.width;
                if (jComponent instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                if (jComponent instanceof JProgressBar && n > 0) {
                    n4 += n;
                }
                int n5 = this.getToolbarHeight(dimension) - 1;
                jComponent.setSize(n4, n5);
                n3 += n4;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = SynchronizePanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (component instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)component);
                } else {
                    this.adjustToolbarComponentSize((JComponent)component);
                }
                Dimension dimension2 = component.getPreferredSize();
                int n4 = dimension2.width;
                if (component instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                n3 += n4;
            }
            return new Dimension(n3, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = SynchronizePanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            return new Dimension(Integer.MAX_VALUE, n);
        }

        private int getToolbarHeight(Dimension dimension) {
            if (this.parentSize == null || !this.parentSize.equals(dimension)) {
                this.parentSize = dimension;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 10);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                int n = 0;
                String[] stringArray = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < stringArray.length; ++i) {
                    Font font = uIDefaults.getFont(stringArray[i]);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                    n = Math.max(n, fontMetrics.getHeight());
                }
                this.toolbarHeight = n + this.TOOLBAR_HEIGHT_ADJUSTMENT;
                if (dimension.height - dimension.width > 0) {
                    this.toolbarHeight += this.TOOLBAR_HEIGHT_ADJUSTMENT;
                }
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton abstractButton) {
            if (this.adjusted.contains(abstractButton)) {
                return;
            }
            if (!(abstractButton instanceof JToggleButton)) {
                abstractButton.setContentAreaFilled(false);
                abstractButton.setMargin(new Insets(0, 3, 0, 3));
                abstractButton.setBorderPainted(false);
                abstractButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(true);
                        abstractButton.setBorderPainted(true);
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(false);
                        abstractButton.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(abstractButton);
        }

        private void adjustToolbarComponentSize(JComponent jComponent) {
            if (this.adjusted.contains(jComponent)) {
                return;
            }
            if (jComponent.getBorder() instanceof CompoundBorder) {
                Dimension dimension = jComponent.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    dimension.width += 9;
                }
                jComponent.setPreferredSize(dimension);
            }
            this.adjusted.add(jComponent);
        }
    }
}

