/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;

public abstract class CommandDuplicator {
    public static CommandDuplicator getDuplicator(Command command) {
        if (command instanceof CommitCommand) {
            return new CommitCloner((CommitCommand)command);
        }
        if (command instanceof UpdateCommand) {
            return new UpdateCloner((UpdateCommand)command);
        }
        if (command instanceof RemoveCommand) {
            return new RemoveCloner((RemoveCommand)command);
        }
        if (command instanceof RtagCommand) {
            return new RtagCloner((RtagCommand)command);
        }
        if (command instanceof RlogCommand) {
            return new RlogCloner((RlogCommand)command);
        }
        if (command instanceof TagCommand) {
            return new TagCloner((TagCommand)command);
        }
        throw new IllegalArgumentException("Clone not supported for command type: " + command.getClass().getName());
    }

    public abstract Command duplicate();

    private static class CommitCloner
    extends CommandDuplicator {
        private final CommitCommand sample;

        public CommitCloner(CommitCommand commitCommand) {
            this.sample = commitCommand;
        }

        public Command duplicate() {
            CommitCommand commitCommand = new CommitCommand();
            commitCommand.setForceCommit(this.sample.isForceCommit());
            commitCommand.setLogMessageFromFile(this.sample.getLogMessageFromFile());
            commitCommand.setMessage(this.sample.getMessage());
            commitCommand.setNoModuleProgram(this.sample.isNoModuleProgram());
            commitCommand.setRecursive(this.sample.isRecursive());
            commitCommand.setToRevisionOrBranch(this.sample.getToRevisionOrBranch());
            return commitCommand;
        }
    }

    private static class RemoveCloner
    extends CommandDuplicator {
        private final RemoveCommand sample;

        public RemoveCloner(RemoveCommand removeCommand) {
            this.sample = removeCommand;
        }

        public Command duplicate() {
            RemoveCommand removeCommand = new RemoveCommand();
            removeCommand.setDeleteBeforeRemove(this.sample.isDeleteBeforeRemove());
            removeCommand.setIgnoreLocallyExistingFiles(this.sample.isIgnoreLocallyExistingFiles());
            removeCommand.setRecursive(this.sample.isRecursive());
            return removeCommand;
        }
    }

    private static class RlogCloner
    extends CommandDuplicator {
        private final RlogCommand sample;

        public RlogCloner(RlogCommand rlogCommand) {
            this.sample = rlogCommand;
        }

        public Command duplicate() {
            RlogCommand rlogCommand = new RlogCommand();
            rlogCommand.setDateFilter(this.sample.getDateFilter());
            rlogCommand.setDefaultBranch(this.sample.isDefaultBranch());
            rlogCommand.setHeaderAndDescOnly(this.sample.isHeaderAndDescOnly());
            rlogCommand.setHeaderOnly(this.sample.isHeaderOnly());
            rlogCommand.setNoTags(this.sample.isNoTags());
            rlogCommand.setRevisionFilter(this.sample.getRevisionFilter());
            rlogCommand.setStateFilter(this.sample.getStateFilter());
            rlogCommand.setSuppressHeader(this.sample.isSuppressHeader());
            rlogCommand.setUserFilter(this.sample.getUserFilter());
            rlogCommand.setModules(this.sample.getModules());
            rlogCommand.setRecursive(this.sample.isRecursive());
            return rlogCommand;
        }
    }

    private static class RtagCloner
    extends CommandDuplicator {
        private final RtagCommand sample;

        public RtagCloner(RtagCommand rtagCommand) {
            this.sample = rtagCommand;
        }

        public Command duplicate() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setClearFromRemoved(this.sample.isClearFromRemoved());
            rtagCommand.setDeleteTag(this.sample.isDeleteTag());
            rtagCommand.setMakeBranchTag(this.sample.isMakeBranchTag());
            rtagCommand.setMatchHeadIfRevisionNotFound(this.sample.isMatchHeadIfRevisionNotFound());
            rtagCommand.setModules(this.sample.getModules());
            rtagCommand.setNoExecTagProgram(this.sample.isNoExecTagProgram());
            rtagCommand.setOverrideExistingTag(this.sample.isOverrideExistingTag());
            rtagCommand.setTag(this.sample.getTag());
            rtagCommand.setTagByDate(this.sample.getTagByDate());
            rtagCommand.setTagByRevision(this.sample.getTagByRevision());
            rtagCommand.setRecursive(this.sample.isRecursive());
            return rtagCommand;
        }
    }

    private static class TagCloner
    extends CommandDuplicator {
        private final TagCommand sample;

        public TagCloner(TagCommand tagCommand) {
            this.sample = tagCommand;
        }

        public Command duplicate() {
            TagCommand tagCommand = new TagCommand();
            tagCommand.setDeleteTag(this.sample.isDeleteTag());
            tagCommand.setMakeBranchTag(this.sample.isMakeBranchTag());
            tagCommand.setMatchHeadIfRevisionNotFound(this.sample.isMatchHeadIfRevisionNotFound());
            tagCommand.setOverrideExistingTag(this.sample.isOverrideExistingTag());
            tagCommand.setTag(this.sample.getTag());
            tagCommand.setTagByDate(this.sample.getTagByDate());
            tagCommand.setTagByRevision(this.sample.getTagByRevision());
            tagCommand.setRecursive(this.sample.isRecursive());
            tagCommand.setCheckThatUnmodified(this.sample.isCheckThatUnmodified());
            return tagCommand;
        }
    }

    private static class UpdateCloner
    extends CommandDuplicator {
        private final UpdateCommand sample;

        public UpdateCloner(UpdateCommand updateCommand) {
            this.sample = updateCommand;
        }

        public Command duplicate() {
            UpdateCommand updateCommand = new UpdateCommand();
            updateCommand.setBuildDirectories(this.sample.isBuildDirectories());
            updateCommand.setCleanCopy(this.sample.isCleanCopy());
            updateCommand.setKeywordSubst(this.sample.getKeywordSubst());
            updateCommand.setMergeRevision1(this.sample.getMergeRevision1());
            updateCommand.setMergeRevision2(this.sample.getMergeRevision2());
            updateCommand.setPipeToOutput(this.sample.isPipeToOutput());
            updateCommand.setPruneDirectories(this.sample.isPruneDirectories());
            updateCommand.setResetStickyOnes(this.sample.isResetStickyOnes());
            updateCommand.setUpdateByDate(this.sample.getUpdateByDate());
            updateCommand.setUpdateByRevision(this.sample.getUpdateByRevision());
            updateCommand.setUseHeadIfNotFound(this.sample.isUseHeadIfNotFound());
            updateCommand.setRecursive(this.sample.isRecursive());
            return updateCommand;
        }
    }
}

