/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.subversion;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.subversion.SubversionHyperlink;
import org.netbeans.modules.hudson.subversion.SvnUtils;
import org.openide.util.Exceptions;
import org.openide.windows.OutputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonSubversionSCM
implements HudsonSCM {
    private static final Logger LOG = Logger.getLogger(HudsonSubversionSCM.class.getName());

    public HudsonSCM.Configuration forFolder(File file) {
        try {
            SvnUtils.Info info = SvnUtils.parseCheckout(file.toURI().toURL());
            if (info == null) {
                return null;
            }
            final String string = info.module.toString();
            return new HudsonSCM.Configuration(){

                public void configure(Document document) {
                    Element element = document.getDocumentElement();
                    Element element2 = (Element)element.appendChild(document.createElement("scm"));
                    element2.setAttribute("class", "hudson.scm.SubversionSCM");
                    Element element3 = (Element)element2.appendChild(document.createElement("locations")).appendChild(document.createElement("hudson.scm.SubversionSCM_-ModuleLocation"));
                    element3.appendChild(document.createElement("remote")).appendChild(document.createTextNode(string));
                    element3.appendChild(document.createElement("local")).appendChild(document.createTextNode("."));
                    element2.appendChild(document.createElement("useUpdate")).appendChild(document.createTextNode("false"));
                    HudsonSCM.Helper.addTrigger((Document)document);
                }

                public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems() {
                    return null;
                }
            };
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "inspecting configuration for " + file, iOException);
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public String translateWorkspacePath(HudsonJob hudsonJob, String string, File file) {
        try {
            String string2;
            SvnUtils.Info info = SvnUtils.parseCheckout(file.toURI().toURL());
            if (info == null) {
                return null;
            }
            int n = string.lastIndexOf(47);
            String string3 = string.substring(0, n + 1);
            String string4 = string.substring(n + 1);
            URL uRL = new URL(hudsonJob.getUrl() + "ws/" + string3);
            SvnUtils.Info info2 = SvnUtils.parseCheckout(uRL, hudsonJob);
            if (info2 == null) {
                LOG.log(Level.FINE, "no remote checkout found at {0}", uRL);
                return null;
            }
            if (!info2.repository.getPath().equals(info.repository.getPath())) {
                LOG.log(Level.FINE, "repository mismatch between {0} and {1}", new Object[]{info2.repository, info.repository});
                return null;
            }
            String string5 = new URL(info2.module + "/" + string4).getPath();
            if (!string5.startsWith(string2 = new URL(info.module + "/").getPath())) {
                LOG.log(Level.FINE, "checkout mismatch between {0} and {1}", new Object[]{string2, string5});
                return null;
            }
            String string6 = string5.substring(string2.length());
            LOG.log(Level.FINE, "translated path as {0}", string6);
            return string6;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "cannot translate path", exception);
            return null;
        }
    }

    public List<? extends HudsonJobChangeItem> parseChangeSet(final HudsonJob hudsonJob, final Element element) {
        if (!"svn".equals(HudsonSCM.Helper.xpath((String)"kind", (Element)element))) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SubversionItem
        implements HudsonJobChangeItem {
            final Element itemXML;

            SubversionItem(Element element3) {
                this.itemXML = element3;
            }

            public String getUser() {
                return HudsonSCM.Helper.xpath((String)"user", (Element)this.itemXML);
            }

            public String getMessage() {
                return HudsonSCM.Helper.xpath((String)"msg", (Element)this.itemXML);
            }

            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                class SubversionFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final Element fileXML;

                    SubversionFile(Element element) {
                        this.fileXML = element;
                    }

                    public String getName() {
                        return HudsonSCM.Helper.xpath((String)"file", (Element)this.fileXML);
                    }

                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return HudsonJobChangeItem.HudsonJobChangeFile.EditType.valueOf((String)HudsonSCM.Helper.xpath((String)"editType", (Element)this.fileXML));
                    }

                    public OutputListener hyperlink() {
                        int n;
                        int n2;
                        String string = HudsonSCM.Helper.xpath((String)"revision/module", (Element)element);
                        String string2 = HudsonSCM.Helper.xpath((String)"revision", (Element)itemXML);
                        if (string == null || !string.startsWith("http") || string2 == null) {
                            return null;
                        }
                        int n3 = Integer.parseInt(string2);
                        String string3 = this.getName();
                        switch (this.getEditType()) {
                            case edit: {
                                n2 = n3 - 1;
                                n = n3;
                                break;
                            }
                            case add: {
                                n2 = 0;
                                n = n3;
                                break;
                            }
                            case delete: {
                                n2 = n3 - 1;
                                n = 0;
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        return new SubversionHyperlink(string, string3, n2, n, hudsonJob);
                    }
                }
                ArrayList<SubversionFile> arrayList = new ArrayList<SubversionFile>();
                NodeList nodeList = this.itemXML.getElementsByTagName("path");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add(new SubversionFile((Element)nodeList.item(i)));
                }
                return arrayList;
            }
        }
        ArrayList<SubversionItem> arrayList = new ArrayList<SubversionItem>();
        NodeList nodeList = element.getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(new SubversionItem((Element)nodeList.item(i)));
        }
        return arrayList;
    }
}

