/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientResponseTracker;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LiveReceiver;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.util.StreamUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playReset = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{9, 0, 0, 0};
            int n = iClient.testFlashVersion(nArray);
            return n >= 0;
        }
        return false;
    }

    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        Object object;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket5, (long)l, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            object = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(object, 0, ((byte[])object).length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket6, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket5, (long)l, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            object = null;
            aMFPacket4 = null;
            object = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            object.createSeekMessage("onStatus");
            object.setSrc(iMediaStream.getSrc());
            object.setType(18);
            object.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
            object.addBody((AMFData)aMFPacket4);
            n += object.write(outputStream, true, n2);
            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj3, (byte[])this.workBuffer, (int)n2);
        }
        if (aMFPacket3 != null) {
            byte by2 = (byte)aMFPacket3.getFirstByte();
            aMFPacket4 = null;
            if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
                aMFPacket4.addData(byArray, 0, byArray.length);
            }
            if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)this.getEnhanceSeekPacket(iMediaStream, by2, true), (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            }
            if (aMFPacket4 != null) {
                lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
                lArray[3] = lArray[3] + 1L;
                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket4, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            }
            lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
            lArray[3] = lArray[3] + 1L;
            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket3, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)this.getEnhanceSeekPacket(iMediaStream, by2, false), (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            }
            if (aMFPacket2 != null) {
                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket2, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
            }
        }
        return n;
    }

    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        if (wMSProperties != null) {
            this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean("disableLowBandwidthThrottling", this.disableLowBandwidthThrottling);
            this.instantOn = wMSProperties.getPropertyBoolean("instantOn", this.instantOn);
            this.waitForBufferFill = wMSProperties.getPropertyBoolean("waitForBufferFill", this.waitForBufferFill);
            this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean("waitForBufferKeyFrame", this.waitForBufferKeyFrame);
            this.behindDropDFrames = wMSProperties.getPropertyInt("behindDropDFrames", this.behindDropDFrames);
            this.behindDropPFrames = wMSProperties.getPropertyInt("behindDropPFrames", this.behindDropPFrames);
            this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt("behindDropKFrames", this.behindDropKFrames);
            this.behindDropAudio = wMSProperties.getPropertyInt("behindDropAudio", this.behindDropAudio);
            this.maximumLiveLatency = wMSProperties.getPropertyInt("maxliveaudiolatency", this.maximumLiveLatency);
        }
        this.isDebugLog = WMSLoggerFactory.getLogger(LiveReceiver.class).isDebugEnabled();
    }

    protected boolean testVideoFrame(int n, int n2) {
        return (n & 1 << ((n2 & 0x30) >> 4) - 1) != 0;
    }

    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.workBuffer = new byte[n];
        }
    }

    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            this.isEnhancedSeekCapable = this.isEnhancedSeekCapable(this.stream.getParent());
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playReset);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object2;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object2 = null;
                            AMFDataObj aMFDataObj = null;
                            object2 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object2.createSeekMessage("onStatus");
                            object2.setSrc(this.stream.getParent().getSrc());
                            object2.setType(18);
                            object2.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
                            object2.addBody((AMFData)aMFDataObj);
                            n += object2.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket4, (long)l, (AMFObj)aMFObj3, (byte[])this.workBuffer, (int)n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket5, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), true), (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), false), (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket3, (long)l, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object2 = new byte[5];
                        object2[0] = (ResponseFunction)23;
                        object2[1] = (ResponseFunction)2;
                        object2[2] = (ResponseFunction)false;
                        object2[3] = (ResponseFunction)false;
                        object2[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object2, 0, ((ResponseFunction)object2).length);
                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket2, (long)l, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n2);
                    }
                    if (iMediaStream.isSendPlayStopLogEvent()) {
                        iMediaStream.setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
        }
        return n;
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n2 = -1;
        Object object = this.stream.getParent();
        synchronized (object) {
            bl = this.stream.getParent().isReceiveAudio();
            bl2 = this.stream.getParent().isReceiveVideo();
            n2 = this.stream.getParent().getReceiveVideoFPS();
        }
        object = this.lock;
        synchronized (object) {
            String string;
            ClientWriteListener clientWriteListener;
            LiveTracker liveTracker;
            long l;
            int n3;
            block101: {
                int n4;
                int n5;
                long l2;
                AMFPacket aMFPacket;
                int n6;
                AMFPacket aMFPacket2;
                boolean bl3;
                int n7;
                List list;
                block102: {
                    AMFPacket aMFPacket3;
                    AMFPacket aMFPacket4;
                    block100: {
                        list = this.getPlayPackets(iMediaStream);
                        aMFPacket4 = iMediaStream.getLastKeyFrame();
                        if (this.sendFirstKeyFrame) {
                            this.isEnhancedSeekCapable = this.isEnhancedSeekCapable(this.stream.getParent());
                        }
                        Client client = (Client)this.stream.getParent().getClient();
                        n7 = client.getSendChunkSize();
                        n3 = 7;
                        bl3 = false;
                        l = 0L;
                        aMFPacket2 = null;
                        liveTracker = null;
                        clientWriteListener = client.getWriteListener();
                        string = "stream" + this.stream.getParent().getSrc();
                        n6 = list.size();
                        if (n6 != 0) break block100;
                        this.bufferEmptyOnce = true;
                        break block101;
                    }
                    aMFPacket = (AMFPacket)list.get(0);
                    if (!this.waitForBufferFill || !this.sendFirstKeyFrame) break block102;
                    boolean bl4 = true;
                    long l3 = System.currentTimeMillis();
                    l2 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                    if (this.waitForBufferFillStarTime == -1L) {
                        this.waitForBufferFillStarTime = l3;
                    } else if (l3 - this.waitForBufferFillStarTime > l2 && !this.waitForBufferKeyFrame) {
                        bl4 = false;
                    }
                    if (!bl4 || l2 <= 0L) break block102;
                    AMFPacket aMFPacket5 = (AMFPacket)list.get(n6 - 1);
                    if (aMFPacket5.getAbsTimecode() - aMFPacket.getAbsTimecode() < l2) break block101;
                    if (!this.waitForBufferKeyFrame || aMFPacket4 != null) break block102;
                    n5 = 0;
                    for (int i = 0; i < n6 && ((aMFPacket3 = (AMFPacket)list.get(i)).getType() != 9 || ++n5 <= 2); ++i) {
                    }
                    if (n5 > 2) break block101;
                }
                long l4 = aMFPacket.getSeq();
                int n8 = n4 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - l4 + 1L);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 < n6) {
                    ClientResponseTracker clientResponseTracker;
                    LiveTracker liveTracker2;
                    long l5;
                    if ((!this.bufferEmptyOnce || this.waitForBufferFill) && this.instantOn && this.sendFirstKeyFrame) {
                        l2 = -1L;
                        n5 = -1;
                        this.trackerBufferTime = 0L;
                        long l6 = this.stream.getParent().getBufferTime();
                        for (int i = n6 - 1; i >= 0; --i) {
                            aMFPacket = (AMFPacket)list.get(i);
                            int n9 = aMFPacket.getType();
                            if (n9 != 9 && n9 != 8) continue;
                            l5 = aMFPacket.getAbsTimecode();
                            if (l2 == -1L) {
                                l2 = l5;
                            } else {
                                if (n5 == -1) {
                                    this.trackerBufferTime = l2 - l5;
                                }
                                if (n5 == -1 && l2 - l5 > l6) {
                                    n5 = i;
                                }
                            }
                            if (n9 == 9) {
                                boolean bl5 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
                                if (this.isEnhancedSeekCapable) {
                                    if (n5 != -1 && bl5) {
                                        aMFPacket2 = aMFPacket;
                                        break;
                                    }
                                } else if (bl5) {
                                    aMFPacket2 = aMFPacket;
                                }
                            }
                            if (!this.isEnhancedSeekCapable && n5 != -1) break;
                        }
                        int n10 = n4 = n5 < 0 ? 0 : n5;
                    }
                    if (n4 == 0 && this.lastSeq != -1L && (aMFPacket = (AMFPacket)list.get(n4)).getSeq() != this.lastSeq + 1L) {
                        this.waitForKeyFrame = true;
                    }
                    LiveTracker liveTracker3 = liveTracker2 = (clientResponseTracker = clientWriteListener.getLastTracker()) == null ? null : (LiveTracker)clientResponseTracker.getInfo(string);
                    if (liveTracker2 != null && this.lastSentLiveTracker != null && liveTracker2.trackerSeq >= this.trackerStartSeq) {
                        long l7;
                        long l8 = clientResponseTracker.getSent();
                        long l9 = liveTracker2.firstTC + (liveTracker2.lastTC - liveTracker2.firstTC) * l8 / (l7 = clientResponseTracker.getSize());
                        l = this.lastSentLiveTracker.lastTC - l9 - this.trackerBufferTime;
                        if (l > (long)this.behindDropAudio) {
                            bl3 = true;
                        }
                        if (l > (long)this.behindDropKFrames) {
                            n3 = 0;
                        } else if (l > (long)this.behindDropPFrames) {
                            n3 = 1;
                        } else if (l > (long)this.behindDropDFrames) {
                            n3 = 3;
                        }
                        if (this.lastTCFilter != n3) {
                            WMSLoggerFactory.getLogger(LivePlayer.class).debug("Filter[" + string + "]: filter:(" + this.lastTCFilter + "-" + n3 + ") offset:" + l + " sentTC:" + this.lastSentLiveTracker.lastTC + " receivedTC:" + liveTracker2.lastTC + " bufferTime:" + this.trackerBufferTime + " tc:" + this.lastTC);
                        }
                        this.lastTCFilter = n3;
                        if (this.disableLowBandwidthThrottling) {
                            n3 = 7;
                        }
                    }
                    this.lastTCOffset = l;
                    int n11 = n2;
                    if (n11 < -1) {
                        if (n11 == -2 && n3 == 7) {
                            n3 = 3;
                        } else if (n11 == -3 && (n3 == 7 || n3 == 3)) {
                            n3 = 1;
                            this.waitForKeyFrame = true;
                        }
                    }
                    if (!this.sendFirstKeyFrame && this.lastReceiveVideo != bl2) {
                        if (bl2) {
                            this.waitForKeyFrame = true;
                        }
                        this.lastReceiveVideo = bl2;
                    }
                    this.checkWorkBuffer(n7);
                    long l10 = -1L;
                    for (int i = n4; i < n6; ++i) {
                        int n12;
                        aMFPacket = (AMFPacket)list.get(i);
                        AMFObj aMFObj4 = null;
                        l5 = aMFPacket.getAbsTimecode();
                        long l11 = 0L;
                        int n13 = aMFPacket.getType();
                        switch (n13) {
                            case 8: {
                                if (!bl || bl3) break;
                                if (this.firstPacketTC == -1L) {
                                    l11 = 0L;
                                    this.firstPacketTC = l5;
                                } else {
                                    l11 = l5 - this.firstPacketTC;
                                    if (l11 < 0L) {
                                        l11 = 0L;
                                    }
                                }
                                aMFObj4 = aMFObj;
                                this.lastTC = l11;
                                this.lastAudioTC = l11;
                                lArray[0] = lArray[0] + (long)aMFPacket.getSize();
                                lArray[1] = lArray[1] + 1L;
                                break;
                            }
                            case 9: {
                                boolean bl6;
                                if (!bl2) break;
                                n12 = aMFPacket.getFirstByte();
                                int n14 = FLVUtils.getFrameType((int)n12);
                                boolean bl7 = bl6 = n3 == 7;
                                if (!bl6) {
                                    bl6 = this.testVideoFrame(n3, n12);
                                }
                                if (bl6) {
                                    if (this.waitForKeyFrame) {
                                        if (!FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket)) break;
                                        WMSLoggerFactory.getLogger(LivePlayer.class).debug("waitForKeyFrame: found");
                                        this.waitForKeyFrame = false;
                                    }
                                    if (this.firstPacketTC == -1L) {
                                        l11 = 0L;
                                        this.firstPacketTC = l5;
                                    } else {
                                        l11 = l5 - this.firstPacketTC;
                                        if (l11 < 0L) {
                                            l11 = 0L;
                                        }
                                    }
                                    aMFObj4 = aMFObj2;
                                    this.lastTC = l11;
                                    this.lastVideoTC = l11;
                                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                                    lArray[3] = lArray[3] + 1L;
                                    break;
                                }
                                lArray[6] = lArray[6] + (long)aMFPacket.getSize();
                                lArray[7] = lArray[7] + 1L;
                                break;
                            }
                            case 15: 
                            case 18: {
                                if (this.firstPacketTC == -1L) {
                                    l11 = 0L;
                                    this.firstPacketTC = l5;
                                } else {
                                    l11 = l5 - this.firstPacketTC;
                                    if (l11 < 0L) {
                                        l11 = 0L;
                                    }
                                }
                                aMFObj4 = aMFObj3;
                                this.lastTC = l11;
                                this.lastDataTC = l11;
                                lArray[4] = lArray[4] + (long)aMFPacket.getSize();
                                lArray[5] = lArray[5] + 1L;
                                break;
                            }
                            default: {
                                WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info("Info: WMSRespStreams: outputSingle: unkown packet type: " + aMFPacket.getType());
                            }
                        }
                        if (aMFObj4 != null) {
                            if (!this.sentPlayStart) {
                                if (this.sendPlayStop) {
                                    n += this.stream.getParent().sendPlayStop(outputStream, l11, this.stream.getParent().getName());
                                    this.sendPlayStop = false;
                                }
                                n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l11, this.firstPacketTC);
                                this.sentPlayStart = true;
                                this.sendPlayStop = true;
                                this.stream.getParent().setSendPlayStopLogEvent(true);
                                WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(0L));
                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "play", 200, this.stream.getParent().getName());
                                this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playReset);
                                aMFObj3.setNew(true);
                                aMFObj.setNew(true);
                                aMFObj2.setNew(true);
                            }
                            if (liveTracker == null) {
                                liveTracker = new LiveTracker();
                                liveTracker.firstTC = l5;
                            }
                            liveTracker.lastTC = l5;
                            n12 = 0;
                            if (this.sendFirstKeyFrame) {
                                long l12;
                                IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                                if (iMediaStreamMetaDataProvider != null) {
                                    ArrayList arrayList = new ArrayList();
                                    l12 = aMFPacket.getAbsTimecode();
                                    iMediaStreamMetaDataProvider.onStreamStart(arrayList, l12);
                                    if (arrayList.size() > 0) {
                                        ResponseFunction responseFunction = null;
                                        AMFDataObj aMFDataObj = null;
                                        responseFunction = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                        responseFunction.createSeekMessage("onStatus");
                                        responseFunction.setSrc(this.stream.getParent().getSrc());
                                        responseFunction.setType(18);
                                        responseFunction.setTimecode(l11);
                                        aMFDataObj = new AMFDataObj();
                                        aMFDataObj.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
                                        responseFunction.addBody((AMFData)aMFDataObj);
                                        n += responseFunction.write(outputStream, true, n7);
                                        for (AMFPacket aMFPacket6 : arrayList) {
                                            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket6, (long)l11, (AMFObj)aMFObj3, (byte[])this.workBuffer, (int)n7);
                                        }
                                    }
                                }
                                boolean bl8 = true;
                                if (aMFPacket2 == null) {
                                    aMFPacket2 = this.getLastKeyFrame(iMediaStream);
                                    bl8 = false;
                                }
                                if (!bl2) {
                                    aMFPacket2 = null;
                                }
                                if (aMFPacket2 != null) {
                                    if (this.sendFirstVideoFrame) {
                                        AMFPacket aMFPacket7 = iMediaStream.getVideoCodecConfigPacket(aMFPacket2.getAbsTimecode());
                                        if (aMFPacket7 != null) {
                                            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket7, (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                                        }
                                        this.sendFirstVideoFrame = false;
                                        n12 = 1;
                                    }
                                    if (n12 != 0 && this.isEnhancedSeekCapable) {
                                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket2.getFirstByte(), true), (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                                    }
                                    lArray[2] = lArray[2] + (long)aMFPacket2.getSize();
                                    lArray[3] = lArray[3] + 1L;
                                    n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket2, (long)l11, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n7);
                                    aMFObj2.setNew(true);
                                    if (this.isEnhancedSeekCapable) {
                                        l12 = aMFPacket2.getSeq();
                                        int n15 = (int)(l12 - l4 + 1L);
                                        if (bl8) {
                                            this.waitForKeyFrame = false;
                                        }
                                        if (bl8 && n15 >= 0 && n15 < n6) {
                                            for (int j = n15; j < i; ++j) {
                                                AMFPacket aMFPacket8 = (AMFPacket)list.get(j);
                                                if (aMFPacket8.getType() != 9) continue;
                                                lArray[2] = lArray[2] + (long)aMFPacket8.getSize();
                                                lArray[3] = lArray[3] + 1L;
                                                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket8, (long)l11, (AMFObj)aMFObj2, (byte[])this.workBuffer, (int)n7);
                                            }
                                        }
                                    }
                                    if (n12 != 0 && this.isEnhancedSeekCapable) {
                                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket2.getFirstByte(), false), (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                                    }
                                    n12 = 0;
                                }
                                this.trackerStartSeq = liveTracker.trackerSeq;
                                this.sendFirstKeyFrame = false;
                                this.lastReceiveAudio = bl;
                                this.lastReceiveVideo = bl2;
                                this.lastReceiveVideoFPS = n2;
                            } else if (this.lastReceiveAudio != bl) {
                                AMFPacket aMFPacket9;
                                if (bl) {
                                    n += this.stream.getParent().sendLivePlaySeek(outputStream, this.stream.getParent().getName(), l11);
                                }
                                if ((aMFPacket9 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                                    lArray[0] = lArray[0] + 0L;
                                    lArray[1] = lArray[1] + 1L;
                                    n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket9, (long)l11, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)n7);
                                }
                                this.lastReceiveAudio = bl;
                            }
                            if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) {
                                if (n13 == 8 && this.sendFirstAudioFrame) {
                                    AMFPacket aMFPacket10;
                                    AMFPacket aMFPacket11 = new AMFPacket(8, iMediaStream.getSrc(), 0);
                                    if (aMFPacket11 != null) {
                                        lArray[0] = lArray[0] + 0L;
                                        lArray[1] = lArray[1] + 1L;
                                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket11, (long)l11, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)n7);
                                        aMFObj.setNew(true);
                                    }
                                    if ((aMFPacket10 = iMediaStream.getAudioCodecConfigPacket(aMFPacket.getAbsTimecode())) != null) {
                                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket10, (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                                    }
                                    this.sendFirstAudioFrame = false;
                                } else if (n13 == 9 && this.sendFirstVideoFrame) {
                                    AMFPacket aMFPacket12 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                                    if (aMFPacket12 != null) {
                                        n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket12, (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                                    }
                                    this.sendFirstVideoFrame = false;
                                    n12 = 1;
                                }
                            }
                            if (n12 != 0 && this.isEnhancedSeekCapable) {
                                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), true), (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                            }
                            n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)aMFPacket, (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                            if (n12 != 0 && this.isEnhancedSeekCapable) {
                                n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)this.stream.getParent(), (AMFPacket)this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), false), (long)l11, (AMFObj)aMFObj4, (byte[])this.workBuffer, (int)n7);
                            }
                            n12 = 0;
                        }
                        l10 = aMFPacket.getSeq();
                        if (!(this.playLen > 0.0) || l11 < Math.round(this.playLen)) continue;
                        if (iMediaStream.isSendPlayStopLogEvent()) {
                            iMediaStream.setSendPlayStopLogEvent(false);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, this.stream.getParent().getName());
                            this.stream.getParent().notifyActionStop();
                        }
                        n += this.stream.getParent().sendPlayStatus(outputStream, l11, 2, 0.0, 0.0);
                        n += this.stream.getParent().sendPlayStop(outputStream, l11, this.stream.getParent().getName());
                        this.playlistEnd = true;
                        break;
                    }
                    if (n3 == 0 || n3 == 1) {
                        this.waitForKeyFrame = true;
                    }
                    if (l10 != -1L) {
                        this.lastSeq = l10;
                    }
                }
            }
            if (this.isDebugLog) {
                long l13 = System.currentTimeMillis();
                long l14 = this.lastSendTime == -1L ? 0L : l13 - this.lastSendTime;
                this.lastSendTime = l13;
                WMSLoggerFactory.getLogger(LivePlayer.class).debug("send[" + this.stream.getParent().getClientId() + "]: size:" + n + " filter:" + n3 + " time:" + l14 + " tOffset:" + l);
            }
            if (liveTracker != null) {
                liveTracker.totalLen = n;
                this.lastSentLiveTracker = liveTracker;
                clientWriteListener.getPendingTracker().putInfo(string, liveTracker);
            }
        }
        return n;
    }

    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen == 0.0) {
            return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream != null) {
            n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return n;
    }

    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
    }

    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        return iMediaStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            AMFPacket aMFPacket;
            IMediaStream iMediaStream;
            if (this.stream.getParent().isSendPlayStopLogEvent()) {
                this.stream.getParent().setSendPlayStopLogEvent(false);
                WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(this.lastTC));
                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
                this.stream.getParent().notifyActionStop();
            }
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            if (bl2 && (iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName())) != null && (aMFPacket = this.getLastPacket(iMediaStream)) != null) {
                this.lastSeq = aMFPacket.getSeq();
            }
        }
    }

    public void resetNoLookup() {
        this.resetInternal(true, false);
    }

    public void reset(boolean bl) {
        this.resetInternal(bl, true);
    }

    public void pause(int n, long l) {
    }

    public void seek(int n) {
    }

    public void setBufferTime(int n) {
    }

    public void shutdown() {
    }

    public void setName(String string, String string2, String string3, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playReset = n;
    }

    public void interruptPlay() {
    }

    public void startPlay() {
    }

    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (!WMSLoggerFactory.isGlobalLogValueSet((String)"x-spos")) {
            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(l));
        }
    }

    public double length() {
        return 0.0;
    }

    public long size() {
        return 0L;
    }

    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }
}

