/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.bugzilla.util.FileUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaConfig {
    private static BugzillaConfig instance = null;
    private static final String LAST_CHANGE_FROM = "bugzilla.last_change_from";
    private static final String REPO_ID = "bugzilla.repository_";
    private static final String QUERY_NAME = "bugzilla.query_";
    private static final String QUERY_REFRESH_INT = "bugzilla.query_refresh";
    private static final String QUERY_AUTO_REFRESH = "bugzilla.query_auto_refresh_";
    private static final String ISSUE_REFRESH_INT = "bugzilla.issue_refresh";
    private static final String DELIMITER = "<=>";
    private static final String CHECK_UPDATES = "jira.check_updates";
    private static final String TASKLISTISSUES_STORAGE_FILE = "tasklistissues.data";
    private static final Level LOG_LEVEL = BugzillaUtil.isAssertEnabled() ? Level.SEVERE : Level.INFO;
    public static final int DEFAULT_QUERY_REFRESH = 30;
    public static final int DEFAULT_ISSUE_REFRESH = 15;
    private Map<String, Icon> priorityIcons;

    private BugzillaConfig() {
    }

    public static BugzillaConfig getInstance() {
        if (instance == null) {
            instance = new BugzillaConfig();
        }
        return instance;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(BugzillaConfig.class);
    }

    public void setQueryRefreshInterval(int n) {
        this.getPreferences().putInt(QUERY_REFRESH_INT, n);
    }

    public void setIssueRefreshInterval(int n) {
        this.getPreferences().putInt(ISSUE_REFRESH_INT, n);
    }

    public void setQueryAutoRefresh(String string, boolean bl) {
        this.getPreferences().putBoolean(QUERY_AUTO_REFRESH + string, bl);
    }

    public void setCheckUpdates(boolean bl) {
        this.getPreferences().putBoolean(CHECK_UPDATES, bl);
    }

    public int getQueryRefreshInterval() {
        return this.getPreferences().getInt(QUERY_REFRESH_INT, 30);
    }

    public int getIssueRefreshInterval() {
        return this.getPreferences().getInt(ISSUE_REFRESH_INT, 15);
    }

    public boolean getQueryAutoRefresh(String string) {
        return this.getPreferences().getBoolean(QUERY_AUTO_REFRESH + string, false);
    }

    public boolean getCheckUpdates() {
        return this.getPreferences().getBoolean(CHECK_UPDATES, true);
    }

    public void putQuery(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery) {
        this.getPreferences().put(this.getQueryKey(bugzillaRepository.getID(), bugzillaQuery.getDisplayName()), bugzillaQuery.getUrlParameters() + DELIMITER + DELIMITER + bugzillaQuery.isUrlDefined());
    }

    public void removeQuery(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery) {
        this.getPreferences().remove(this.getQueryKey(bugzillaRepository.getID(), bugzillaQuery.getDisplayName()));
    }

    public BugzillaQuery getQuery(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getStoredQuery(bugzillaRepository, string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length >= 2);
        String string3 = stringArray[0];
        boolean bl = stringArray.length > 2 ? Boolean.parseBoolean(stringArray[2]) : false;
        return new BugzillaQuery(string, bugzillaRepository, string3, true, bl, true);
    }

    public String getUrlParams(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getStoredQuery(bugzillaRepository, string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length >= 2);
        return stringArray[0];
    }

    public String[] getQueries(String string) {
        return this.getKeysWithPrefix(QUERY_NAME + string + DELIMITER);
    }

    public void putRepository(String string, BugzillaRepository bugzillaRepository) {
        String string2 = bugzillaRepository.getDisplayName();
        String string3 = bugzillaRepository.getUsername();
        String string4 = BugtrackingUtil.scramble((String)bugzillaRepository.getPassword());
        String string5 = bugzillaRepository.getHttpUsername();
        String string6 = BugtrackingUtil.scramble((String)bugzillaRepository.getHttpPassword());
        String string7 = bugzillaRepository.getUrl();
        String string8 = Boolean.toString(bugzillaRepository.isShortUsernamesEnabled());
        this.getPreferences().put(REPO_ID + string, string7 + DELIMITER + string3 + DELIMITER + string4 + DELIMITER + string5 + DELIMITER + string6 + DELIMITER + string8 + DELIMITER + string2);
    }

    public BugzillaRepository getRepository(String string) {
        String string2 = this.getPreferences().get(REPO_ID + string, "");
        if (string2.equals("")) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length == 3 || stringArray.length == 6 || stringArray.length == 7);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = BugtrackingUtil.descramble((String)stringArray[2]);
        String string6 = stringArray.length > 3 ? stringArray[3] : null;
        String string7 = stringArray.length > 3 ? BugtrackingUtil.descramble((String)stringArray[4]) : null;
        boolean bl = false;
        if (stringArray.length > 5) {
            bl = Boolean.parseBoolean(stringArray[5]);
        }
        String string8 = stringArray.length > 6 ? stringArray[6] : string;
        return new BugzillaRepository(string, string8, string3, string4, string5, string6, string7, bl);
    }

    public String[] getRepositories() {
        return this.getKeysWithPrefix(REPO_ID);
    }

    public void removeRepository(String string) {
        this.getPreferences().remove(REPO_ID + string);
    }

    private String[] getKeysWithPrefix(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.getPreferences().keys();
        }
        catch (BackingStoreException backingStoreException) {
            Bugzilla.LOG.log(Level.SEVERE, null, backingStoreException);
        }
        if (stringArray == null || stringArray.length == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2.substring(string.length()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getQueryKey(String string, String string2) {
        return QUERY_NAME + string + DELIMITER + string2;
    }

    private String getStoredQuery(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getPreferences().get(this.getQueryKey(bugzillaRepository.getID(), string), null);
        return string2;
    }

    public void setLastChangeFrom(String string) {
        this.getPreferences().put(LAST_CHANGE_FROM, string);
    }

    public String getLastChangeFrom() {
        return this.getPreferences().get(LAST_CHANGE_FROM, "");
    }

    public Icon getPriorityIcon(String string) {
        if (this.priorityIcons == null) {
            this.priorityIcons = new HashMap<String, Icon>();
            this.priorityIcons.put("P1", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p1.png", (boolean)true));
            this.priorityIcons.put("P2", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p2.png", (boolean)true));
            this.priorityIcons.put("P3", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p3.png", (boolean)true));
            this.priorityIcons.put("P4", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p4.png", (boolean)true));
            this.priorityIcons.put("P5", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p5.png", (boolean)true));
        }
        return this.priorityIcons.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskListIssues(HashMap<String, List<String>> hashMap) {
        Bugzilla.LOG.fine("setTaskListIssues: saving issues");
        File file = new File(BugzillaConfig.getNBConfigPath());
        file.mkdirs();
        if (!file.canWrite()) {
            Bugzilla.LOG.warning("setTaskListIssues: Cannot create perm storage");
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        File file2 = new File(file, "tasklistissues.data.tmp");
        boolean bl = false;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            objectOutputStream.writeInt(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                objectOutputStream.writeUTF((String)entry.getKey());
                objectOutputStream.writeInt(((List)entry.getValue()).size());
                for (String string : (List)entry.getValue()) {
                    objectOutputStream.writeUTF(string);
                }
            }
            bl = true;
        }
        catch (IOException iOException) {
            Bugzilla.LOG.log(LOG_LEVEL, null, iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl) {
            bl = false;
            File file3 = new File(file, TASKLISTISSUES_STORAGE_FILE);
            try {
                FileUtils.renameFile(file2, file3);
            }
            catch (IOException iOException) {
                Bugzilla.LOG.log(LOG_LEVEL, null, iOException);
                bl = false;
            }
        }
        if (!bl) {
            Bugzilla.LOG.warning("setTaskListIssues: could not save issues");
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getTaskListIssues() {
        Bugzilla.LOG.fine("loadTaskListIssues: loading issues");
        File file = new File(BugzillaConfig.getNBConfigPath());
        ObjectInputStream objectInputStream = null;
        File file2 = new File(file, TASKLISTISSUES_STORAGE_FILE);
        if (!file2.canRead()) {
            Bugzilla.LOG.fine("loadTaskListIssues: no saved data");
            return Collections.emptyMap();
        }
        try {
            Object object;
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file2)));
            int n = objectInputStream.readInt();
            Bugzilla.LOG.fine("loadTaskListIssues: loading " + n + " records");
            HashMap hashMap = new HashMap(n);
            while (n-- > 0) {
                object = objectInputStream.readUTF();
                Bugzilla.LOG.fine("loadTaskListIssues: loading issues for " + (String)object);
                int n2 = objectInputStream.readInt();
                Bugzilla.LOG.fine("loadTaskListIssues: loading " + n2 + " issues");
                LinkedList<String> linkedList = new LinkedList<String>();
                while (n2-- > 0) {
                    linkedList.add(objectInputStream.readUTF());
                }
                hashMap.put(object, linkedList);
            }
            object = hashMap;
            return object;
        }
        catch (IOException iOException) {
            Bugzilla.LOG.log(LOG_LEVEL, null, iOException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.emptyMap();
    }

    private static String getNBConfigPath() {
        String string = System.getProperty("netbeans.t9y.bugzilla.nb.config.path");
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = System.getProperty("netbeans.user");
        return string2 + "/config/issue-tracking/org-netbeans-modules-bugzilla";
    }
}

